/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.data;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class PartitionedBroadcast<T extends CacheBlock>
implements Serializable {
    private static final long serialVersionUID = 7041959166079438401L;
    protected static final long BROADCAST_PARTSIZE = 0xF000000L;
    private Broadcast<PartitionedBlock<T>>[] _pbc = null;
    private MatrixCharacteristics _mc;

    public PartitionedBroadcast() {
    }

    public PartitionedBroadcast(Broadcast<PartitionedBlock<T>>[] broadcasts, MatrixCharacteristics mc) {
        this._pbc = broadcasts;
        this._mc = mc;
    }

    public Broadcast<PartitionedBlock<T>>[] getBroadcasts() {
        return this._pbc;
    }

    public long getNumRows() {
        return this._mc.getRows();
    }

    public long getNumCols() {
        return this._mc.getCols();
    }

    public int getNumRowBlocks() {
        return (int)this._mc.getNumRowBlocks();
    }

    public int getNumColumnBlocks() {
        return (int)this._mc.getNumColBlocks();
    }

    public static int computeBlocksPerPartition(long rlen, long clen, long brlen, long bclen) {
        return (int)Math.floor(0xF000000L / Math.min(rlen, brlen) / Math.min(clen, bclen));
    }

    public T getBlock(int rowIndex, int colIndex) throws DMLRuntimeException {
        int pix = 0;
        if (this._pbc.length > 1) {
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(this._mc.getRows(), this._mc.getCols(), this._mc.getRowsPerBlock(), this._mc.getColsPerBlock());
            int ix = (rowIndex - 1) * this.getNumColumnBlocks() + (colIndex - 1);
            pix = ix / numPerPart;
        }
        return ((PartitionedBlock)this._pbc[pix].value()).getBlock(rowIndex, colIndex);
    }

    public T slice(long rl, long ru, long cl, long cu, T block) throws DMLRuntimeException {
        CacheBlock ret = null;
        for (Broadcast<PartitionedBlock<T>> bc : this._pbc) {
            PartitionedBlock pm = (PartitionedBlock)bc.value();
            T tmp = pm.slice(rl, ru, cl, cu, block);
            if (ret != null) {
                ret.merge((CacheBlock)tmp, false);
                continue;
            }
            ret = (CacheBlock)tmp;
        }
        return (T)ret;
    }

    public void destroy() {
        for (Broadcast<PartitionedBlock<T>> bvar : this._pbc) {
            SparkExecutionContext.cleanupBroadcastVariable(bvar);
        }
    }
}

