/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.IndexFunction;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class ComputationSPInstruction
extends SPInstruction {
    public CPOperand output;
    public CPOperand input1;
    public CPOperand input2;
    public CPOperand input3;

    protected ComputationSPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = null;
        this.output = out;
    }

    protected ComputationSPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.output = out;
    }

    public String getOutputVariableName() {
        return this.output.getName();
    }

    protected void updateUnaryOutputMatrixCharacteristics(SparkExecutionContext sec) throws DMLRuntimeException {
        this.updateUnaryOutputMatrixCharacteristics(sec, this.input1.getName(), this.output.getName());
    }

    protected void updateUnaryOutputMatrixCharacteristics(SparkExecutionContext sec, String nameIn, String nameOut) throws DMLRuntimeException {
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(nameIn);
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(nameOut);
        if (!mcOut.dimsKnown()) {
            if (!mc1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + mc1.toString() + " " + mcOut.toString());
            }
            mcOut.set(mc1.getRows(), mc1.getCols(), mc1.getRowsPerBlock(), mc1.getColsPerBlock());
        }
    }

    protected void updateBinaryOutputMatrixCharacteristics(SparkExecutionContext sec) throws DMLRuntimeException {
        boolean outer;
        MatrixCharacteristics mcIn1 = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcIn2 = sec.getMatrixCharacteristics(this.input2.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        boolean bl = outer = mcIn1.getRows() > 1L && mcIn1.getCols() == 1L && mcIn2.getRows() == 1L && mcIn2.getCols() > 1L;
        if (!mcOut.dimsKnown()) {
            if (!mcIn1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + mcIn1.toString() + " " + mcIn2.toString() + " " + mcOut.toString());
            }
            if (outer) {
                sec.getMatrixCharacteristics(this.output.getName()).set(mcIn1.getRows(), mcIn2.getCols(), mcIn1.getRowsPerBlock(), mcIn2.getColsPerBlock());
            } else {
                sec.getMatrixCharacteristics(this.output.getName()).set(mcIn1.getRows(), mcIn1.getCols(), mcIn1.getRowsPerBlock(), mcIn1.getRowsPerBlock());
            }
        }
    }

    protected void updateUnaryAggOutputMatrixCharacteristics(SparkExecutionContext sec, IndexFunction ixFn) throws DMLRuntimeException {
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (mcOut.dimsKnown()) {
            return;
        }
        if (!mc1.dimsKnown()) {
            throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + mc1.toString() + " " + mcOut.toString());
        }
        if (ixFn instanceof ReduceAll) {
            mcOut.set(1L, 1L, mc1.getRowsPerBlock(), mc1.getColsPerBlock());
        } else if (ixFn instanceof ReduceCol) {
            mcOut.set(mc1.getRows(), 1L, mc1.getRowsPerBlock(), mc1.getColsPerBlock());
        } else if (ixFn instanceof ReduceRow) {
            mcOut.set(1L, mc1.getCols(), mc1.getRowsPerBlock(), mc1.getColsPerBlock());
        }
    }
}

