/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReIndexOperator;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.UtilFunctions;

public class RangeBasedReIndexInstruction
extends UnaryMRInstructionBase {
    private IndexRange _ixrange = null;
    private boolean _forLeft = false;
    private long _rlenLhs = -1L;
    private long _clenLhs = -1L;

    private RangeBasedReIndexInstruction(Operator op, byte in, byte out, IndexRange rng, boolean forleft, long rlen, long clen, String istr) {
        super(MRInstruction.MRType.RightIndex, op, in, out);
        this.instString = istr;
        this._ixrange = rng;
        this._forLeft = forleft;
        this._rlenLhs = rlen;
        this._clenLhs = clen;
    }

    public void computeOutputCharacteristics(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) {
        if (this._forLeft) {
            mcOut.set(this._rlenLhs, this._clenLhs, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock(), -1L);
        } else {
            mcOut.set(this._ixrange.rowEnd - this._ixrange.rowStart + 1L, this._ixrange.colEnd - this._ixrange.colStart + 1L, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock(), -1L);
        }
    }

    public static RangeBasedReIndexInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 8);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        boolean forLeft = false;
        if (opcode.equalsIgnoreCase("rightIndexForLeft")) {
            forLeft = true;
        } else if (!opcode.equalsIgnoreCase("rightIndex")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a Select: " + str);
        }
        byte in = Byte.parseByte(parts[1]);
        IndexRange rng = new IndexRange(UtilFunctions.parseToLong(parts[2]), UtilFunctions.parseToLong(parts[3]), UtilFunctions.parseToLong(parts[4]), UtilFunctions.parseToLong(parts[5]));
        byte out = Byte.parseByte(parts[6]);
        long rlen = Long.parseLong(parts[7]);
        long clen = Long.parseLong(parts[8]);
        return new RangeBasedReIndexInstruction(new ReIndexOperator(), in, out, rng, forLeft, rlen, clen, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        if (this.input == this.output) {
            throw new DMLRuntimeException("input cannot be the same for output for " + this.instString);
        }
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
                if (this._forLeft) {
                    OperationsOnMatrixValues.performShift(in, this._ixrange, blockRowFactor, blockColFactor, this._rlenLhs, this._clenLhs, outlist);
                } else {
                    OperationsOnMatrixValues.performSlice(in, this._ixrange, blockRowFactor, blockColFactor, outlist);
                }
                for (IndexedMatrixValue ret : outlist) {
                    cachedValues.add(this.output, ret);
                }
            }
        }
    }
}

