/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysml.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;

public class CostEstimatorHops
extends CostEstimator {
    public static double DEFAULT_MEM_MR = -1.0;
    public static double DEFAULT_MEM_SP = 2.097152E7;
    private OptTreePlanMappingAbstract _map = null;

    public CostEstimatorHops(OptTreePlanMappingAbstract map) {
        this._map = map;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) throws DMLRuntimeException {
        double DEFAULT_MEM_REMOTE;
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        double d = DEFAULT_MEM_REMOTE = OptimizerUtils.isSparkExecutionMode() ? DEFAULT_MEM_SP : DEFAULT_MEM_MR;
        if (value >= DEFAULT_MEM_REMOTE) {
            if (h.getExecType() == LopProperties.ExecType.MR) {
                value = DEFAULT_MEM_REMOTE;
            } else if (h.getExecType() == LopProperties.ExecType.SPARK) {
                value = DEFAULT_MEM_REMOTE + h.getSpBroadcastSize();
            } else if (h.getExecType() == LopProperties.ExecType.CP && value >= OptimizerUtils.getLocalMemBudget()) {
                if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && h.getForcedExecType() == null) {
                    LOG.warn("Memory estimate larger than budget but CP exec type (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ").");
                }
                value = DEFAULT_MEM_REMOTE;
            } else if (h.getExecType() == null) {
                value = DEFAULT_MEM_REMOTE;
            }
        }
        if (h.getForcedExecType() == LopProperties.ExecType.MR || h.getForcedExecType() == LopProperties.ExecType.SPARK) {
            value = DEFAULT_MEM_REMOTE;
        }
        if (value <= 0.0) {
            LOG.warn("Cannot get memory estimate for hop (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ").");
            value = 1024.0;
        }
        LOG.trace("Memory estimate " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value));
        return value;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, LopProperties.ExecType et) throws DMLRuntimeException {
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        if (et != LopProperties.ExecType.CP) {
            value = DEFAULT_MEM_MR;
        }
        if (value <= 0.0) {
            value = 1024.0;
        }
        LOG.trace("Memory estimate (forced exec type) " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value));
        return value;
    }

    static {
        DEFAULT_MEM_MR = 2.097152E7;
        if (InfrastructureAnalyzer.isLocalMode()) {
            DEFAULT_MEM_MR += (double)InfrastructureAnalyzer.getRemoteMaxMemorySortBuffer();
        }
    }
}

