/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeMultiAgg;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFLoopNode;
import org.apache.sysml.hops.globalopt.gdfgraph.GDFNode;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ReblockSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class Explain {
    private static final boolean REPLACE_SPECIAL_CHARACTERS = true;
    private static final boolean SHOW_MEM_ABOVE_BUDGET = true;
    private static final boolean SHOW_LITERAL_HOPS = false;
    private static final boolean SHOW_DATA_DEPENDENCIES = true;
    private static final boolean SHOW_DATA_FLOW_PROPERTIES = true;
    private static int clusterID = 0;

    public static String display(DMLProgram prog, Program rtprog, ExplainType type, ExplainCounts counts) throws HopsException, DMLRuntimeException, LanguageException {
        if (counts == null) {
            counts = Explain.countDistributedOperations(rtprog);
        }
        return "# EXPLAIN (" + type.name() + "):\n" + Explain.explainMemoryBudget(counts) + "\n" + Explain.explainDegreeOfParallelism(counts) + Explain.explain(prog, rtprog, type, counts);
    }

    public static String explainMemoryBudget() {
        return Explain.explainMemoryBudget(new ExplainCounts());
    }

    public static String explainMemoryBudget(ExplainCounts counts) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Memory Budget local/remote = ");
        sb.append(OptimizerUtils.toMB(OptimizerUtils.getLocalMemBudget()));
        sb.append("MB/");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (counts.numJobs - counts.numReblocks == 0) {
                sb.append("?MB/?MB/?MB");
            } else {
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getDataMemoryBudget(true, false)));
                sb.append("MB/");
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getDataMemoryBudget(false, false)));
                sb.append("MB/");
                sb.append(OptimizerUtils.toMB(SparkExecutionContext.getBroadcastMemoryBudget()));
                sb.append("MB");
            }
        } else {
            sb.append(OptimizerUtils.toMB(OptimizerUtils.getRemoteMemBudgetMap()));
            sb.append("MB/");
            sb.append(OptimizerUtils.toMB(OptimizerUtils.getRemoteMemBudgetReduce()));
            sb.append("MB");
        }
        return sb.toString();
    }

    public static String explainDegreeOfParallelism() {
        return Explain.explainDegreeOfParallelism(new ExplainCounts());
    }

    public static String explainDegreeOfParallelism(ExplainCounts counts) {
        int lk = InfrastructureAnalyzer.getLocalParallelism();
        StringBuilder sb = new StringBuilder();
        sb.append("# Degree of Parallelism (vcores) local/remote = ");
        sb.append(lk);
        sb.append("/");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (counts.numJobs - counts.numReblocks == 0) {
                sb.append("?");
            } else {
                sb.append(SparkExecutionContext.getDefaultParallelism(false));
            }
        } else {
            int rk = InfrastructureAnalyzer.getRemoteParallelMapTasks();
            int rk2 = InfrastructureAnalyzer.getRemoteParallelReduceTasks();
            if (InfrastructureAnalyzer.isYarnEnabled()) {
                rk = (int)Math.max((long)rk, YarnClusterAnalyzer.getNumCores());
                rk2 = (int)Math.max((long)rk2, YarnClusterAnalyzer.getNumCores() / 2L);
            }
            sb.append(rk);
            sb.append("/");
            sb.append(rk2);
        }
        return sb.toString();
    }

    public static String explain(DMLProgram prog, Program rtprog, ExplainType type) throws HopsException, DMLRuntimeException, LanguageException {
        return Explain.explain(prog, rtprog, type, null);
    }

    public static String explain(DMLProgram prog, Program rtprog, ExplainType type, ExplainCounts counts) throws HopsException, DMLRuntimeException, LanguageException {
        switch (type) {
            case HOPS: 
            case RECOMPILE_HOPS: {
                return Explain.explain(prog);
            }
            case RUNTIME: 
            case RECOMPILE_RUNTIME: {
                return Explain.explain(rtprog, counts);
            }
        }
        return null;
    }

    public static String explain(DMLProgram prog) throws HopsException, DMLRuntimeException, LanguageException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nPROGRAM\n");
        if (prog.hasFunctionStatementBlocks()) {
            sb.append("--FUNCTIONS\n");
            sb.append("----FUNCTION CALL GRAPH\n");
            sb.append("------MAIN PROGRAM\n");
            FunctionCallGraph fgraph = new FunctionCallGraph(prog);
            sb.append(Explain.explainFunctionCallGraph(fgraph, new HashSet<String>(), null, 3));
            for (String namespace : prog.getNamespaces().keySet()) {
                for (String fname : prog.getFunctionStatementBlocks(namespace).keySet()) {
                    FunctionStatementBlock fsb = prog.getFunctionStatementBlock(namespace, fname);
                    FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                    String fkey = DMLProgram.constructFunctionKey(namespace, fname);
                    if (fstmt instanceof ExternalFunctionStatement) {
                        sb.append("----EXTERNAL FUNCTION " + fkey + "\n");
                        continue;
                    }
                    sb.append("----FUNCTION " + fkey + " [recompile=" + fsb.isRecompileOnce() + "]\n");
                    for (StatementBlock current : fstmt.getBody()) {
                        sb.append(Explain.explainStatementBlock(current, 3));
                    }
                }
            }
        }
        sb.append("--MAIN PROGRAM\n");
        for (StatementBlock sblk : prog.getStatementBlocks()) {
            sb.append(Explain.explainStatementBlock(sblk, 2));
        }
        return sb.toString();
    }

    public static String getHopDAG(DMLProgram prog, ArrayList<Integer> lines, boolean withSubgraph) throws HopsException, DMLRuntimeException, LanguageException {
        StringBuilder sb = new StringBuilder();
        StringBuilder nodes = new StringBuilder();
        sb.append("digraph {");
        if (prog.hasFunctionStatementBlocks()) {
            for (String namespace : prog.getNamespaces().keySet()) {
                for (String fname : prog.getFunctionStatementBlocks(namespace).keySet()) {
                    FunctionStatementBlock fsb = prog.getFunctionStatementBlock(namespace, fname);
                    FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                    String fkey = DMLProgram.constructFunctionKey(namespace, fname);
                    if (fstmt instanceof ExternalFunctionStatement) continue;
                    Explain.addSubGraphHeader(sb, withSubgraph);
                    for (StatementBlock current : fstmt.getBody()) {
                        sb.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
                    }
                    String label = "FUNCTION " + fkey + " recompile=" + fsb.isRecompileOnce() + "\n";
                    Explain.addSubGraphFooter(sb, withSubgraph, label);
                }
            }
        }
        for (StatementBlock sblk : prog.getStatementBlocks()) {
            sb.append((CharSequence)Explain.getHopDAG(sblk, nodes, lines, withSubgraph));
        }
        sb.append((CharSequence)nodes);
        sb.append("rankdir = \"BT\"\n");
        sb.append("}\n");
        return sb.toString();
    }

    public static String explain(Program rtprog) throws HopsException {
        return Explain.explain(rtprog, null);
    }

    public static String explain(Program rtprog, ExplainCounts counts) throws HopsException {
        boolean sparkExec = OptimizerUtils.isSparkExecutionMode();
        if (counts == null) {
            counts = new ExplainCounts();
            Explain.countCompiledInstructions(rtprog, counts, !sparkExec, true, sparkExec);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\nPROGRAM ( size CP/" + (sparkExec ? "SP" : "MR") + " = ");
        sb.append(counts.numCPInst);
        sb.append("/");
        sb.append(counts.numJobs);
        sb.append(" )\n");
        HashMap<String, FunctionProgramBlock> funcMap = rtprog.getFunctionProgramBlocks();
        if (funcMap != null && !funcMap.isEmpty()) {
            sb.append("--FUNCTIONS\n");
            if (!rtprog.getProgramBlocks().isEmpty() && rtprog.getProgramBlocks().get(0).getStatementBlock() != null) {
                sb.append("----FUNCTION CALL GRAPH\n");
                sb.append("------MAIN PROGRAM\n");
                DMLProgram prog = rtprog.getProgramBlocks().get(0).getStatementBlock().getDMLProg();
                FunctionCallGraph functionCallGraph = new FunctionCallGraph(prog);
                sb.append(Explain.explainFunctionCallGraph(functionCallGraph, new HashSet<String>(), null, 3));
            }
            for (Map.Entry entry : funcMap.entrySet()) {
                String fkey = (String)entry.getKey();
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                if (fpb instanceof ExternalFunctionProgramBlock) {
                    sb.append("----EXTERNAL FUNCTION " + fkey + "\n");
                    continue;
                }
                sb.append("----FUNCTION " + fkey + " [recompile=" + fpb.isRecompileOnce() + "]\n");
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    sb.append(Explain.explainProgramBlock(pb, 3));
                }
            }
        }
        sb.append("--MAIN PROGRAM\n");
        for (ProgramBlock programBlock : rtprog.getProgramBlocks()) {
            sb.append(Explain.explainProgramBlock(programBlock, 2));
        }
        return sb.toString();
    }

    public static String explain(ProgramBlock pb) {
        return Explain.explainProgramBlock(pb, 0);
    }

    public static String explain(ArrayList<Instruction> inst) {
        return Explain.explainInstructions(inst, 0);
    }

    public static String explain(ArrayList<Instruction> inst, int level) {
        return Explain.explainInstructions(inst, level);
    }

    public static String explain(Instruction inst) {
        return Explain.explainGenericInstruction(inst, 0);
    }

    public static String explain(StatementBlock sb) throws HopsException, DMLRuntimeException {
        return Explain.explainStatementBlock(sb, 0);
    }

    public static String explainHops(ArrayList<Hop> hops) throws DMLRuntimeException {
        return Explain.explainHops(hops, 0);
    }

    public static String explainHops(ArrayList<Hop> hops, int level) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        Hop.resetVisitStatus(hops);
        for (Hop hop : hops) {
            sb.append(Explain.explainHop(hop, level));
        }
        Hop.resetVisitStatus(hops);
        return sb.toString();
    }

    public static String explain(Hop hop) throws DMLRuntimeException {
        return Explain.explain(hop, 0);
    }

    public static String explain(Hop hop, int level) throws DMLRuntimeException {
        hop.resetVisitStatus();
        String ret = Explain.explainHop(hop, level);
        hop.resetVisitStatus();
        return ret;
    }

    public static String explainCPlan(CNodeTpl cplan) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n----------------------------------------\n");
        sb.append("CPLAN: " + cplan.getTemplateInfo() + "\n");
        sb.append("--inputs: " + Arrays.toString(cplan.getInputNames()) + "\n");
        sb.append("----------------------------------------\n");
        cplan.resetVisitStatusOutputs();
        if (cplan instanceof CNodeMultiAgg) {
            for (CNode output : ((CNodeMultiAgg)cplan).getOutputs()) {
                sb.append(Explain.explainCNode(output, 1));
            }
        } else {
            sb.append(Explain.explainCNode(cplan.getOutput(), 1));
        }
        cplan.resetVisitStatusOutputs();
        sb.append("----------------------------------------\n");
        return sb.toString();
    }

    public static String explain(CNode node) throws DMLRuntimeException {
        return Explain.explain(node, 0);
    }

    public static String explain(CNode node, int level) throws DMLRuntimeException {
        return Explain.explainCNode(node, level);
    }

    public static String explainGDFNodes(ArrayList<GDFNode> gdfnodes) throws DMLRuntimeException {
        return Explain.explainGDFNodes(gdfnodes, 0);
    }

    public static String explainGDFNodes(ArrayList<GDFNode> gdfnodes, int level) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        HashSet<Long> memo = new HashSet<Long>();
        for (GDFNode gnode : gdfnodes) {
            sb.append(Explain.explainGDFNode(gnode, level, memo));
        }
        return sb.toString();
    }

    public static ExplainCounts countDistributedOperations(Program rtprog) {
        ExplainCounts counts = new ExplainCounts();
        if (OptimizerUtils.isSparkExecutionMode()) {
            Explain.countCompiledInstructions(rtprog, counts, false, true, true);
        } else {
            Explain.countCompiledInstructions(rtprog, counts, true, true, false);
        }
        return counts;
    }

    public static String getIdentation(int level) {
        return Explain.createOffset(level);
    }

    public static void reset() {
        clusterID = 0;
    }

    private static void addSubGraphHeader(StringBuilder builder, boolean withSubgraph) {
        if (withSubgraph) {
            builder.append("subgraph cluster_" + clusterID++ + " {\n");
        }
    }

    private static void addSubGraphFooter(StringBuilder builder, boolean withSubgraph, String label) {
        if (withSubgraph) {
            builder.append("label = \"" + label + "\";\n");
            builder.append("}\n");
        }
    }

    private static StringBuilder getHopDAG(StatementBlock sb, StringBuilder nodes, ArrayList<Integer> lines, boolean withSubgraph) throws HopsException, DMLRuntimeException {
        StringBuilder builder = new StringBuilder();
        if (sb instanceof WhileStatementBlock) {
            Explain.addSubGraphHeader(builder, withSubgraph);
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            String label = null;
            label = !wsb.getUpdateInPlaceVars().isEmpty() ? "WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ") in-place=" + wsb.getUpdateInPlaceVars().toString() + "" : "WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ")";
            WhileStatement ws = (WhileStatement)sb.getStatement(0);
            for (StatementBlock current : ws.getBody()) {
                builder.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
            }
            Explain.addSubGraphFooter(builder, withSubgraph, label);
        } else if (sb instanceof IfStatementBlock) {
            Explain.addSubGraphHeader(builder, withSubgraph);
            IfStatementBlock ifsb = (IfStatementBlock)sb;
            String label = "IF (lines " + ifsb.getBeginLine() + "-" + ifsb.getEndLine() + ")";
            IfStatement ifs = (IfStatement)sb.getStatement(0);
            for (StatementBlock current : ifs.getIfBody()) {
                builder.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
                Explain.addSubGraphFooter(builder, withSubgraph, label);
            }
            if (!ifs.getElseBody().isEmpty()) {
                Explain.addSubGraphHeader(builder, withSubgraph);
                label = "ELSE (lines " + ifsb.getBeginLine() + "-" + ifsb.getEndLine() + ")";
                for (StatementBlock current : ifs.getElseBody()) {
                    builder.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
                }
                Explain.addSubGraphFooter(builder, withSubgraph, label);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            Explain.addSubGraphHeader(builder, withSubgraph);
            String label = "";
            label = sb instanceof ParForStatementBlock ? (!fsb.getUpdateInPlaceVars().isEmpty() ? "PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") in-place=" + fsb.getUpdateInPlaceVars().toString() + "" : "PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")") : (!fsb.getUpdateInPlaceVars().isEmpty() ? "FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") in-place=" + fsb.getUpdateInPlaceVars().toString() + "" : "FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")");
            ForStatement fs = (ForStatement)sb.getStatement(0);
            for (StatementBlock current : fs.getBody()) {
                builder.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
            }
            Explain.addSubGraphFooter(builder, withSubgraph, label);
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatement fsb = (FunctionStatement)sb.getStatement(0);
            Explain.addSubGraphHeader(builder, withSubgraph);
            String label = "Function (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")";
            for (StatementBlock current : fsb.getBody()) {
                builder.append((CharSequence)Explain.getHopDAG(current, nodes, lines, withSubgraph));
            }
            Explain.addSubGraphFooter(builder, withSubgraph, label);
        } else {
            ArrayList<Hop> hopsDAG;
            if (sb.requiresRecompilation()) {
                Explain.addSubGraphHeader(builder, withSubgraph);
            }
            if ((hopsDAG = sb.getHops()) != null && !hopsDAG.isEmpty()) {
                Hop.resetVisitStatus(hopsDAG);
                for (Hop hop : hopsDAG) {
                    builder.append((CharSequence)Explain.getHopDAG(hop, nodes, lines, withSubgraph));
                }
                Hop.resetVisitStatus(hopsDAG);
            }
            if (sb.requiresRecompilation()) {
                builder.append("style=filled;\n");
                builder.append("color=lightgrey;\n");
                String label = "(lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ") [recompile=" + sb.requiresRecompilation() + "]";
                Explain.addSubGraphFooter(builder, withSubgraph, label);
            }
        }
        return builder;
    }

    private static String explainStatementBlock(StatementBlock sb, int level) throws HopsException, DMLRuntimeException {
        StringBuilder builder = new StringBuilder();
        String offset = Explain.createOffset(level);
        if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            builder.append(offset);
            if (!wsb.getUpdateInPlaceVars().isEmpty()) {
                builder.append("WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ") [in-place=" + wsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                builder.append("WHILE (lines " + wsb.getBeginLine() + "-" + wsb.getEndLine() + ")\n");
            }
            builder.append(Explain.explainHop(wsb.getPredicateHops(), level + 1));
            WhileStatement ws = (WhileStatement)sb.getStatement(0);
            for (StatementBlock current : ws.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock ifsb = (IfStatementBlock)sb;
            builder.append(offset);
            builder.append("IF (lines " + ifsb.getBeginLine() + "-" + ifsb.getEndLine() + ")\n");
            builder.append(Explain.explainHop(ifsb.getPredicateHops(), level + 1));
            IfStatement ifs = (IfStatement)sb.getStatement(0);
            for (StatementBlock current : ifs.getIfBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
            if (!ifs.getElseBody().isEmpty()) {
                builder.append(offset);
                builder.append("ELSE\n");
            }
            for (StatementBlock current : ifs.getElseBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            builder.append(offset);
            if (sb instanceof ParForStatementBlock) {
                if (!fsb.getUpdateInPlaceVars().isEmpty()) {
                    builder.append("PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
                } else {
                    builder.append("PARFOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")\n");
                }
            } else if (!fsb.getUpdateInPlaceVars().isEmpty()) {
                builder.append("FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                builder.append("FOR (lines " + fsb.getBeginLine() + "-" + fsb.getEndLine() + ")\n");
            }
            if (fsb.getFromHops() != null) {
                builder.append(Explain.explainHop(fsb.getFromHops(), level + 1));
            }
            if (fsb.getToHops() != null) {
                builder.append(Explain.explainHop(fsb.getToHops(), level + 1));
            }
            if (fsb.getIncrementHops() != null) {
                builder.append(Explain.explainHop(fsb.getIncrementHops(), level + 1));
            }
            ForStatement fs = (ForStatement)sb.getStatement(0);
            for (StatementBlock current : fs.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatement fsb = (FunctionStatement)sb.getStatement(0);
            for (StatementBlock current : fsb.getBody()) {
                builder.append(Explain.explainStatementBlock(current, level + 1));
            }
        } else {
            builder.append(offset);
            builder.append("GENERIC (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ") [recompile=" + sb.requiresRecompilation() + "]\n");
            ArrayList<Hop> hopsDAG = sb.getHops();
            if (hopsDAG != null && !hopsDAG.isEmpty()) {
                Hop.resetVisitStatus(hopsDAG);
                for (Hop hop : hopsDAG) {
                    builder.append(Explain.explainHop(hop, level + 1));
                }
                Hop.resetVisitStatus(hopsDAG);
            }
        }
        return builder.toString();
    }

    private static String explainHop(Hop hop, int level) throws DMLRuntimeException {
        if (hop.isVisited() || hop instanceof LiteralOp) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        for (Hop input : hop.getInput()) {
            sb.append(Explain.explainHop(input, level));
        }
        sb.append(offset);
        sb.append("(" + hop.getHopID() + ") ");
        sb.append(hop.getOpString());
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (Hop input : hop.getInput()) {
            if (input instanceof LiteralOp) continue;
            childs.append(childAdded ? "," : "");
            childs.append(input.getHopID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            sb.append(childs.toString());
        }
        sb.append(" [" + hop.getDim1() + "," + hop.getDim2() + "," + hop.getRowsInBlock() + "," + hop.getColsInBlock() + "," + hop.getNnz());
        if (hop.getUpdateType().isInPlace()) {
            sb.append("," + hop.getUpdateType().toString().toLowerCase());
        }
        sb.append("]");
        sb.append(" [" + Explain.showMem(hop.getInputMemEstimate(), false) + "," + Explain.showMem(hop.getIntermediateMemEstimate(), false) + "," + Explain.showMem(hop.getOutputMemEstimate(), false) + " -> " + Explain.showMem(hop.getMemEstimate(), true) + "]");
        if (hop.requiresReblock() && hop.requiresCheckpoint()) {
            sb.append(" [rblk,chkpt]");
        } else if (hop.requiresReblock()) {
            sb.append(" [rblk]");
        } else if (hop.requiresCheckpoint()) {
            sb.append(" [chkpt]");
        }
        if (hop.getExecType() != null) {
            sb.append(", " + (Object)((Object)hop.getExecType()));
        }
        sb.append('\n');
        hop.setVisited();
        return sb.toString();
    }

    private static boolean isInRange(Hop hop, ArrayList<Integer> lines) {
        boolean isInRange = lines.size() == 0;
        for (int lineNum : lines) {
            if (hop.getBeginLine() != lineNum || lineNum != hop.getEndLine()) continue;
            return true;
        }
        return isInRange;
    }

    private static StringBuilder getHopDAG(Hop hop, StringBuilder nodes, ArrayList<Integer> lines, boolean withSubgraph) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        if (hop.isVisited() || hop instanceof LiteralOp) {
            return sb;
        }
        for (Hop input : hop.getInput()) {
            if (input instanceof LiteralOp || !Explain.isInRange(hop, lines)) continue;
            String edgeLabel = Explain.showMem(input.getOutputMemEstimate(), true);
            sb.append("h" + input.getHopID() + " -> h" + hop.getHopID() + " [label=\"" + edgeLabel + "\"];\n");
        }
        for (Hop input : hop.getInput()) {
            sb.append((CharSequence)Explain.getHopDAG(input, nodes, lines, withSubgraph));
        }
        if (Explain.isInRange(hop, lines)) {
            nodes.append("h" + hop.getHopID() + "[label=\"" + Explain.getNodeLabel(hop) + "\", shape=\"" + Explain.getNodeShape(hop) + "\", color=\"" + Explain.getNodeColor(hop) + "\", tooltip=\"" + Explain.getNodeToolTip(hop) + "\"];\n");
        }
        hop.setVisited();
        return sb;
    }

    private static String getNodeLabel(Hop hop) {
        AggBinaryOp aggBinOp;
        StringBuilder sb = new StringBuilder();
        sb.append(hop.getOpString());
        if (hop instanceof AggBinaryOp && (aggBinOp = (AggBinaryOp)hop).getMMultMethod() != null) {
            sb.append(" " + aggBinOp.getMMultMethod().name() + " ");
        }
        if (hop.requiresReblock() && hop.requiresCheckpoint()) {
            sb.append(", rblk,chkpt");
        } else if (hop.requiresReblock()) {
            sb.append(", rblk");
        } else if (hop.requiresCheckpoint()) {
            sb.append(", chkpt");
        }
        if (hop.getFilename() == null) {
            sb.append("[" + hop.getBeginLine() + ":" + hop.getBeginColumn() + "-" + hop.getEndLine() + ":" + hop.getEndColumn() + "]");
        } else {
            sb.append("[" + hop.getFilename() + " " + hop.getBeginLine() + ":" + hop.getBeginColumn() + "-" + hop.getEndLine() + ":" + hop.getEndColumn() + "]");
        }
        if (hop.getUpdateType().isInPlace()) {
            sb.append("," + hop.getUpdateType().toString().toLowerCase());
        }
        return sb.toString();
    }

    private static String getNodeToolTip(Hop hop) {
        StringBuilder sb = new StringBuilder();
        if (hop.getExecType() != null) {
            sb.append(hop.getExecType().name());
        }
        sb.append("[" + hop.getDim1() + " X " + hop.getDim2() + "], nnz=" + hop.getNnz());
        sb.append(", mem= [in=");
        sb.append(Explain.showMem(hop.getInputMemEstimate(), false));
        sb.append(", inter=");
        sb.append(Explain.showMem(hop.getIntermediateMemEstimate(), false));
        sb.append(", out=");
        sb.append(Explain.showMem(hop.getOutputMemEstimate(), false));
        sb.append(" -> ");
        sb.append(Explain.showMem(hop.getMemEstimate(), true));
        sb.append("]");
        return sb.toString();
    }

    private static String getNodeShape(Hop hop) {
        String shape = "octagon";
        if (hop.getExecType() != null) {
            switch (hop.getExecType()) {
                case CP: {
                    shape = "ellipse";
                    break;
                }
                case SPARK: {
                    shape = "box";
                    break;
                }
                case GPU: {
                    shape = "trapezium";
                    break;
                }
                case MR: {
                    shape = "parallelogram";
                    break;
                }
                default: {
                    shape = "octagon";
                }
            }
        }
        return shape;
    }

    private static String getNodeColor(Hop hop) {
        if (hop instanceof DataOp) {
            DataOp dOp = (DataOp)hop;
            if (dOp.getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD || dOp.getDataOpType() == Hop.DataOpTypes.TRANSIENTREAD) {
                return "wheat2";
            }
            if (dOp.getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE || dOp.getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE) {
                return "wheat4";
            }
        } else {
            if (hop instanceof AggBinaryOp) {
                return "orangered2";
            }
            if (hop instanceof BinaryOp) {
                return "royalblue2";
            }
            if (hop instanceof ReorgOp) {
                return "green";
            }
            if (hop instanceof UnaryOp) {
                return "yellow";
            }
        }
        return "black";
    }

    private static String explainCNode(CNode cnode, int level) throws DMLRuntimeException {
        if (cnode.isVisited()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        for (CNode input : cnode.getInput()) {
            sb.append(Explain.explainCNode(input, level));
        }
        sb.append(offset);
        sb.append("(" + cnode.getID() + ") ");
        sb.append(cnode.toString());
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (CNode input : cnode.getInput()) {
            childs.append(childAdded ? "," : "");
            childs.append(input.getID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            sb.append(childs.toString());
        }
        sb.append('\n');
        cnode.setVisited();
        return sb.toString();
    }

    private static String explainGDFNode(GDFNode gnode, int level, HashSet<Long> memo) throws DMLRuntimeException {
        if (memo.contains(gnode.getID()) || gnode.getNodeType() == GDFNode.NodeType.HOP_NODE && gnode.getHop() instanceof LiteralOp) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        for (GDFNode input : gnode.getInputs()) {
            sb.append(Explain.explainGDFNode(input, level, memo));
        }
        sb.append(offset);
        String deps = null;
        sb.append("(" + gnode.getID() + ") ");
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (GDFNode gDFNode : gnode.getInputs()) {
            childs.append(childAdded ? "," : "");
            childs.append(gDFNode.getID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            deps = childs.toString();
        }
        if (gnode instanceof GDFLoopNode) {
            GDFLoopNode lgnode = (GDFLoopNode)gnode;
            String offset2 = Explain.createOffset(level + 1);
            sb.append(lgnode.explain(deps) + "\n");
            sb.append(offset2 + "PRED:\n");
            sb.append(Explain.explainGDFNode(lgnode.getLoopPredicate(), level + 2, memo));
            sb.append(offset2 + "BODY:\n");
            for (Map.Entry entry : lgnode.getLoopOutputs().entrySet()) {
                sb.append(Explain.explainGDFNode((GDFNode)entry.getValue(), level + 2, memo));
            }
        } else {
            sb.append(gnode.explain(deps));
            sb.append('\n');
        }
        memo.add(gnode.getID());
        return sb.toString();
    }

    private static String explainProgramBlock(ProgramBlock pb, int level) {
        StringBuilder sb = new StringBuilder();
        String offset = Explain.createOffset(level);
        if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            StatementBlock wsb = pb.getStatementBlock();
            sb.append(offset);
            if (wsb != null && !wsb.getUpdateInPlaceVars().isEmpty()) {
                sb.append("WHILE (lines " + wpb.getBeginLine() + "-" + wpb.getEndLine() + ") [in-place=" + wsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                sb.append("WHILE (lines " + wpb.getBeginLine() + "-" + wpb.getEndLine() + ")\n");
            }
            sb.append(Explain.explainInstructions(wpb.getPredicate(), level + 1));
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            sb.append(offset);
            sb.append("IF (lines " + ipb.getBeginLine() + "-" + ipb.getEndLine() + ")\n");
            sb.append(Explain.explainInstructions(ipb.getPredicate(), level + 1));
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
            if (!ipb.getChildBlocksElseBody().isEmpty()) {
                sb.append(offset);
                sb.append("ELSE\n");
                for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                    sb.append(Explain.explainProgramBlock(pbc, level + 1));
                }
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            StatementBlock fsb = pb.getStatementBlock();
            sb.append(offset);
            if (pb instanceof ParForProgramBlock) {
                sb.append("PARFOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ")\n");
            } else if (fsb != null && !fsb.getUpdateInPlaceVars().isEmpty()) {
                sb.append("FOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ") [in-place=" + fsb.getUpdateInPlaceVars().toString() + "]\n");
            } else {
                sb.append("FOR (lines " + fpb.getBeginLine() + "-" + fpb.getEndLine() + ")\n");
            }
            sb.append(Explain.explainInstructions(fpb.getFromInstructions(), level + 1));
            sb.append(Explain.explainInstructions(fpb.getToInstructions(), level + 1));
            sb.append(Explain.explainInstructions(fpb.getIncrementInstructions(), level + 1));
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                sb.append(Explain.explainProgramBlock(pbc, level + 1));
            }
        } else {
            sb.append(offset);
            if (pb.getStatementBlock() != null) {
                sb.append("GENERIC (lines " + pb.getBeginLine() + "-" + pb.getEndLine() + ") [recompile=" + pb.getStatementBlock().requiresRecompilation() + "]\n");
            } else {
                sb.append("GENERIC (lines " + pb.getBeginLine() + "-" + pb.getEndLine() + ") \n");
            }
            sb.append(Explain.explainInstructions(pb.getInstructions(), level + 1));
        }
        return sb.toString();
    }

    private static String explainInstructions(ArrayList<Instruction> instSet, int level) {
        StringBuilder sb = new StringBuilder();
        String offsetInst = Explain.createOffset(level);
        for (Instruction inst : instSet) {
            String tmp = Explain.explainGenericInstruction(inst, level);
            sb.append(offsetInst);
            sb.append(tmp);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String explainGenericInstruction(Instruction inst, int level) {
        String tmp = null;
        if (inst instanceof MRJobInstruction) {
            tmp = Explain.explainMRJobInstruction((MRJobInstruction)inst, level + 1);
        } else if (inst instanceof SPInstruction || inst instanceof CPInstruction || inst instanceof GPUInstruction) {
            tmp = inst.toString();
        }
        tmp = tmp.replaceAll("\u00b0", " ");
        tmp = tmp.replaceAll("\u00b7", ".");
        tmp = tmp.replaceAll("\u2021", ", ");
        return tmp;
    }

    private static String explainMRJobInstruction(MRJobInstruction inst, int level) {
        String instruction = "MR-Job[\n";
        String offset = Explain.createOffset(level + 1);
        instruction = instruction + offset + "  jobtype        = " + (Object)((Object)inst.getJobType()) + " \n";
        instruction = instruction + offset + "  input labels   = " + Arrays.toString(inst.getInputVars()) + " \n";
        instruction = instruction + offset + "  recReader inst = " + inst.getIv_recordReaderInstructions() + " \n";
        instruction = instruction + offset + "  rand inst      = " + inst.getIv_randInstructions() + " \n";
        instruction = instruction + offset + "  mapper inst    = " + inst.getIv_instructionsInMapper() + " \n";
        instruction = instruction + offset + "  shuffle inst   = " + inst.getIv_shuffleInstructions() + " \n";
        instruction = instruction + offset + "  agg inst       = " + inst.getIv_aggInstructions() + " \n";
        instruction = instruction + offset + "  other inst     = " + inst.getIv_otherInstructions() + " \n";
        instruction = instruction + offset + "  output labels  = " + Arrays.toString(inst.getOutputVars()) + " \n";
        instruction = instruction + offset + "  result indices = " + inst.getString(inst.getIv_resultIndices()) + " \n";
        instruction = instruction + offset + "  num reducers   = " + inst.getIv_numReducers() + " \n";
        instruction = instruction + offset + "  replication    = " + inst.getIv_replication() + " ]";
        return instruction;
    }

    private static String showMem(double mem, boolean units) {
        return OptimizerUtils.toMB(mem) + (units ? "MB" : "");
    }

    private static String createOffset(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("--");
        }
        return sb.toString();
    }

    private static void countCompiledInstructions(Program rtprog, ExplainCounts counts, boolean MR, boolean CP, boolean SP) {
        for (FunctionProgramBlock fpb : rtprog.getFunctionProgramBlocks().values()) {
            Explain.countCompiledInstructions(fpb, counts, MR, CP, SP);
        }
        for (ProgramBlock pb : rtprog.getProgramBlocks()) {
            Explain.countCompiledInstructions(pb, counts, MR, CP, SP);
        }
    }

    private static void countCompiledInstructions(ProgramBlock pb, ExplainCounts counts, boolean MR, boolean CP, boolean SP) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock tmp = (WhileProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getPredicate(), counts, MR, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, MR, CP, SP);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock tmp = (IfProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getPredicate(), counts, MR, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocksIfBody()) {
                Explain.countCompiledInstructions(pb2, counts, MR, CP, SP);
            }
            for (ProgramBlock pb2 : tmp.getChildBlocksElseBody()) {
                Explain.countCompiledInstructions(pb2, counts, MR, CP, SP);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock tmp = (ForProgramBlock)pb;
            Explain.countCompiledInstructions(tmp.getFromInstructions(), counts, MR, CP, SP);
            Explain.countCompiledInstructions(tmp.getToInstructions(), counts, MR, CP, SP);
            Explain.countCompiledInstructions(tmp.getIncrementInstructions(), counts, MR, CP, SP);
            for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, MR, CP, SP);
            }
        } else if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                Explain.countCompiledInstructions(pb2, counts, MR, CP, SP);
            }
        } else {
            Explain.countCompiledInstructions(pb.getInstructions(), counts, MR, CP, SP);
        }
    }

    private static void countCompiledInstructions(ArrayList<Instruction> instSet, ExplainCounts counts, boolean MR, boolean CP, boolean SP) {
        for (Instruction inst : instSet) {
            if (MR && inst instanceof MRJobInstruction) {
                ++counts.numJobs;
            } else if (CP && inst instanceof CPInstruction) {
                ++counts.numCPInst;
            } else if (SP && inst instanceof SPInstruction) {
                ++counts.numJobs;
            }
            if (!SP || !(inst instanceof CSVReblockSPInstruction) && !(inst instanceof ReblockSPInstruction)) continue;
            ++counts.numReblocks;
        }
    }

    private static String explainFunctionCallGraph(FunctionCallGraph fgraph, HashSet<String> fstack, String fkey, int level) throws HopsException {
        StringBuilder builder = new StringBuilder();
        String offset = Explain.createOffset(level);
        Set<String> cfkeys = fgraph.getCalledFunctions(fkey);
        if (cfkeys != null) {
            for (String cfkey : cfkeys) {
                if (fstack.contains(cfkey) && fgraph.isRecursiveFunction(cfkey)) {
                    builder.append(offset + "--" + cfkey + " (recursive)\n");
                    continue;
                }
                fstack.add(cfkey);
                builder.append(offset + "--" + cfkey + "\n");
                builder.append(Explain.explainFunctionCallGraph(fgraph, fstack, cfkey, level + 1));
                fstack.remove(cfkey);
            }
        }
        return builder.toString();
    }

    public static class ExplainCounts {
        public int numCPInst = 0;
        public int numJobs = 0;
        public int numReblocks = 0;
    }

    public static enum ExplainType {
        NONE,
        HOPS,
        RUNTIME,
        RECOMPILE_HOPS,
        RECOMPILE_RUNTIME;


        public boolean isHopsType(boolean recompile) {
            return this == RECOMPILE_HOPS || !recompile && this == HOPS;
        }

        public boolean isRuntimeType(boolean recompile) {
            return this == RECOMPILE_RUNTIME || !recompile && this == RUNTIME;
        }
    }
}

