/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DenseBlockLDRB
extends DenseBlock {
    private static final long serialVersionUID = -7285459683402612969L;
    private static final boolean PARALLEL_ALLOC = true;
    private double[][] data;
    private int rlen;
    private int clen;
    private int blen;

    public DenseBlockLDRB(int rlen, int clen) {
        this(rlen, clen, DenseBlockLDRB.blocksize(rlen, clen));
    }

    public DenseBlockLDRB(int rlen, int clen, int blen) {
        this.reset(rlen, clen, blen, 0.0);
    }

    @Override
    public void reset() {
        this.reset(this.rlen, this.clen, this.blen, 0.0);
    }

    @Override
    public void reset(int rlen, int clen) {
        this.reset(rlen, clen, this.blen, 0.0);
    }

    @Override
    public void reset(int rlen, int clen, double v) {
        this.reset(rlen, clen, this.blen, v);
    }

    private void reset(int rlen, int clen, int blen, double v) {
        long llen = (long)rlen * (long)clen;
        int numPart = (int)Math.ceil((double)rlen / (double)blen);
        if (this.blen == blen && llen < this.capacity()) {
            for (int i2 = 0; i2 < numPart; ++i2) {
                int lrlen = Math.min((i2 + 1) * blen, rlen) - i2 * blen;
                Arrays.fill(this.data[i2], 0, lrlen * clen, v);
            }
        } else {
            this.data = new double[numPart][];
            IntStream range = IntStream.range(0, numPart).parallel();
            range.forEach(i -> {
                this.data[i] = DenseBlockLDRB.allocArray(i, rlen, clen, blen, v);
            });
        }
        this.rlen = rlen;
        this.clen = clen;
        this.blen = blen;
    }

    private static double[] allocArray(int i, int rlen, int clen, int blen, double v) {
        int lrlen = Math.min((i + 1) * blen, rlen) - i * blen;
        double[] ret = new double[lrlen * clen];
        if (v != 0.0) {
            Arrays.fill(ret, v);
        }
        return ret;
    }

    @Override
    public int numRows() {
        return this.rlen;
    }

    @Override
    public int numBlocks() {
        return this.data.length;
    }

    @Override
    public int blockSize() {
        return this.blen;
    }

    @Override
    public int blockSize(int bix) {
        return Math.min(this.blen, this.rlen - bix * this.blen);
    }

    @Override
    public boolean isContiguous() {
        return this.rlen <= this.blen;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return this.isContiguous() || this.index(rl) == this.index(ru);
    }

    @Override
    public long size() {
        return (long)this.rlen * (long)this.clen;
    }

    @Override
    public int size(int bix) {
        return this.blockSize(bix) * this.clen;
    }

    @Override
    public long capacity() {
        long len = 0L;
        for (int i = 0; i < this.numBlocks(); ++i) {
            len += (long)this.data[i].length;
        }
        return len;
    }

    @Override
    public long countNonZeros() {
        long nnz = 0L;
        for (int i = 0; i < this.numBlocks(); ++i) {
            nnz += (long)UtilFunctions.computeNnz(this.valuesAt(i), 0, this.size(i));
        }
        return nnz;
    }

    @Override
    public int countNonZeros(int r) {
        return UtilFunctions.computeNnz(this.values(r), this.pos(r), this.clen);
    }

    @Override
    public long countNonZeros(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        boolean rowBlock = cl == 0 && cu == this.clen;
        int bil = this.index(rl);
        int biu = this.index(ru - 1);
        for (int bi = bil; bi <= biu; ++bi) {
            int len;
            int lpos = bi == bil ? this.pos(rl) : 0;
            int n = len = bi == biu ? this.pos(ru - 1) - lpos + this.clen : this.blockSize(bi) * this.clen;
            if (rowBlock) {
                nnz += (long)UtilFunctions.computeNnz(this.data[bi], lpos, len);
                continue;
            }
            for (int i = lpos; i < lpos + len; i += this.clen) {
                nnz += (long)UtilFunctions.computeNnz(this.data[i], i + cl, cu - cl);
            }
        }
        return nnz;
    }

    @Override
    public double[][] values() {
        return this.data;
    }

    @Override
    public double[] values(int r) {
        return this.data[r / this.blen];
    }

    @Override
    public double[] valuesAt(int bix) {
        return this.data[bix];
    }

    @Override
    public int index(int r) {
        return r / this.blen;
    }

    @Override
    public int pos(int r) {
        return r % this.blen * this.clen;
    }

    @Override
    public int pos(int r, int c) {
        return r % this.blen * this.clen + c;
    }

    @Override
    public void set(double v) {
        for (int i = 0; i < this.numBlocks(); ++i) {
            Arrays.fill(this.data[i], v);
        }
    }

    @Override
    public void set(int rl, int ru, int cl, int cu, double v) {
        boolean rowBlock = cl == 0 && cu == this.clen;
        int bil = this.index(rl);
        int biu = this.index(ru - 1);
        for (int bi = bil; bi <= biu; ++bi) {
            int len;
            int lpos = bi == bil ? this.pos(rl) : 0;
            int n = len = bi == biu ? this.pos(ru - 1) - lpos + this.clen : this.blockSize(bi) * this.clen;
            if (rowBlock) {
                Arrays.fill(this.data[bi], lpos, lpos + len, v);
                continue;
            }
            for (int i = lpos; i < lpos + len; i += this.clen) {
                Arrays.fill(this.data[bi], i + cl, i + cu, v);
            }
        }
    }

    @Override
    public void set(int r, int c, double v) {
        this.data[this.index((int)r)][this.pos((int)r, (int)c)] = v;
    }

    @Override
    public void set(int r, double[] v) {
        System.arraycopy(v, 0, this.data[this.index(r)], this.pos(r), this.clen);
    }

    @Override
    public void set(DenseBlock db) {
        for (int bi = 0; bi < this.numBlocks(); ++bi) {
            System.arraycopy(db.valuesAt(bi), 0, this.data[bi], 0, this.size(bi));
        }
    }

    @Override
    public void set(int rl, int ru, int cl, int cu, DenseBlock db) {
        for (int i = rl; i < ru; ++i) {
            System.arraycopy(db.values(i - rl), db.pos(i - rl), this.values(i), this.pos(i, cl), cu - cl);
        }
    }

    @Override
    public double get(int r, int c) {
        return this.data[this.index(r)][this.pos(r, c)];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rlen; ++i) {
            double[] data = this.values(i);
            int ix = this.pos(i);
            for (int j = 0; j < this.clen; ++j) {
                sb.append(data[ix + j]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static int blocksize(int rlen, int clen) {
        return Math.min(rlen, Integer.MAX_VALUE / clen);
    }
}

