/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.MapReduceTool;

public class WriterTextCSV
extends MatrixWriter {
    public static final int BLOCKSIZE_J = 32;
    protected CSVFileFormatProperties _props = null;

    public WriterTextCSV(CSVFileFormatProperties props) {
        this._props = props;
    }

    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int brlen, int bclen, long nnz) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        if (rlen == 0L || clen == 0L) {
            throw new IOException("Write of matrices with zero rows or columns not supported (" + rlen + "x" + clen + ").");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MapReduceTool.deleteFileIfExistOnHDFS(fname);
        this.writeCSVMatrixToHDFS(path, job, fs, src, this._props);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MatrixBlock src = new MatrixBlock((int)rlen, 1, true);
        this.writeCSVMatrixToHDFS(path, job, fs, src, this._props);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeCSVMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, CSVFileFormatProperties csvprops) throws IOException {
        WriterTextCSV.writeCSVMatrixToFile(path, job, fs, src, 0, src.getNumRows(), csvprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeCSVMatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru, CSVFileFormatProperties props) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int clen = src.getNumColumns();
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        try {
            StringBuilder sb = new StringBuilder();
            props = props == null ? new CSVFileFormatProperties() : props;
            String delim = props.getDelim();
            boolean csvsparse = props.isSparse();
            if (props.hasHeader() && rl == 0) {
                for (int bj = 0; bj < clen; bj += 32) {
                    for (int j = bj; j < Math.min(clen, bj + 32); ++j) {
                        sb.append("C" + (j + 1));
                        if (j >= clen - 1) continue;
                        sb.append(delim);
                    }
                    br.write(sb.toString());
                    sb.setLength(0);
                }
                sb.append('\n');
                br.write(sb.toString());
                sb.setLength(0);
            }
            if (sparse) {
                SparseBlock sblock = src.getSparseBlock();
                for (int i = rl; i < ru; ++i) {
                    int prev_jix = -1;
                    if (sblock != null && i < sblock.numRows() && !sblock.isEmpty(i)) {
                        int pos = sblock.pos(i);
                        int alen = sblock.size(i);
                        int[] aix = sblock.indexes(i);
                        double[] avals = sblock.values(i);
                        for (int j = pos; j < pos + alen; ++j) {
                            int jix = aix[j];
                            for (int j2 = prev_jix; j2 < jix - 1; ++j2) {
                                if (!csvsparse) {
                                    sb.append('0');
                                }
                                sb.append(delim);
                                if (j2 % 32 != 0) continue;
                                br.write(sb.toString());
                                sb.setLength(0);
                            }
                            sb.append(avals[j]);
                            if (jix < clen - 1) {
                                sb.append(delim);
                            }
                            br.write(sb.toString());
                            sb.setLength(0);
                            if (jix % 32 == 0) {
                                br.write(sb.toString());
                                sb.setLength(0);
                            }
                            prev_jix = jix;
                        }
                    }
                    for (int bj = prev_jix + 1; bj < clen; bj += 32) {
                        for (int j = bj; j < Math.min(clen, bj + 32); ++j) {
                            if (!csvsparse) {
                                sb.append('0');
                            }
                            if (j >= clen - 1) continue;
                            sb.append(delim);
                        }
                        br.write(sb.toString());
                        sb.setLength(0);
                    }
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            } else {
                for (int i = rl; i < ru; ++i) {
                    for (int bj = 0; bj < clen; bj += 32) {
                        for (int j = bj; j < Math.min(clen, bj + 32); ++j) {
                            double lvalue = src.getValueDenseUnsafe(i, j);
                            if (lvalue != 0.0) {
                                sb.append(lvalue);
                            } else if (!csvsparse) {
                                sb.append('0');
                            }
                            if (j == clen - 1) continue;
                            sb.append(delim);
                        }
                        br.write(sb.toString());
                        sb.setLength(0);
                    }
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHeaderToCSV(String srcFileName, String destFileName, long rlen, long clen) throws IOException {
        Configuration conf = new Configuration((Configuration)ConfigurationManager.getCachedJobConf());
        Path srcFilePath = new Path(srcFileName);
        Path destFilePath = new Path(destFileName);
        FileSystem fs = IOUtilFunctions.getFileSystem(srcFilePath, conf);
        if (!this._props.hasHeader()) {
            fs.delete(destFilePath, true);
            fs.createNewFile(destFilePath);
            fs.delete(destFilePath, true);
            fs.rename(srcFilePath, destFilePath);
            return;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < clen) {
            sb.append("C" + (i + 1));
            if ((long)i < clen - 1L) {
                sb.append(this._props.getDelim());
            }
            ++i;
        }
        sb.append('\n');
        if (fs.isDirectory(srcFilePath)) {
            ArrayList<Path> files = new ArrayList<Path>();
            for (FileStatus stat : fs.listStatus(srcFilePath, CSVReblockMR.hiddenFileFilter)) {
                files.add(stat.getPath());
            }
            Collections.sort(files);
            Path firstpart = (Path)files.get(0);
            Path tmp = new Path(firstpart.toString() + ".tmp");
            FSDataOutputStream out = fs.create(tmp, true);
            out.write(sb.toString().getBytes());
            sb.setLength(0);
            FSDataInputStream in = null;
            try {
                in = fs.open(firstpart);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)true);
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)in);
                IOUtilFunctions.closeSilently((Closeable)out);
            }
            fs.delete(firstpart, true);
            fs.rename(tmp, firstpart);
            fs.delete(destFilePath, true);
            fs.createNewFile(destFilePath);
            fs.delete(destFilePath, true);
            fs.rename(srcFilePath, destFilePath);
        } else if (fs.isFile(srcFilePath)) {
            FSDataOutputStream out = fs.create(destFilePath, true);
            out.write(sb.toString().getBytes());
            sb.setLength(0);
            FSDataInputStream in = null;
            try {
                in = fs.open(srcFilePath);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)true);
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)in);
                IOUtilFunctions.closeSilently((Closeable)out);
            }
        } else {
            throw new IOException(srcFilePath.toString() + ": No such file or directory");
        }
    }
}

