/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDSortUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public class QuantileSortSPInstruction
extends UnarySPInstruction {
    private QuantileSortSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        this(op, in, null, out, opcode, istr);
    }

    private QuantileSortSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.QSort, op, in1, in2, out, opcode, istr);
    }

    public static QuantileSortSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            if (parts.length == 3) {
                QuantileSortSPInstruction.parseUnaryInstruction(str, in1, out);
                return new QuantileSortSPInstruction(new SimpleOperator(null), in1, out, opcode, str);
            }
            if (parts.length == 4) {
                in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                QuantileSortSPInstruction.parseUnaryInstruction(str, in1, in2, out);
                return new QuantileSortSPInstruction(new SimpleOperator(null), in1, in2, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a SortSPInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        boolean weighted = this.input2 != null;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> inW = weighted ? sec.getBinaryBlockRDDHandleForVariable(this.input2.getName()) : null;
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
        long clen = -1L;
        if (!weighted) {
            out = RDDSortUtils.sortByVal(in, mc.getRows(), mc.getRowsPerBlock());
            clen = 1L;
        } else {
            out = RDDSortUtils.sortByVal(in, inW, mc.getRows(), mc.getRowsPerBlock());
            clen = 2L;
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (weighted) {
            sec.addLineageRDD(this.output.getName(), this.input2.getName());
        }
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), clen, mc.getRowsPerBlock(), mc.getColsPerBlock());
    }
}

