/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class UnaryMatrixCPInstruction
extends UnaryCPInstruction {
    protected UnaryMatrixCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(CPInstruction.CPType.Unary, op, in, out, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String output_name = this.output.getName();
        String opcode = this.getOpcode();
        if (LibCommonsMath.isSupportedUnaryOperation(opcode)) {
            MatrixBlock retBlock = LibCommonsMath.unaryOperations(ec.getMatrixObject(this.input1.getName()), this.getOpcode());
            ec.setMatrixOutput(output_name, retBlock, this.getExtendedOpcode());
        } else {
            UnaryOperator u_op = (UnaryOperator)this._optr;
            MatrixBlock inBlock = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
            MatrixBlock retBlock = (MatrixBlock)inBlock.unaryOperations(u_op, new MatrixBlock());
            ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
            if (this.checkGuardedRepresentationChange(inBlock, retBlock)) {
                retBlock.examSparsity();
            }
            ec.setMatrixOutput(output_name, retBlock, this.getExtendedOpcode());
        }
    }
}

