/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.DataPartition;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.RepMat;
import org.apache.sysml.lops.Transform;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.lops.WeightedCrossEntropy;
import org.apache.sysml.lops.WeightedCrossEntropyR;
import org.apache.sysml.lops.WeightedDivMM;
import org.apache.sysml.lops.WeightedDivMMR;
import org.apache.sysml.lops.WeightedSigmoid;
import org.apache.sysml.lops.WeightedSigmoidR;
import org.apache.sysml.lops.WeightedSquaredLoss;
import org.apache.sysml.lops.WeightedSquaredLossR;
import org.apache.sysml.lops.WeightedUnaryMM;
import org.apache.sysml.lops.WeightedUnaryMMR;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class QuaternaryOp
extends Hop
implements Hop.MultiThreadedHop {
    public static boolean FORCE_REPLICATION = false;
    private Hop.OpOp4 _op = null;
    private int _maxNumThreads = -1;
    private boolean _postWeights = false;
    private boolean _logout = false;
    private boolean _minusin = false;
    private int _baseType = -1;
    private boolean _mult = false;
    private boolean _minus = false;
    private boolean _umult = false;
    private Hop.OpOp1 _uop = null;
    private Hop.OpOp2 _sop = null;

    private QuaternaryOp() {
    }

    public QuaternaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp4 o, Hop inX, Hop inU, Hop inV, Hop inW, boolean post) {
        this(l, dt, vt, o, inX, inU, inV);
        this.getInput().add(3, inW);
        inW.getParent().add(this);
        this._postWeights = post;
    }

    public QuaternaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp4 o, Hop inX, Hop inU, Hop inV, boolean flag1, boolean flag2) {
        this(l, dt, vt, o, inX, inU, inV);
        this._logout = flag1;
        this._minusin = flag2;
    }

    public QuaternaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp4 o, Hop inX, Hop inU, Hop inV, Hop inW, int baseType, boolean flag1, boolean flag2) {
        this(l, dt, vt, o, inX, inU, inV);
        if (inW != null) {
            this.getInput().add(3, inW);
            inW.getParent().add(this);
        }
        this._baseType = baseType;
        this._mult = flag1;
        this._minus = flag2;
    }

    public QuaternaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp4 o, Hop inW, Hop inU, Hop inV, boolean umult, Hop.OpOp1 uop, Hop.OpOp2 sop) {
        this(l, dt, vt, o, inW, inU, inV);
        this._umult = umult;
        this._uop = uop;
        this._sop = sop;
    }

    public QuaternaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp4 o, Hop inX, Hop inU, Hop inV) {
        super(l, dt, vt);
        this._op = o;
        this.getInput().add(0, inX);
        this.getInput().add(1, inU);
        this.getInput().add(2, inV);
        inX.getParent().add(this);
        inU.getParent().add(this);
        inV.getParent().add(this);
    }

    @Override
    public void checkArity() throws HopsException {
        HopsException.check(this._input.size() == 3 || this._input.size() == 4, this, "should have arity 3 or 4 but has arity %d", this._input.size());
    }

    public Hop.OpOp4 getOp() {
        return this._op;
    }

    @Override
    public void setMaxNumThreads(int k) {
        this._maxNumThreads = k;
    }

    @Override
    public int getMaxNumThreads() {
        return this._maxNumThreads;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            LopProperties.ExecType et = this.optFindExecType();
            switch (this._op) {
                case WSLOSS: {
                    WeightedSquaredLoss.WeightsType wtype = this.checkWeightsType();
                    if (et == LopProperties.ExecType.CP) {
                        this.constructCPLopsWeightedSquaredLoss(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.MR) {
                        this.constructMRLopsWeightedSquaredLoss(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.SPARK) {
                        this.constructSparkLopsWeightedSquaredLoss(wtype);
                        break;
                    }
                    throw new HopsException("Unsupported quaternaryop-wsloss exec type: " + (Object)((Object)et));
                }
                case WSIGMOID: {
                    WeightedSigmoid.WSigmoidType wtype = this.checkWSigmoidType();
                    if (et == LopProperties.ExecType.CP) {
                        this.constructCPLopsWeightedSigmoid(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.MR) {
                        this.constructMRLopsWeightedSigmoid(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.SPARK) {
                        this.constructSparkLopsWeightedSigmoid(wtype);
                        break;
                    }
                    throw new HopsException("Unsupported quaternaryop-wsigmoid exec type: " + (Object)((Object)et));
                }
                case WDIVMM: {
                    WeightedDivMM.WDivMMType wtype = this.checkWDivMMType();
                    if (et == LopProperties.ExecType.CP) {
                        this.constructCPLopsWeightedDivMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.MR) {
                        this.constructMRLopsWeightedDivMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.SPARK) {
                        this.constructSparkLopsWeightedDivMM(wtype);
                        break;
                    }
                    throw new HopsException("Unsupported quaternaryop-wdivmm exec type: " + (Object)((Object)et));
                }
                case WCEMM: {
                    WeightedCrossEntropy.WCeMMType wtype = this.checkWCeMMType();
                    if (et == LopProperties.ExecType.CP) {
                        this.constructCPLopsWeightedCeMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.MR) {
                        this.constructMRLopsWeightedCeMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.SPARK) {
                        this.constructSparkLopsWeightedCeMM(wtype);
                        break;
                    }
                    throw new HopsException("Unsupported quaternaryop-wcemm exec type: " + (Object)((Object)et));
                }
                case WUMM: {
                    WeightedUnaryMM.WUMMType wtype;
                    WeightedUnaryMM.WUMMType wUMMType = wtype = this._umult ? WeightedUnaryMM.WUMMType.MULT : WeightedUnaryMM.WUMMType.DIV;
                    if (et == LopProperties.ExecType.CP) {
                        this.constructCPLopsWeightedUMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.MR) {
                        this.constructMRLopsWeightedUMM(wtype);
                        break;
                    }
                    if (et == LopProperties.ExecType.SPARK) {
                        this.constructSparkLopsWeightedUMM(wtype);
                        break;
                    }
                    throw new HopsException("Unsupported quaternaryop-wumm exec type: " + (Object)((Object)et));
                }
                default: {
                    throw new HopsException(this.printErrorLocation() + "Unknown QuaternaryOp (" + (Object)((Object)this._op) + ") while constructing Lops");
                }
            }
        }
        catch (LopsException e) {
            throw new HopsException(this.printErrorLocation() + "error constructing lops for QuaternaryOp.", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + "q(" + (String)HopsOpOp4String.get((Object)this._op) + ")";
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    private void constructCPLopsWeightedSquaredLoss(WeightedSquaredLoss.WeightsType wtype) throws HopsException, LopsException {
        WeightedSquaredLoss wsloss = new WeightedSquaredLoss(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getDataType(), this.getValueType(), wtype, LopProperties.ExecType.CP);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        wsloss.setNumThreads(k);
        this.setOutputDimensions(wsloss);
        this.setLineNumbers(wsloss);
        this.setLops(wsloss);
    }

    private Lop constructLeftFactorMRLop(Hop U, Hop V, boolean cacheU, double m1Size) throws HopsException, LopsException {
        Lop lU = null;
        if (cacheU) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
        } else {
            Lop offset = QuaternaryOp.createOffsetLop(V, false);
            lU = new RepMat(U.constructLops(), offset, true, V.getDataType(), V.getValueType());
            lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), U.getRowsInBlock(), U.getColsInBlock(), U.getNnz());
            this.setLineNumbers(lU);
            Group grpU = new Group(lU, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), U.getRowsInBlock(), U.getColsInBlock(), -1L);
            this.setLineNumbers(grpU);
            lU = grpU;
        }
        return lU;
    }

    private Lop constructRightFactorMRLop(Hop U, Hop V, boolean cacheV, double m2Size) throws HopsException, LopsException {
        Lop lV = null;
        if (cacheV) {
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
        } else {
            Transform ltV = new Transform(V.constructLops(), (Transform.OperationTypes)((Object)HopsTransf2Lops.get((Object)Hop.ReOrgOp.TRANSPOSE)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR);
            ltV.getOutputParameters().setDimensions(V.getDim2(), V.getDim1(), V.getColsInBlock(), V.getRowsInBlock(), V.getNnz());
            this.setLineNumbers(ltV);
            Lop offset = QuaternaryOp.createOffsetLop(U, false);
            lV = new RepMat(ltV, offset, false, V.getDataType(), V.getValueType());
            lV.getOutputParameters().setDimensions(V.getDim2(), V.getDim1(), V.getColsInBlock(), V.getRowsInBlock(), V.getNnz());
            this.setLineNumbers(lV);
            Group grpV = new Group(lV, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpV.getOutputParameters().setDimensions(V.getDim2(), V.getDim1(), V.getColsInBlock(), V.getRowsInBlock(), -1L);
            this.setLineNumbers(grpV);
            lV = grpV;
        }
        return lV;
    }

    private void constructMRLopsWeightedSquaredLoss(WeightedSquaredLoss.WeightsType wtype) throws HopsException, LopsException {
        boolean isMapWsloss;
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop W = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWsloss = !wtype.hasFourInputs() && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetMap(true);
        if (!FORCE_REPLICATION && isMapWsloss) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            Lop lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            Lop lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
            WeightedSquaredLoss wsloss = new WeightedSquaredLoss(X.constructLops(), lU, lV, W.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.MR);
            wsloss.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(wsloss);
            Group grp = new Group(wsloss, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grp.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grp);
            Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
            agg1.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < OptimizerUtils.getRemoteMemBudgetReduce();
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < OptimizerUtils.getRemoteMemBudgetReduce() || cacheU && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetReduce());
            Group grpX = new Group(X.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpX.getOutputParameters().setDimensions(X.getDim1(), X.getDim2(), X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grpX);
            Lop grpW = W.constructLops();
            if (grpW.getDataType() == Expression.DataType.MATRIX) {
                grpW = new Group(W.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
                grpW.getOutputParameters().setDimensions(W.getDim1(), W.getDim2(), W.getRowsInBlock(), W.getColsInBlock(), -1L);
                this.setLineNumbers(grpW);
            }
            Lop lU = this.constructLeftFactorMRLop(U, V, cacheU, m1Size);
            Lop lV = this.constructRightFactorMRLop(U, V, cacheV, m2Size);
            WeightedSquaredLossR wsloss = new WeightedSquaredLossR(grpX, lU, lV, grpW, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.MR);
            wsloss.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(wsloss);
            Group grp = new Group(wsloss, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grp.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grp);
            Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
            agg1.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        }
    }

    private void constructSparkLopsWeightedSquaredLoss(WeightedSquaredLoss.WeightsType wtype) throws HopsException, LopsException {
        boolean isMapWsloss;
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop W = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWsloss = !wtype.hasFourInputs() && m1Size + m2Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal && 2.0 * m2Size < memBudgetLocal;
        if (!FORCE_REPLICATION && isMapWsloss) {
            WeightedSquaredLoss wsloss = new WeightedSquaredLoss(X.constructLops(), U.constructLops(), V.constructLops(), W.constructLops(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wsloss);
            this.setLineNumbers(wsloss);
            this.setLops(wsloss);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal;
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < memBudgetExec || cacheU && m1Size + m2Size < memBudgetExec) && 2.0 * m2Size < memBudgetLocal;
            WeightedSquaredLossR wsloss = new WeightedSquaredLossR(X.constructLops(), U.constructLops(), V.constructLops(), W.constructLops(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wsloss);
            this.setLineNumbers(wsloss);
            this.setLops(wsloss);
        }
    }

    private void constructCPLopsWeightedSigmoid(WeightedSigmoid.WSigmoidType wtype) throws HopsException, LopsException {
        WeightedSigmoid wsig = new WeightedSigmoid(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), wtype, LopProperties.ExecType.CP);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        wsig.setNumThreads(k);
        this.setOutputDimensions(wsig);
        this.setLineNumbers(wsig);
        this.setLops(wsig);
    }

    private void constructMRLopsWeightedSigmoid(WeightedSigmoid.WSigmoidType wtype) throws HopsException, LopsException {
        double m2Size;
        boolean isMapWsig;
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        boolean bl = isMapWsig = m1Size + (m2Size = (double)OptimizerUtils.estimateSize(V.getDim1(), V.getDim2())) < OptimizerUtils.getRemoteMemBudgetMap(true);
        if (!FORCE_REPLICATION && isMapWsig) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            Lop lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            Lop lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
            WeightedSigmoid wsigmoid = new WeightedSigmoid(X.constructLops(), lU, lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.MR);
            this.setOutputDimensions(wsigmoid);
            this.setLineNumbers(wsigmoid);
            this.setLops(wsigmoid);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < OptimizerUtils.getRemoteMemBudgetReduce();
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < OptimizerUtils.getRemoteMemBudgetReduce() || cacheU && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetReduce());
            Group grpX = new Group(X.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpX.getOutputParameters().setDimensions(X.getDim1(), X.getDim2(), X.getRowsInBlock(), X.getColsInBlock(), X.getNnz());
            this.setLineNumbers(grpX);
            Lop lU = this.constructLeftFactorMRLop(U, V, cacheU, m1Size);
            Lop lV = this.constructRightFactorMRLop(U, V, cacheV, m2Size);
            WeightedSigmoidR wsigmoid = new WeightedSigmoidR(grpX, lU, lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.MR);
            this.setOutputDimensions(wsigmoid);
            this.setLineNumbers(wsigmoid);
            this.setLops(wsigmoid);
        }
    }

    private void constructSparkLopsWeightedSigmoid(WeightedSigmoid.WSigmoidType wtype) throws HopsException, LopsException {
        double m2Size;
        boolean isMapWsig;
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        boolean bl = isMapWsig = m1Size + (m2Size = (double)OptimizerUtils.estimateSize(V.getDim1(), V.getDim2())) < memBudgetExec && 2.0 * m1Size < memBudgetLocal && 2.0 * m2Size < memBudgetLocal;
        if (!FORCE_REPLICATION && isMapWsig) {
            WeightedSigmoid wsigmoid = new WeightedSigmoid(X.constructLops(), U.constructLops(), V.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wsigmoid);
            this.setLineNumbers(wsigmoid);
            this.setLops(wsigmoid);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal;
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < memBudgetExec || cacheU && m1Size + m2Size < memBudgetExec) && 2.0 * m2Size < memBudgetLocal;
            WeightedSigmoidR wsigmoid = new WeightedSigmoidR(X.constructLops(), U.constructLops(), V.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wsigmoid);
            this.setLineNumbers(wsigmoid);
            this.setLops(wsigmoid);
        }
    }

    private void constructCPLopsWeightedDivMM(WeightedDivMM.WDivMMType wtype) throws HopsException, LopsException {
        WeightedDivMM wdiv = new WeightedDivMM(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getDataType(), this.getValueType(), wtype, LopProperties.ExecType.CP);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        wdiv.setNumThreads(k);
        this.setOutputDimensions(wdiv);
        this.setLineNumbers(wdiv);
        this.setLops(wdiv);
    }

    private void constructMRLopsWeightedDivMM(WeightedDivMM.WDivMMType wtype) throws HopsException, LopsException {
        boolean isMapWdivmm;
        Hop W = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop X = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWdivmm = (!wtype.hasFourInputs() || wtype.hasScalar()) && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetMap(true);
        if (!FORCE_REPLICATION && isMapWdivmm) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            Lop lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            Lop lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
            WeightedDivMM wdivmm = new WeightedDivMM(W.constructLops(), lU, lV, X.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.MR);
            this.setOutputDimensions(wdivmm);
            this.setLineNumbers(wdivmm);
            this.setLops(wdivmm);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < OptimizerUtils.getRemoteMemBudgetReduce();
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < OptimizerUtils.getRemoteMemBudgetReduce() || cacheU && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetReduce());
            Group grpW = new Group(W.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpW.getOutputParameters().setDimensions(W.getDim1(), W.getDim2(), W.getRowsInBlock(), W.getColsInBlock(), W.getNnz());
            this.setLineNumbers(grpW);
            Lop grpX = X.constructLops();
            if (wtype.hasFourInputs() && X.getDataType() != Expression.DataType.SCALAR) {
                grpX = new Group(grpX, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            }
            grpX.getOutputParameters().setDimensions(X.getDim1(), X.getDim2(), X.getRowsInBlock(), X.getColsInBlock(), X.getNnz());
            this.setLineNumbers(grpX);
            Lop lU = this.constructLeftFactorMRLop(U, V, cacheU, m1Size);
            Lop lV = this.constructRightFactorMRLop(U, V, cacheV, m2Size);
            WeightedDivMMR wdivmm = new WeightedDivMMR(grpW, lU, lV, grpX, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.MR);
            this.setOutputDimensions(wdivmm);
            this.setLineNumbers(wdivmm);
            this.setLops(wdivmm);
        }
        Group grp = new Group(this.getLops(), Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
        this.setOutputDimensions(grp);
        this.setLineNumbers(grp);
        Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR);
        agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
        this.setOutputDimensions(agg1);
        this.setLineNumbers(agg1);
        this.setLops(agg1);
    }

    private void constructSparkLopsWeightedDivMM(WeightedDivMM.WDivMMType wtype) throws HopsException, LopsException {
        boolean isMapWdivmm;
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        Hop W = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop X = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWdivmm = (!wtype.hasFourInputs() || wtype.hasScalar()) && m1Size + m2Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal && 2.0 * m2Size < memBudgetLocal;
        if (!FORCE_REPLICATION && isMapWdivmm) {
            WeightedDivMM wdivmm = new WeightedDivMM(W.constructLops(), U.constructLops(), V.constructLops(), X.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wdivmm);
            this.setLineNumbers(wdivmm);
            this.setLops(wdivmm);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal;
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < memBudgetExec || cacheU && m1Size + m2Size < memBudgetExec) && 2.0 * m2Size < memBudgetLocal;
            WeightedDivMMR wdivmm = new WeightedDivMMR(W.constructLops(), U.constructLops(), V.constructLops(), X.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wdivmm);
            this.setLineNumbers(wdivmm);
            this.setLops(wdivmm);
        }
    }

    private void constructCPLopsWeightedCeMM(WeightedCrossEntropy.WCeMMType wtype) throws HopsException, LopsException {
        WeightedCrossEntropy wcemm = new WeightedCrossEntropy(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getDataType(), this.getValueType(), wtype, LopProperties.ExecType.CP);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        wcemm.setNumThreads(k);
        this.setOutputDimensions(wcemm);
        this.setLineNumbers(wcemm);
        this.setLops(wcemm);
    }

    private void constructMRLopsWeightedCeMM(WeightedCrossEntropy.WCeMMType wtype) throws HopsException, LopsException {
        double m2Size;
        boolean isMapWcemm;
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop eps = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        boolean bl = isMapWcemm = m1Size + (m2Size = (double)OptimizerUtils.estimateSize(V.getDim1(), V.getDim2())) < OptimizerUtils.getRemoteMemBudgetMap(true);
        if (!FORCE_REPLICATION && isMapWcemm) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            Lop lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            Lop lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
            WeightedCrossEntropy wcemm = new WeightedCrossEntropy(X.constructLops(), lU, lV, eps.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.MR);
            wcemm.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(wcemm);
            Group grp = new Group(wcemm, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grp.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grp);
            Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
            agg1.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < OptimizerUtils.getRemoteMemBudgetReduce();
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < OptimizerUtils.getRemoteMemBudgetReduce() || cacheU && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetReduce());
            Group grpX = new Group(X.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpX.getOutputParameters().setDimensions(X.getDim1(), X.getDim2(), X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grpX);
            Lop lU = this.constructLeftFactorMRLop(U, V, cacheU, m1Size);
            Lop lV = this.constructRightFactorMRLop(U, V, cacheV, m2Size);
            WeightedCrossEntropyR wcemm = new WeightedCrossEntropyR(grpX, lU, lV, eps.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.MR);
            wcemm.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(wcemm);
            Group grp = new Group(wcemm, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grp.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(grp);
            Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
            agg1.getOutputParameters().setDimensions(1L, 1L, X.getRowsInBlock(), X.getColsInBlock(), -1L);
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        }
    }

    private void constructSparkLopsWeightedCeMM(WeightedCrossEntropy.WCeMMType wtype) throws HopsException, LopsException {
        double m2Size;
        boolean isMapWcemm;
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        Hop eps = this.getInput().get(3);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        boolean bl = isMapWcemm = m1Size + (m2Size = (double)OptimizerUtils.estimateSize(V.getDim1(), V.getDim2())) < memBudgetExec && 2.0 * m1Size < memBudgetLocal && 2.0 * m2Size < memBudgetLocal;
        if (!FORCE_REPLICATION && isMapWcemm) {
            WeightedCrossEntropy wcemm = new WeightedCrossEntropy(X.constructLops(), U.constructLops(), V.constructLops(), eps.constructLops(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, wtype, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wcemm);
            this.setLineNumbers(wcemm);
            this.setLops(wcemm);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal;
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < memBudgetExec || cacheU && m1Size + m2Size < memBudgetExec) && 2.0 * m2Size < memBudgetLocal;
            WeightedCrossEntropyR wcemm = new WeightedCrossEntropyR(X.constructLops(), U.constructLops(), V.constructLops(), eps.constructLops(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, wtype, cacheU, cacheV, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wcemm);
            this.setLineNumbers(wcemm);
            this.setLops(wcemm);
        }
    }

    private void constructCPLopsWeightedUMM(WeightedUnaryMM.WUMMType wtype) throws HopsException, LopsException {
        Unary.OperationTypes uop = this._uop != null ? (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._uop)) : (this._sop == Hop.OpOp2.POW ? Unary.OperationTypes.POW2 : Unary.OperationTypes.MULTIPLY2);
        WeightedUnaryMM wumm = new WeightedUnaryMM(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), wtype, uop, LopProperties.ExecType.CP);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        wumm.setNumThreads(k);
        this.setOutputDimensions(wumm);
        this.setLineNumbers(wumm);
        this.setLops(wumm);
    }

    private void constructMRLopsWeightedUMM(WeightedUnaryMM.WUMMType wtype) throws HopsException, LopsException {
        boolean isMapWumm;
        Unary.OperationTypes uop = this._uop != null ? (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._uop)) : (this._sop == Hop.OpOp2.POW ? Unary.OperationTypes.POW2 : Unary.OperationTypes.MULTIPLY2);
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWumm = m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetMap(true);
        if (!FORCE_REPLICATION && isMapWumm) {
            boolean needPartU = !U.dimsKnown() || U.getDim1() * U.getDim2() > 4000000L;
            Lop lU = U.constructLops();
            if (needPartU) {
                lU = new DataPartition(lU, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m1Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lU.getOutputParameters().setDimensions(U.getDim1(), U.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), U.getNnz());
                this.setLineNumbers(lU);
            }
            boolean needPartV = !V.dimsKnown() || V.getDim1() * V.getDim2() > 4000000L;
            Lop lV = V.constructLops();
            if (needPartV) {
                lV = new DataPartition(lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, m2Size > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                lV.getOutputParameters().setDimensions(V.getDim1(), V.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), V.getNnz());
                this.setLineNumbers(lV);
            }
            WeightedUnaryMM wumm = new WeightedUnaryMM(X.constructLops(), lU, lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, uop, LopProperties.ExecType.MR);
            this.setOutputDimensions(wumm);
            this.setLineNumbers(wumm);
            this.setLops(wumm);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < OptimizerUtils.getRemoteMemBudgetReduce();
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < OptimizerUtils.getRemoteMemBudgetReduce() || cacheU && m1Size + m2Size < OptimizerUtils.getRemoteMemBudgetReduce());
            Group grpX = new Group(X.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            grpX.getOutputParameters().setDimensions(X.getDim1(), X.getDim2(), X.getRowsInBlock(), X.getColsInBlock(), X.getNnz());
            this.setLineNumbers(grpX);
            Lop lU = this.constructLeftFactorMRLop(U, V, cacheU, m1Size);
            Lop lV = this.constructRightFactorMRLop(U, V, cacheV, m2Size);
            WeightedUnaryMMR wumm = new WeightedUnaryMMR(grpX, lU, lV, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, uop, cacheU, cacheV, LopProperties.ExecType.MR);
            this.setOutputDimensions(wumm);
            this.setLineNumbers(wumm);
            this.setLops(wumm);
        }
    }

    private void constructSparkLopsWeightedUMM(WeightedUnaryMM.WUMMType wtype) throws HopsException, LopsException {
        boolean isMapWsloss;
        Unary.OperationTypes uop = this._uop != null ? (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._uop)) : (this._sop == Hop.OpOp2.POW ? Unary.OperationTypes.POW2 : Unary.OperationTypes.MULTIPLY2);
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        Hop X = this.getInput().get(0);
        Hop U = this.getInput().get(1);
        Hop V = this.getInput().get(2);
        double m1Size = OptimizerUtils.estimateSize(U.getDim1(), U.getDim2());
        double m2Size = OptimizerUtils.estimateSize(V.getDim1(), V.getDim2());
        boolean bl = isMapWsloss = m1Size + m2Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal && 2.0 * m2Size < memBudgetLocal;
        if (!FORCE_REPLICATION && isMapWsloss) {
            WeightedUnaryMM wumm = new WeightedUnaryMM(X.constructLops(), U.constructLops(), V.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, uop, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wumm);
            this.setLineNumbers(wumm);
            this.setLops(wumm);
        } else {
            boolean cacheU = !FORCE_REPLICATION && m1Size < memBudgetExec && 2.0 * m1Size < memBudgetLocal;
            boolean cacheV = !FORCE_REPLICATION && (!cacheU && m2Size < memBudgetExec || cacheU && m1Size + m2Size < memBudgetExec) && 2.0 * m2Size < memBudgetLocal;
            WeightedUnaryMMR wumm = new WeightedUnaryMMR(X.constructLops(), U.constructLops(), V.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, wtype, uop, cacheU, cacheV, LopProperties.ExecType.SPARK);
            this.setOutputDimensions(wumm);
            this.setLineNumbers(wumm);
            this.setLops(wumm);
        }
    }

    private WeightedSquaredLoss.WeightsType checkWeightsType() {
        WeightedSquaredLoss.WeightsType ret = WeightedSquaredLoss.WeightsType.NONE;
        if (!(this.getInput().get(3) instanceof LiteralOp)) {
            ret = this._postWeights ? WeightedSquaredLoss.WeightsType.POST : WeightedSquaredLoss.WeightsType.PRE;
        } else if (this._postWeights) {
            ret = WeightedSquaredLoss.WeightsType.POST_NZ;
        }
        return ret;
    }

    private WeightedSigmoid.WSigmoidType checkWSigmoidType() {
        if (this._logout && this._minusin) {
            return WeightedSigmoid.WSigmoidType.LOG_MINUS;
        }
        if (this._logout) {
            return WeightedSigmoid.WSigmoidType.LOG;
        }
        if (this._minusin) {
            return WeightedSigmoid.WSigmoidType.MINUS;
        }
        return WeightedSigmoid.WSigmoidType.BASIC;
    }

    private WeightedDivMM.WDivMMType checkWDivMMType() {
        switch (this._baseType) {
            case 0: {
                return WeightedDivMM.WDivMMType.MULT_BASIC;
            }
            case 1: {
                if (this.getInput().get(3).getDataType() == Expression.DataType.MATRIX) {
                    return WeightedDivMM.WDivMMType.MULT_MINUS_4_LEFT;
                }
                if (this._minus) {
                    return WeightedDivMM.WDivMMType.MULT_MINUS_LEFT;
                }
                return this._mult ? WeightedDivMM.WDivMMType.MULT_LEFT : WeightedDivMM.WDivMMType.DIV_LEFT;
            }
            case 2: {
                if (this.getInput().get(3).getDataType() == Expression.DataType.MATRIX) {
                    return WeightedDivMM.WDivMMType.MULT_MINUS_4_RIGHT;
                }
                if (this._minus) {
                    return WeightedDivMM.WDivMMType.MULT_MINUS_RIGHT;
                }
                return this._mult ? WeightedDivMM.WDivMMType.MULT_RIGHT : WeightedDivMM.WDivMMType.DIV_RIGHT;
            }
            case 3: {
                return WeightedDivMM.WDivMMType.DIV_LEFT_EPS;
            }
            case 4: {
                return WeightedDivMM.WDivMMType.DIV_RIGHT_EPS;
            }
        }
        return null;
    }

    private WeightedCrossEntropy.WCeMMType checkWCeMMType() {
        return this._baseType == 1 ? WeightedCrossEntropy.WCeMMType.BASIC_EPS : WeightedCrossEntropy.WCeMMType.BASIC;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        switch (this._op) {
            case WSLOSS: 
            case WCEMM: {
                return 8.0;
            }
            case WSIGMOID: 
            case WDIVMM: 
            case WUMM: {
                double sp = OptimizerUtils.getSparsity(dim1, dim2, nnz);
                return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sp);
            }
        }
        return 0.0;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        switch (this._op) {
            case WSLOSS: {
                ret = null;
                break;
            }
            case WSIGMOID: 
            case WUMM: {
                MatrixCharacteristics mcW = memo.getAllInputStats(this.getInput().get(0));
                ret = new long[]{mcW.getRows(), mcW.getCols(), mcW.getNonZeros()};
                break;
            }
            case WDIVMM: {
                if (this._baseType == 0) {
                    MatrixCharacteristics mcW = memo.getAllInputStats(this.getInput().get(0));
                    ret = new long[]{mcW.getRows(), mcW.getCols(), mcW.getNonZeros()};
                    break;
                }
                if (this._baseType == 1 || this._baseType == 3) {
                    MatrixCharacteristics mcV = memo.getAllInputStats(this.getInput().get(2));
                    ret = new long[]{mcV.getRows(), mcV.getCols(), -1L};
                    break;
                }
                MatrixCharacteristics mcU = memo.getAllInputStats(this.getInput().get(1));
                ret = new long[]{mcU.getRows(), mcU.getCols(), -1L};
                break;
            }
            default: {
                throw new RuntimeException("Memory for operation (" + (Object)((Object)this._op) + ") can not be estimated.");
            }
        }
        return ret;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.getInput().get(0).areDimsBelowThreshold() && this.getInput().get(1).areDimsBelowThreshold() && this.getInput().get(2).areDimsBelowThreshold() && this.getInput().get(3).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._op) {
            case WSLOSS: {
                break;
            }
            case WSIGMOID: 
            case WUMM: {
                Hop inW = this.getInput().get(0);
                this.setDim1(inW.getDim1());
                this.setDim2(inW.getDim2());
                this.setNnz(inW.getNnz());
                break;
            }
            case WDIVMM: {
                if (this._baseType == 0) {
                    Hop inW = this.getInput().get(0);
                    this.setDim1(inW.getDim1());
                    this.setDim2(inW.getDim2());
                    this.setNnz(inW.getNnz());
                    break;
                }
                if (this._baseType == 1 || this._baseType == 3) {
                    Hop inV = this.getInput().get(2);
                    this.setDim1(inV.getDim1());
                    this.setDim2(inV.getDim2());
                    this.setNnz(-1L);
                    break;
                }
                Hop inU = this.getInput().get(1);
                this.setDim1(inU.getDim1());
                this.setDim2(inU.getDim2());
                this.setNnz(-1L);
                break;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        QuaternaryOp ret = new QuaternaryOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._postWeights = this._postWeights;
        ret._logout = this._logout;
        ret._minusin = this._minusin;
        ret._baseType = this._baseType;
        ret._mult = this._mult;
        ret._minus = this._minus;
        ret._umult = this._umult;
        ret._uop = this._uop;
        ret._sop = this._sop;
        ret._maxNumThreads = this._maxNumThreads;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof QuaternaryOp)) {
            return false;
        }
        QuaternaryOp that2 = (QuaternaryOp)that;
        boolean bl = ret = this._op == that2._op && this.getInput().size() == that2.getInput().size() && this.getInput().get(0) == that2.getInput().get(0) && this.getInput().get(1) == that2.getInput().get(1) && this.getInput().get(2) == that2.getInput().get(2);
        if (ret && this.getInput().size() == 4) {
            ret &= this.getInput().get(3) == that2.getInput().get(3);
        }
        ret &= this._postWeights == that2._postWeights;
        ret &= this._logout == that2._logout;
        ret &= this._minusin == that2._minusin;
        ret &= this._baseType == that2._baseType;
        ret &= this._mult == that2._mult;
        ret &= this._minus == that2._minus;
        ret &= this._umult == that2._umult;
        ret &= this._uop == that2._uop;
        ret &= this._sop == that2._sop;
        return ret &= this._maxNumThreads == that2._maxNumThreads;
    }
}

