/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.Tuple2;

public class ExtractBlockForBinaryReblock
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = -762987655085029215L;
    private long rlen;
    private long clen;
    private int in_brlen;
    private int in_bclen;
    private int out_brlen;
    private int out_bclen;

    public ExtractBlockForBinaryReblock(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) throws DMLRuntimeException {
        this.rlen = mcIn.getRows();
        this.clen = mcIn.getCols();
        this.in_brlen = mcIn.getRowsPerBlock();
        this.in_bclen = mcIn.getColsPerBlock();
        this.out_brlen = mcOut.getRowsPerBlock();
        this.out_bclen = mcOut.getColsPerBlock();
        if (this.in_brlen <= 0 || this.in_bclen <= 0 || this.out_brlen <= 0 || this.out_bclen <= 0) {
            throw new DMLRuntimeException("Block sizes not unknown:" + this.in_brlen + "," + this.in_bclen + "," + this.out_brlen + "," + this.out_bclen);
        }
    }

    public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
        MatrixBlock in = (MatrixBlock)arg0._2();
        long startRowGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getRowIndex(), this.in_brlen, 0);
        long endRowGlobalCellIndex = this.getEndGlobalIndex(ixIn.getRowIndex(), true, true);
        long startColGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getColumnIndex(), this.in_bclen, 0);
        long endColGlobalCellIndex = this.getEndGlobalIndex(ixIn.getColumnIndex(), true, false);
        assert (startRowGlobalCellIndex <= endRowGlobalCellIndex && startColGlobalCellIndex <= endColGlobalCellIndex);
        long out_startRowBlockIndex = UtilFunctions.computeBlockIndex(startRowGlobalCellIndex, this.out_brlen);
        long out_endRowBlockIndex = UtilFunctions.computeBlockIndex(endRowGlobalCellIndex, this.out_brlen);
        long out_startColBlockIndex = UtilFunctions.computeBlockIndex(startColGlobalCellIndex, this.out_bclen);
        long out_endColBlockIndex = UtilFunctions.computeBlockIndex(endColGlobalCellIndex, this.out_bclen);
        assert (out_startRowBlockIndex <= out_endRowBlockIndex && out_startColBlockIndex <= out_endColBlockIndex);
        ArrayList<Tuple2> retVal = new ArrayList<Tuple2>();
        for (long i = out_startRowBlockIndex; i <= out_endRowBlockIndex; ++i) {
            for (long j = out_startColBlockIndex; j <= out_endColBlockIndex; ++j) {
                MatrixIndexes indx = new MatrixIndexes(i, j);
                long rowLower = Math.max(UtilFunctions.computeCellIndex(i, this.out_brlen, 0), startRowGlobalCellIndex);
                long rowUpper = Math.min(this.getEndGlobalIndex(i, false, true), endRowGlobalCellIndex);
                long colLower = Math.max(UtilFunctions.computeCellIndex(j, this.out_bclen, 0), startColGlobalCellIndex);
                long colUpper = Math.min(this.getEndGlobalIndex(j, false, false), endColGlobalCellIndex);
                int new_lrlen = UtilFunctions.computeBlockSize(this.rlen, i, this.out_brlen);
                int new_lclen = UtilFunctions.computeBlockSize(this.clen, j, this.out_bclen);
                MatrixBlock blk = new MatrixBlock(new_lrlen, new_lclen, true);
                int in_i1 = UtilFunctions.computeCellInBlock(rowLower, this.in_brlen);
                int out_i1 = UtilFunctions.computeCellInBlock(rowLower, this.out_brlen);
                long i1 = rowLower;
                while (i1 <= rowUpper) {
                    int in_j1 = UtilFunctions.computeCellInBlock(colLower, this.in_bclen);
                    int out_j1 = UtilFunctions.computeCellInBlock(colLower, this.out_bclen);
                    long j1 = colLower;
                    while (j1 <= colUpper) {
                        double val = in.getValue(in_i1, in_j1);
                        blk.appendValue(out_i1, out_j1, val);
                        ++j1;
                        ++in_j1;
                        ++out_j1;
                    }
                    ++i1;
                    ++in_i1;
                    ++out_i1;
                }
                retVal.add(new Tuple2((Object)indx, (Object)blk));
            }
        }
        return retVal.iterator();
    }

    private long getEndGlobalIndex(long blockIndex, boolean isIn, boolean isRow) {
        long len;
        long l = len = isRow ? this.rlen : this.clen;
        int blen = isIn ? (isRow ? this.in_brlen : this.in_bclen) : (isRow ? this.out_brlen : this.out_bclen);
        int new_len = UtilFunctions.computeBlockSize(len, blockIndex, blen);
        return UtilFunctions.computeCellIndex(blockIndex, blen, new_len - 1);
    }
}

