/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.DataConverter;

public class EvalNaryCPInstruction
extends BuiltinNaryCPInstruction {
    public EvalNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String funcName = ec.getScalarInput(this.inputs[0]).getStringValue();
        if (funcName.contains("::")) {
            throw new DMLRuntimeException("Eval calls to '" + funcName + "', i.e., a function outside the default namespace, are not supported yet. Please call the function directly.");
        }
        CPOperand[] boundInputs = Arrays.copyOfRange(this.inputs, 1, this.inputs.length);
        ArrayList<String> boundOutputNames = new ArrayList<String>();
        boundOutputNames.add(this.output.getName());
        ArrayList<String> boundInputNames = new ArrayList<String>();
        for (CPOperand input : boundInputs) {
            boundInputNames.add(input.getName());
        }
        MatrixObject outputMO = new MatrixObject(ec.getMatrixObject(this.output.getName()));
        FunctionCallCPInstruction fcpi = new FunctionCallCPInstruction(null, funcName, boundInputs, boundInputNames, boundOutputNames, "eval func");
        fcpi.processInstruction(ec);
        Data newOutput = ec.getVariable(this.output);
        if (newOutput instanceof MatrixObject) {
            return;
        }
        MatrixBlock mb = null;
        if (newOutput instanceof ScalarObject) {
            mb = new MatrixBlock(((ScalarObject)newOutput).getDoubleValue());
        } else if (newOutput instanceof FrameObject) {
            mb = DataConverter.convertToMatrixBlock((FrameBlock)((FrameObject)newOutput).acquireRead());
            ec.cleanupCacheableData((FrameObject)newOutput);
        }
        outputMO.acquireModify(mb);
        outputMO.release();
        ec.setVariable(this.output.getName(), outputMO);
    }
}

