/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeTaggedMatrixIndexes;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixCell;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.DataConverter;

public class ResultMergeRemoteReducer
implements Reducer<Writable, Writable, Writable, Writable> {
    private ResultMergeReducer _reducer = null;

    public void reduce(Writable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this._reducer.processKeyValueList(key, valueList, out, reporter);
    }

    public void configure(JobConf job) {
        InputInfo ii = MRJobConfiguration.getResultMergeInputInfo(job);
        String compareFname = MRJobConfiguration.getResultMergeInfoCompareFilename(job);
        boolean requiresCompare = !compareFname.equals("null");
        boolean isAccum = MRJobConfiguration.getResultMergeInfoAccumulator(job);
        if (ii == InputInfo.TextCellInputInfo) {
            this._reducer = new ResultMergeReducerTextCell(requiresCompare);
        } else if (ii == InputInfo.BinaryCellInputInfo) {
            this._reducer = new ResultMergeReducerBinaryCell(requiresCompare);
        } else if (ii == InputInfo.BinaryBlockInputInfo) {
            this._reducer = new ResultMergeReducerBinaryBlock(requiresCompare, isAccum, job);
        } else {
            throw new RuntimeException("Unable to configure mapper with unknown input info: " + ii.toString() + " " + isAccum);
        }
    }

    public void close() throws IOException {
    }

    private static class ResultMergeReducerBinaryBlock
    extends ResultMerge
    implements ResultMergeReducer {
        private static final long serialVersionUID = 84399890805869855L;
        private boolean _requiresCompare;
        private JobConf _job = null;

        public ResultMergeReducerBinaryBlock(boolean requiresCompare, boolean isAccum, JobConf job) {
            this._requiresCompare = requiresCompare;
            this._job = job;
            this._isAccum = isAccum;
        }

        @Override
        public MatrixObject executeParallelMerge(int par) throws DMLRuntimeException {
            throw new DMLRuntimeException("Unsupported operation.");
        }

        @Override
        public MatrixObject executeSerialMerge() throws DMLRuntimeException {
            throw new DMLRuntimeException("Unsupported operation.");
        }

        @Override
        public void processKeyValueList(Writable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            try {
                MatrixBlock bVal;
                TaggedMatrixBlock tVal;
                MatrixIndexes ixOut = ((ResultMergeTaggedMatrixIndexes)key).getIndexes();
                MatrixBlock mbOut = null;
                DenseBlock aCompare = null;
                boolean appendOnly = false;
                if (this._requiresCompare) {
                    tVal = (TaggedMatrixBlock)valueList.next();
                    bVal = (MatrixBlock)tVal.getBaseObject();
                    if (tVal.getTag() != 99) {
                        throw new IOException("Failed to read compare block at expected first position.");
                    }
                    aCompare = DataConverter.convertToDenseBlock(bVal, InfrastructureAnalyzer.isLocalMode(this._job));
                }
                while (valueList.hasNext()) {
                    tVal = (TaggedMatrixBlock)valueList.next();
                    bVal = (MatrixBlock)tVal.getBaseObject();
                    if (mbOut == null) {
                        mbOut = new MatrixBlock();
                        mbOut.copy(bVal);
                        appendOnly = mbOut.isInSparseFormat();
                        continue;
                    }
                    if (this._requiresCompare) {
                        this.mergeWithComp(mbOut, bVal, aCompare);
                        continue;
                    }
                    this.mergeWithoutComp(mbOut, bVal, appendOnly);
                }
                if (appendOnly && !this._isAccum) {
                    mbOut.sortSparseRows();
                }
                mbOut.examSparsity();
                out.collect((Object)ixOut, (Object)mbOut);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    private static class ResultMergeReducerBinaryCell
    implements ResultMergeReducer {
        private boolean _requiresCompare;
        private MatrixCell _objValue;

        public ResultMergeReducerBinaryCell(boolean requiresCompare) {
            this._requiresCompare = requiresCompare;
            this._objValue = new MatrixCell();
        }

        @Override
        public void processKeyValueList(Writable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            block4: {
                block5: {
                    if (!this._requiresCompare) break block5;
                    Double cellCompare = null;
                    LinkedList<Double> cellList = new LinkedList<Double>();
                    boolean found = false;
                    while (valueList.hasNext()) {
                        TaggedMatrixCell tVal = (TaggedMatrixCell)valueList.next();
                        MatrixCell cVal = (MatrixCell)tVal.getBaseObject();
                        if (tVal.getTag() == 99) {
                            cellCompare = cVal.getValue();
                            continue;
                        }
                        if (cellCompare == null) {
                            cellList.add(cVal.getValue());
                            continue;
                        }
                        if (cellCompare.doubleValue() == cVal.getValue()) continue;
                        out.collect((Object)key, (Object)cVal);
                        found = true;
                        break;
                    }
                    if (found) break block4;
                    for (Double c : cellList) {
                        if (c.equals(cellCompare)) continue;
                        this._objValue.setValue(c);
                        out.collect((Object)key, (Object)this._objValue);
                        break block4;
                    }
                    break block4;
                }
                if (!valueList.hasNext()) break block4;
                TaggedMatrixCell tVal = (TaggedMatrixCell)valueList.next();
                out.collect((Object)((MatrixIndexes)key), (Object)((MatrixCell)tVal.getBaseObject()));
            }
        }
    }

    private static class ResultMergeReducerTextCell
    implements ResultMergeReducer {
        private boolean _requiresCompare;
        private StringBuilder _sb = null;
        private Text _objValue = null;

        public ResultMergeReducerTextCell(boolean requiresCompare) {
            this._requiresCompare = requiresCompare;
            this._sb = new StringBuilder();
            this._objValue = new Text();
        }

        @Override
        public void processKeyValueList(Writable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            block4: {
                block5: {
                    if (!this._requiresCompare) break block5;
                    MatrixIndexes key2 = (MatrixIndexes)key;
                    Double cellCompare = null;
                    LinkedList<Double> cellList = new LinkedList<Double>();
                    boolean found = false;
                    while (valueList.hasNext()) {
                        TaggedMatrixCell tVal = (TaggedMatrixCell)valueList.next();
                        double lvalue = ((MatrixCell)tVal.getBaseObject()).getValue();
                        if (tVal.getTag() == 99) {
                            cellCompare = lvalue;
                            continue;
                        }
                        if (cellCompare == null) {
                            cellList.add(lvalue);
                            continue;
                        }
                        if (cellCompare == lvalue) continue;
                        this._sb.append(key2.getRowIndex());
                        this._sb.append(' ');
                        this._sb.append(key2.getColumnIndex());
                        this._sb.append(' ');
                        this._sb.append(lvalue);
                        this._objValue.set(this._sb.toString());
                        this._sb.setLength(0);
                        out.collect((Object)NullWritable.get(), (Object)this._objValue);
                        found = true;
                        break;
                    }
                    if (found) break block4;
                    for (Double c : cellList) {
                        if (c.equals(cellCompare)) continue;
                        this._sb.append(key2.getRowIndex());
                        this._sb.append(' ');
                        this._sb.append(key2.getColumnIndex());
                        this._sb.append(' ');
                        this._sb.append(c);
                        this._objValue.set(this._sb.toString());
                        this._sb.setLength(0);
                        out.collect((Object)NullWritable.get(), (Object)this._objValue);
                        break block4;
                    }
                    break block4;
                }
                MatrixIndexes key2 = (MatrixIndexes)key;
                if (!valueList.hasNext()) break block4;
                TaggedMatrixCell tVal = (TaggedMatrixCell)valueList.next();
                MatrixCell value = (MatrixCell)tVal.getBaseObject();
                this._sb.append(key2.getRowIndex());
                this._sb.append(' ');
                this._sb.append(key2.getColumnIndex());
                this._sb.append(' ');
                this._sb.append(value.getValue());
                this._objValue.set(this._sb.toString());
                this._sb.setLength(0);
                out.collect((Object)NullWritable.get(), (Object)this._objValue);
            }
        }
    }

    private static interface ResultMergeReducer {
        public void processKeyValueList(Writable var1, Iterator<Writable> var2, OutputCollector<Writable, Writable> var3, Reporter var4) throws IOException;
    }
}

