/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.IOException;
import java.lang.ref.SoftReference;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.MapReduceTool;

public class MatrixObject
extends CacheableData<MatrixBlock> {
    private static final long serialVersionUID = 6374712373206495637L;
    private UpdateType _updateType = UpdateType.COPY;
    private boolean _partitioned = false;
    private ParForProgramBlock.PDataPartitionFormat _partitionFormat = null;
    private int _partitionSize = -1;
    private String _partitionCacheName = null;
    private MatrixBlock _partitionInMemory = null;

    public MatrixObject(Expression.ValueType vt, String file) {
        this(vt, file, null);
    }

    public MatrixObject(Expression.ValueType vt, String file, MetaData mtd) {
        super(Expression.DataType.MATRIX, vt);
        this._metaData = mtd;
        this._hdfsFileName = file;
        this._cache = null;
        this._data = null;
    }

    public MatrixObject(MatrixObject mo) {
        super(mo);
        MetaDataFormat metaOld = (MetaDataFormat)mo.getMetaData();
        this._metaData = new MetaDataFormat(new MatrixCharacteristics(metaOld.getMatrixCharacteristics()), metaOld.getOutputInfo(), metaOld.getInputInfo());
        this._updateType = mo._updateType;
        this._partitioned = mo._partitioned;
        this._partitionFormat = mo._partitionFormat;
        this._partitionSize = mo._partitionSize;
        this._partitionCacheName = mo._partitionCacheName;
    }

    public void setUpdateType(UpdateType flag) {
        this._updateType = flag;
    }

    public UpdateType getUpdateType() {
        return this._updateType;
    }

    @Override
    public void updateMatrixCharacteristics(MatrixCharacteristics mc) {
        this._metaData.getMatrixCharacteristics().set(mc);
    }

    @Override
    public void refreshMetaData() throws CacheException {
        if (this._data == null || this._metaData == null) {
            throw new CacheException("Cannot refresh meta data because there is no data or meta data. ");
        }
        MatrixCharacteristics mc = this._metaData.getMatrixCharacteristics();
        mc.setDimension(((MatrixBlock)this._data).getNumRows(), ((MatrixBlock)this._data).getNumColumns());
        mc.setNonZeros(((MatrixBlock)this._data).getNonZeros());
    }

    public long getNumRows() {
        return this.getMatrixCharacteristics().getRows();
    }

    public long getNumColumns() {
        return this.getMatrixCharacteristics().getCols();
    }

    public long getNumRowsPerBlock() {
        return this.getMatrixCharacteristics().getRowsPerBlock();
    }

    public long getNumColumnsPerBlock() {
        return this.getMatrixCharacteristics().getColsPerBlock();
    }

    public long getNnz() {
        return this.getMatrixCharacteristics().getNonZeros();
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this.getMatrixCharacteristics());
    }

    public void setPartitioned(ParForProgramBlock.PDataPartitionFormat format, int n) {
        this._partitioned = true;
        this._partitionFormat = format;
        this._partitionSize = n;
    }

    public void unsetPartitioned() {
        this._partitioned = false;
        this._partitionFormat = null;
        this._partitionSize = -1;
    }

    public boolean isPartitioned() {
        return this._partitioned;
    }

    public ParForProgramBlock.PDataPartitionFormat getPartitionFormat() {
        return this._partitionFormat;
    }

    public int getPartitionSize() {
        return this._partitionSize;
    }

    public synchronized void setInMemoryPartition(MatrixBlock block) {
        this._partitionInMemory = block;
    }

    public synchronized MatrixBlock readMatrixPartition(IndexRange pred) throws CacheException {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire partition " + this.hashCode() + " " + pred));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this._partitioned) {
            throw new CacheException("MatrixObject not available to indexed read.");
        }
        if (this._partitionInMemory != null) {
            return this._partitionInMemory;
        }
        MatrixBlock mb = null;
        try {
            boolean blockwise = this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE || this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE;
            MetaDataFormat iimd = (MetaDataFormat)this._metaData;
            MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
            int brlen = mc.getRowsPerBlock();
            int bclen = mc.getColsPerBlock();
            String fname = this.getPartitionFileName(pred, brlen, bclen);
            if (blockwise && this._partitionCacheName != null && this._partitionCacheName.equals(fname)) {
                mb = (MatrixBlock)this._cache.get();
            }
            if (mb == null) {
                long rows = -1L;
                long cols = -1L;
                switch (this._partitionFormat) {
                    case ROW_WISE: {
                        rows = 1L;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        rows = brlen;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        rows = this._partitionSize;
                        cols = mc.getCols();
                        break;
                    }
                    case COLUMN_WISE: {
                        rows = mc.getRows();
                        cols = 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        rows = mc.getRows();
                        cols = bclen;
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        rows = mc.getRows();
                        cols = this._partitionSize;
                        break;
                    }
                    default: {
                        throw new CacheException("Unsupported partition format: " + (Object)((Object)this._partitionFormat));
                    }
                }
                if (MapReduceTool.existsFileOnHDFS(fname)) {
                    mb = this.readBlobFromHDFS(fname, rows, cols);
                } else {
                    mb = new MatrixBlock((int)rows, (int)cols, true);
                    LOG.warn((Object)("Reading empty matrix partition " + fname));
                }
            }
            if (blockwise) {
                this._partitionCacheName = fname;
                this._cache = new SoftReference<Object>(mb);
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
                    int rix = (int)((pred.rowStart - 1L) % (long)brlen);
                    mb = mb.slice(rix, rix, (int)(pred.colStart - 1L), (int)(pred.colEnd - 1L), new MatrixBlock());
                }
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) {
                    int cix = (int)((pred.colStart - 1L) % (long)bclen);
                    mb = mb.slice((int)(pred.rowStart - 1L), (int)(pred.rowEnd - 1L), cix, cix, new MatrixBlock());
                }
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
        }
        return mb;
    }

    public String getPartitionFileName(IndexRange pred, int brlen, int bclen) throws CacheException {
        if (!this._partitioned) {
            throw new CacheException("MatrixObject not available to indexed read.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._hdfsFileName);
        switch (this._partitionFormat) {
            case ROW_WISE: {
                sb.append("/");
                sb.append(pred.rowStart);
                break;
            }
            case ROW_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)brlen + 1L);
                break;
            }
            case ROW_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            case COLUMN_WISE: {
                sb.append("/");
                sb.append(pred.colStart);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)bclen + 1L);
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            default: {
                throw new CacheException("MatrixObject not available to indexed read.");
            }
        }
        return sb.toString();
    }

    @Override
    protected boolean isBelowCachingThreshold() {
        return super.isBelowCachingThreshold() || this.getUpdateType() == UpdateType.INPLACE_PINNED;
    }

    @Override
    protected MatrixBlock readBlobFromCache(String fname) throws IOException {
        return (MatrixBlock)LazyWriteBuffer.readBlock(fname, true);
    }

    @Override
    protected MatrixBlock readBlobFromHDFS(String fname, long rlen, long clen) throws IOException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading matrix from HDFS...  " + this.hashCode() + "  Path: " + fname + ", dimensions: [" + mc.getRows() + ", " + mc.getCols() + ", " + mc.getNonZeros() + "]"));
            begin = System.currentTimeMillis();
        }
        double sparsity = mc.getNonZeros() >= 0L ? (double)mc.getNonZeros() / (double)(mc.getRows() * mc.getCols()) : 1.0;
        MatrixBlock newData = DataConverter.readMatrixFromHDFS(fname, iimd.getInputInfo(), rlen, clen, mc.getRowsPerBlock(), mc.getColsPerBlock(), sparsity, this.getFileFormatProperties());
        this.setHDFSFileExists(true);
        if (newData == null) {
            throw new IOException("Unable to load matrix from file: " + fname);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading Completed: " + (System.currentTimeMillis() - begin) + " msec."));
        }
        return newData;
    }

    @Override
    protected MatrixBlock readBlobFromRDD(RDDObject rdd, MutableBoolean writeStatus) throws IOException {
        RDDObject lrdd = rdd;
        writeStatus.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        InputInfo ii = iimd.getInputInfo();
        MatrixBlock mb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            int rlen = (int)mc.getRows();
            int clen = (int)mc.getCols();
            int brlen = mc.getRowsPerBlock();
            int bclen = mc.getColsPerBlock();
            long nnz = mc.getNonZerosBound();
            if (ii == InputInfo.BinaryBlockInputInfo && !OptimizerUtils.checkSparkCollectMemoryBudget(mc, MatrixObject.getPinnedSize() + MatrixObject.getBroadcastSize(), true)) {
                if (!MapReduceTool.existsFileOnHDFS(this._hdfsFileName)) {
                    long newnnz = SparkExecutionContext.writeRDDtoHDFS(lrdd, this._hdfsFileName, iimd.getOutputInfo());
                    this._metaData.getMatrixCharacteristics().setNonZeros(newnnz);
                    rdd.setPending(false);
                    rdd.setHDFSFile(true);
                    writeStatus.setValue(true);
                }
                mb = (MatrixBlock)this.readBlobFromHDFS(this._hdfsFileName);
            } else {
                mb = ii == InputInfo.BinaryCellInputInfo ? SparkExecutionContext.toMatrixBlock(lrdd, rlen, clen, nnz) : SparkExecutionContext.toMatrixBlock(lrdd, rlen, clen, brlen, bclen, nnz);
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (mb == null) {
            throw new IOException("Unable to load matrix from rdd.");
        }
        return mb;
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Writing matrix to HDFS...  " + this.hashCode() + "  Path: " + fname + ", Format: " + (ofmt != null ? ofmt : "inferred from metadata")));
            begin = System.currentTimeMillis();
        }
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        if (this._data != null) {
            OutputInfo oinfo;
            MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
            OutputInfo outputInfo = oinfo = ofmt != null ? OutputInfo.stringToOutputInfo(ofmt) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
            if (oinfo == OutputInfo.BinaryBlockOutputInfo && DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && (mc.getRowsPerBlock() != ConfigurationManager.getBlocksize() || mc.getColsPerBlock() != ConfigurationManager.getBlocksize())) {
                DataConverter.writeMatrixToHDFS((MatrixBlock)this._data, fname, oinfo, new MatrixCharacteristics(mc.getRows(), mc.getCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), mc.getNonZeros()), rep, fprop);
            } else {
                DataConverter.writeMatrixToHDFS((MatrixBlock)this._data, fname, oinfo, mc, rep, fprop);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - COMPLETED... " + (System.currentTimeMillis() - begin) + " msec."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - NOTHING TO WRITE (_data == null)."));
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementHDFSWrites();
        }
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String outputFormat) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        OutputInfo oinfo = outputFormat != null ? OutputInfo.stringToOutputInfo(outputFormat) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        long newnnz = SparkExecutionContext.writeRDDtoHDFS(rdd, fname, oinfo);
        this._metaData.getMatrixCharacteristics().setNonZeros(newnnz);
    }

    public static enum UpdateType {
        COPY,
        INPLACE,
        INPLACE_PINNED;


        public boolean isInPlace() {
            return this != COPY;
        }
    }
}

