/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;

public class DataIdentifier
extends Identifier {
    protected String _name;
    protected String _valueTypeString;

    public DataIdentifier(DataIdentifier passed) {
        this.setProperties(passed);
        this._name = passed.getName();
        this._valueTypeString = passed.getValueType().toString();
        this.setParseInfo(passed);
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        DataIdentifier newId = new DataIdentifier(this);
        String newIdName = prefix + this._name;
        newId.setName(newIdName);
        return newId;
    }

    public DataIdentifier(String name) {
        this._name = name;
    }

    public DataIdentifier() {
        this._name = null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariable(this._name, this);
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        return null;
    }

    public boolean multipleReturns() throws LanguageException {
        throw new LanguageException("multipleReturns() must be overridden in the subclass.");
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof DataIdentifier)) {
            return false;
        }
        DataIdentifier target = (DataIdentifier)that;
        if (this.getName() != null && !this.getName().equals(target.getName())) {
            return false;
        }
        if (this.getDataType() != null && !this.getDataType().equals((Object)target.getDataType())) {
            return false;
        }
        if (this.getValueType() != null && !this.getValueType().equals((Object)target.getValueType())) {
            return false;
        }
        if (this.getFormatType() != null && !this.getFormatType().equals((Object)target.getFormatType())) {
            return false;
        }
        if (this.getDim1() != target.getDim1()) {
            return false;
        }
        return this.getDim2() == target.getDim2();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

