/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.AppendMSPInstruction;
import org.apache.sysml.runtime.instructions.spark.data.LazyIterableIterator;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class FrameAppendMSPInstruction
extends AppendMSPInstruction {
    protected FrameAppendMSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand offset, CPOperand out, boolean cbind, String opcode, String istr) {
        super(op, in1, in2, offset, out, cbind, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        this.checkBinaryAppendInputCharacteristics(sec, this._cbind, false, false);
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        PartitionedBroadcast<FrameBlock> in2 = sec.getBroadcastForFrameVariable(this.input2.getName());
        JavaPairRDD out = null;
        if (!FrameAppendMSPInstruction.preservesPartitioning(this._cbind)) {
            throw new DMLRuntimeException("Append type rbind not supported for frame mappend, instead use rappend");
        }
        out = in1.mapPartitionsToPair((PairFlatMapFunction)new MapSideAppendPartitionFunction(in2), true);
        this.updateBinaryAppendOutputMatrixCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageBroadcast(this.output.getName(), this.input2.getName());
        sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).mergeSchemas(sec.getFrameObject(this.input2.getName())));
    }

    private static boolean preservesPartitioning(boolean cbind) {
        return cbind;
    }

    private static class MapSideAppendPartitionFunction
    implements PairFlatMapFunction<Iterator<Tuple2<Long, FrameBlock>>, Long, FrameBlock> {
        private static final long serialVersionUID = -3997051891171313830L;
        private PartitionedBroadcast<FrameBlock> _pm = null;

        public MapSideAppendPartitionFunction(PartitionedBroadcast<FrameBlock> binput) {
            this._pm = binput;
        }

        public LazyIterableIterator<Tuple2<Long, FrameBlock>> call(Iterator<Tuple2<Long, FrameBlock>> arg0) throws Exception {
            return new MapAppendPartitionIterator(arg0);
        }

        private class MapAppendPartitionIterator
        extends LazyIterableIterator<Tuple2<Long, FrameBlock>> {
            public MapAppendPartitionIterator(Iterator<Tuple2<Long, FrameBlock>> in) {
                super(in);
            }

            @Override
            protected Tuple2<Long, FrameBlock> computeNext(Tuple2<Long, FrameBlock> arg) throws Exception {
                Long ix = (Long)arg._1();
                FrameBlock in1 = (FrameBlock)arg._2();
                int rowix = (ix.intValue() - 1) / 1000 + 1;
                int colix = 1;
                FrameBlock in2 = (FrameBlock)MapSideAppendPartitionFunction.this._pm.getBlock(rowix, colix);
                FrameBlock out = in1.appendOperations(in2, new FrameBlock(), true);
                return new Tuple2((Object)ix, (Object)out);
            }
        }
    }
}

