/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.IndexFunction;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class AggregateUnaryGPUInstruction
extends GPUInstruction {
    private CPOperand _input1 = null;
    private CPOperand _output = null;

    private AggregateUnaryGPUInstruction(Operator op, CPOperand in1, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.AggregateUnary;
        this._input1 = in1;
        this._output = out;
    }

    public static AggregateUnaryGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggregateUnaryOperator aggop = null;
        if (opcode.equalsIgnoreCase("nrow") || opcode.equalsIgnoreCase("ncol") || opcode.equalsIgnoreCase("length")) {
            throw new DMLRuntimeException("nrow, ncol & length should not be compiled as GPU instructions!");
        }
        aggop = InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        return new AggregateUnaryGPUInstruction(aggop, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("nrow") || opcode.equalsIgnoreCase("ncol") || opcode.equalsIgnoreCase("length")) {
            throw new DMLRuntimeException("nrow, ncol & length should not be compiled as GPU instructions!");
        }
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        int rlen = (int)in1.getNumRows();
        int clen = (int)in1.getNumColumns();
        IndexFunction indexFunction = ((AggregateUnaryOperator)this._optr).indexFn;
        if (indexFunction instanceof ReduceRow) {
            ec.setMetaData(this._output.getName(), 1L, clen);
        } else if (indexFunction instanceof ReduceCol) {
            ec.setMetaData(this._output.getName(), rlen, 1L);
        }
        LibMatrixCUDA.unaryAggregate(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this._output.getName(), (AggregateUnaryOperator)this._optr);
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        if (indexFunction instanceof ReduceRow || indexFunction instanceof ReduceCol) {
            ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
        }
    }
}

