/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.Nary;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.MatrixBuiltinNaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarBuiltinNaryCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public abstract class BuiltinNaryCPInstruction
extends CPInstruction {
    protected final CPOperand output;
    protected final CPOperand[] inputs;

    public BuiltinNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(CPInstruction.CPType.BuiltinNary, op, opcode, istr);
        this.output = output;
        this.inputs = inputs;
    }

    public static BuiltinNaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand outputOperand = new CPOperand(parts[parts.length - 1]);
        CPOperand[] inputOperands = null;
        if (parts.length > 2) {
            inputOperands = new CPOperand[parts.length - 2];
            for (int i = 1; i < parts.length - 1; ++i) {
                inputOperands[i - 1] = new CPOperand(parts[i]);
            }
        }
        if (Nary.OperationType.PRINTF.name().equalsIgnoreCase(opcode)) {
            Builtin func = Builtin.getBuiltinFnObject(opcode);
            return new ScalarBuiltinNaryCPInstruction(new SimpleOperator(func), opcode, str, outputOperand, inputOperands);
        }
        if (opcode.equals("cbind") || opcode.equals("rbind")) {
            return new MatrixBuiltinNaryCPInstruction(null, opcode, str, outputOperand, inputOperands);
        }
        throw new DMLRuntimeException("Opcode (" + opcode + ") not recognized in BuiltinMultipleCPInstruction");
    }
}

