/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class BinaryCPInstruction
extends ComputationCPInstruction {
    protected BinaryCPInstruction(CPInstruction.CPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(type, op, in1, in2, out, opcode, istr);
    }

    protected BinaryCPInstruction(CPInstruction.CPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(type, op, in1, in2, in3, out, opcode, istr);
    }

    protected static String parseBinaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        in1.split(parts[1]);
        in2.split(parts[2]);
        out.split(parts[3]);
        return opcode;
    }

    protected static String parseBinaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        in1.split(parts[1]);
        in2.split(parts[2]);
        in3.split(parts[3]);
        out.split(parts[4]);
        return opcode;
    }

    protected static void checkOutputDataType(CPOperand in1, CPOperand in2, CPOperand out) throws DMLRuntimeException {
        if ((in1.getDataType() == Expression.DataType.MATRIX || in2.getDataType() == Expression.DataType.MATRIX) && out.getDataType() != Expression.DataType.MATRIX) {
            throw new DMLRuntimeException("Element-wise matrix operations between variables " + in1.getName() + " and " + in2.getName() + " must produce a matrix, which " + out.getName() + " is not");
        }
    }
}

