/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ArithmeticBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CentralMomentCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CompressionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ConvolutionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DataPartitionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MatrixReshapeCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.PMMJCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.PlusMultCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuantilePickCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuantileSortCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.RelationalBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysml.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysml.runtime.instructions.cp.StringInitCPInstruction;
import org.apache.sysml.runtime.instructions.cp.TernaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UaggOuterChainCPInstruction;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.instructions.cpfile.MatrixIndexingCPFileInstruction;
import org.apache.sysml.runtime.instructions.cpfile.ParameterizedBuiltinCPFileInstruction;

public class CPInstructionParser
extends InstructionParser {
    public static final HashMap<String, CPInstruction.CPType> String2CPInstructionType = new HashMap();
    public static final HashMap<String, CPInstruction.CPType> String2CPFileInstructionType;

    public static CPInstruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        CPInstruction.CPType cptype = InstructionUtils.getCPType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Unable derive cptype for instruction: " + str);
        }
        CPInstruction cpinst = CPInstructionParser.parseSingleInstruction(cptype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static CPInstruction parseSingleInstruction(CPInstruction.CPType cptype, String str) throws DMLRuntimeException {
        LopProperties.ExecType execType = null;
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (cptype) {
            case AggregateUnary: {
                return AggregateUnaryCPInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryCPInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernaryCPInstruction.parseInstruction(str);
            }
            case ArithmeticBinary: {
                String opcode = InstructionUtils.getOpCode(str);
                if (opcode.equals("+*") || opcode.equals("-*")) {
                    return PlusMultCPInstruction.parseInstruction(str);
                }
                return ArithmeticBinaryCPInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryCPInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternaryCPInstruction.parseInstruction(str);
            }
            case BooleanBinary: {
                return BooleanBinaryCPInstruction.parseInstruction(str);
            }
            case BooleanUnary: {
                return BooleanUnaryCPInstruction.parseInstruction(str);
            }
            case BuiltinBinary: {
                return BuiltinBinaryCPInstruction.parseInstruction(str);
            }
            case BuiltinUnary: {
                return BuiltinUnaryCPInstruction.parseInstruction(str);
            }
            case BuiltinNary: {
                return BuiltinNaryCPInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgCPInstruction.parseInstruction(str);
            }
            case Convolution: {
                return ConvolutionCPInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainCPInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeCPInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendCPInstruction.parseInstruction(str);
            }
            case RelationalBinary: {
                return RelationalBinaryCPInstruction.parseInstruction(str);
            }
            case Variable: {
                return VariableCPInstruction.parseInstruction(str);
            }
            case Rand: {
                return DataGenCPInstruction.parseInstruction(str);
            }
            case StringInit: {
                return StringInitCPInstruction.parseInstruction(str);
            }
            case External: {
                return FunctionCallCPInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                execType = LopProperties.ExecType.valueOf(str.split("\u00b0")[0]);
                if (execType == LopProperties.ExecType.CP) {
                    return ParameterizedBuiltinCPInstruction.parseInstruction(str);
                }
                return ParameterizedBuiltinCPFileInstruction.parseInstruction(str);
            }
            case MultiReturnParameterizedBuiltin: {
                return MultiReturnParameterizedBuiltinCPInstruction.parseInstruction(str);
            }
            case MultiReturnBuiltin: {
                return MultiReturnBuiltinCPInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortCPInstruction.parseInstruction(str);
            }
            case QPick: {
                return QuantilePickCPInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                execType = LopProperties.ExecType.valueOf(str.split("\u00b0")[0]);
                if (execType == LopProperties.ExecType.CP) {
                    return IndexingCPInstruction.parseInstruction(str);
                }
                return MatrixIndexingCPFileInstruction.parseInstruction(str);
            }
            case Builtin: {
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts[0].equals("log") || parts[0].equals("log_nz")) {
                    if (parts.length == 3) {
                        return BuiltinUnaryCPInstruction.parseInstruction(str);
                    }
                    if (parts.length == 4) {
                        return BuiltinBinaryCPInstruction.parseInstruction(str);
                    }
                } else {
                    throw new DMLRuntimeException("Invalid Builtin Instruction: " + str);
                }
            }
            case MMTSJ: {
                return MMTSJCPInstruction.parseInstruction(str);
            }
            case PMMJ: {
                return PMMJCPInstruction.parseInstruction(str);
            }
            case MMChain: {
                return MMChainCPInstruction.parseInstruction(str);
            }
            case Partition: {
                return DataPartitionCPInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentCPInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceCPInstruction.parseInstruction(str);
            }
            case Compression: {
                return (CPInstruction)CompressionCPInstruction.parseInstruction(str);
            }
            case SpoofFused: {
                return SpoofCPInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid CP Instruction Type: " + (Object)((Object)cptype));
    }

    static {
        String2CPInstructionType.put("ba+*", CPInstruction.CPType.AggregateBinary);
        String2CPInstructionType.put("tak+*", CPInstruction.CPType.AggregateTernary);
        String2CPInstructionType.put("tack+*", CPInstruction.CPType.AggregateTernary);
        String2CPInstructionType.put("uak+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uark+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uack+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uasqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarsqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacsqk+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmean", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uavar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarvar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacvar", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarimax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmax", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uamin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarmin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uarimin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uacmin", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ua+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uar+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uac+", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ua*", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uatrace", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uaktrace", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("nrow", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("ncol", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("length", CPInstruction.CPType.AggregateUnary);
        String2CPInstructionType.put("uaggouterchain", CPInstruction.CPType.UaggOuterChain);
        String2CPInstructionType.put("+", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("-", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("*", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("/", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("%%", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("%/%", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("^", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("1-*", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("^2", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("*2", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("-nz", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("+*", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("-*", CPInstruction.CPType.ArithmeticBinary);
        String2CPInstructionType.put("&&", CPInstruction.CPType.BooleanBinary);
        String2CPInstructionType.put("||", CPInstruction.CPType.BooleanBinary);
        String2CPInstructionType.put("!", CPInstruction.CPType.BooleanUnary);
        String2CPInstructionType.put("==", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put("!=", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put("<", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put(">", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put("<=", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put(">=", CPInstruction.CPType.RelationalBinary);
        String2CPInstructionType.put("log", CPInstruction.CPType.Builtin);
        String2CPInstructionType.put("log_nz", CPInstruction.CPType.Builtin);
        String2CPInstructionType.put("max", CPInstruction.CPType.BuiltinBinary);
        String2CPInstructionType.put("min", CPInstruction.CPType.BuiltinBinary);
        String2CPInstructionType.put("solve", CPInstruction.CPType.BuiltinBinary);
        String2CPInstructionType.put("exp", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("abs", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sin", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("cos", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("tan", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sinh", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("cosh", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("tanh", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("asin", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("acos", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("atan", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sign", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sqrt", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("plogp", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("print", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("round", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("ceil", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("floor", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("ucumk+", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("ucum*", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("ucummin", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("ucummax", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("stop", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("inverse", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("cholesky", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sprop", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sigmoid", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("sel+", CPInstruction.CPType.BuiltinUnary);
        String2CPInstructionType.put("printf", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("cbind", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("rbind", CPInstruction.CPType.BuiltinNary);
        String2CPInstructionType.put("cdf", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("invcdf", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("groupedagg", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("rmempty", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("replace", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("rexpand", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("toString", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformapply", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformdecode", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformcolmap", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformmeta", CPInstruction.CPType.ParameterizedBuiltin);
        String2CPInstructionType.put("transformencode", CPInstruction.CPType.MultiReturnParameterizedBuiltin);
        String2CPInstructionType.put("assignvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("cpvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("mvvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("rmvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("rmfilevar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castdts", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castdtm", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castdtf", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castvtd", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castvti", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("castvtb", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("attachfiletovar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("read", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("write", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("createvar", CPInstruction.CPType.Variable);
        String2CPInstructionType.put("r'", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rev", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rdiag", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("rshape", CPInstruction.CPType.MatrixReshape);
        String2CPInstructionType.put("rsort", CPInstruction.CPType.Reorg);
        String2CPInstructionType.put("relu_backward", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("relu_maxpooling", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("relu_maxpooling_backward", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("maxpooling", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("maxpooling_backward", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("conv2d", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("conv2d_bias_add", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("conv2d_backward_filter", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("conv2d_backward_data", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("bias_add", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("bias_multiply", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("channel_sums", CPInstruction.CPType.Convolution);
        String2CPInstructionType.put("wsloss", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wsigmoid", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wdivmm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wcemm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("wumm", CPInstruction.CPType.Quaternary);
        String2CPInstructionType.put("extfunct", CPInstruction.CPType.External);
        String2CPInstructionType.put("append", CPInstruction.CPType.Append);
        String2CPInstructionType.put("rand", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("seq", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("sinit", CPInstruction.CPType.StringInit);
        String2CPInstructionType.put("sample", CPInstruction.CPType.Rand);
        String2CPInstructionType.put("ctable", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("ctableexpand", CPInstruction.CPType.Ternary);
        String2CPInstructionType.put("cm", CPInstruction.CPType.CentralMoment);
        String2CPInstructionType.put("cov", CPInstruction.CPType.Covariance);
        String2CPInstructionType.put("qsort", CPInstruction.CPType.QSort);
        String2CPInstructionType.put("qpick", CPInstruction.CPType.QPick);
        String2CPInstructionType.put("rightIndex", CPInstruction.CPType.MatrixIndexing);
        String2CPInstructionType.put("leftIndex", CPInstruction.CPType.MatrixIndexing);
        String2CPInstructionType.put("tsmm", CPInstruction.CPType.MMTSJ);
        String2CPInstructionType.put("pmm", CPInstruction.CPType.PMMJ);
        String2CPInstructionType.put("mmchain", CPInstruction.CPType.MMChain);
        String2CPInstructionType.put("qr", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("lu", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("eigen", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("svd", CPInstruction.CPType.MultiReturnBuiltin);
        String2CPInstructionType.put("partition", CPInstruction.CPType.Partition);
        String2CPInstructionType.put("compress", CPInstruction.CPType.Compression);
        String2CPInstructionType.put("spoof", CPInstruction.CPType.SpoofFused);
        String2CPFileInstructionType = new HashMap();
        String2CPFileInstructionType.put("rmempty", CPInstruction.CPType.ParameterizedBuiltin);
    }
}

