/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class MMCJ
extends Lop {
    private MMCJType _type = MMCJType.AGG;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public MMCJ(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, MMCJType type, LopProperties.ExecType et) {
        super(Lop.Type.MMCJ, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._type = type;
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = true;
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
            this.lps.setProducesIntermediateOutput(true);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public MMCJ(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, AggBinaryOp.SparkAggType aggtype, LopProperties.ExecType et) {
        this(input1, input2, dt, vt, MMCJType.NO_AGG, et);
        this._aggtype = aggtype;
    }

    @Override
    public String toString() {
        return "Operation = MMCJ";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("cpmm");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append(this._aggtype.name());
        } else {
            sb.append(this._type.name());
        }
        return sb.toString();
    }

    public static enum MMCJType {
        AGG,
        NO_AGG;

    }
}

