/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatementBlock;

public class RewriteInjectSparkLoopCheckpointing
extends StatementBlockRewriteRule {
    private boolean _checkCtx = false;

    public RewriteInjectSparkLoopCheckpointing(boolean checkParForContext) {
        this._checkCtx = checkParForContext;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus status) throws HopsException {
        if (!OptimizerUtils.isSparkExecutionMode()) {
            return Arrays.asList(sb);
        }
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        int blocksize = status.getBlocksize();
        if (!(!(sb instanceof WhileStatementBlock) && !(sb instanceof ForStatementBlock) || this._checkCtx && status.isInParforContext())) {
            ArrayList<String> candidates = new ArrayList<String>();
            VariableSet read = sb.variablesRead();
            VariableSet updated = sb.variablesUpdated();
            for (String rvar : read.getVariableNames()) {
                if (updated.containsVariable(rvar) || read.getVariable(rvar).getDataType() != Expression.DataType.MATRIX) continue;
                candidates.add(rvar);
            }
            if (!candidates.isEmpty()) {
                StatementBlock sb0 = new StatementBlock();
                sb0.setDMLProg(sb.getDMLProg());
                sb0.setParseInfo(sb);
                ArrayList<Hop> hops = new ArrayList<Hop>();
                VariableSet livein = new VariableSet();
                VariableSet liveout = new VariableSet();
                for (String var : candidates) {
                    DataIdentifier dat = read.getVariable(var);
                    long dim1 = dat instanceof IndexedIdentifier ? ((IndexedIdentifier)dat).getOrigDim1() : dat.getDim1();
                    long dim2 = dat instanceof IndexedIdentifier ? ((IndexedIdentifier)dat).getOrigDim2() : dat.getDim2();
                    DataOp tread = new DataOp(var, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.DataOpTypes.TRANSIENTREAD, dat.getFilename(), dim1, dim2, dat.getNnz(), blocksize, blocksize);
                    tread.setRequiresCheckpoint(true);
                    DataOp twrite = new DataOp(var, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, tread, Hop.DataOpTypes.TRANSIENTWRITE, null);
                    HopRewriteUtils.setOutputParameters(twrite, dim1, dim2, blocksize, blocksize, dat.getNnz());
                    hops.add(twrite);
                    livein.addVariable(var, read.getVariable(var));
                    liveout.addVariable(var, read.getVariable(var));
                }
                sb0.setHops(hops);
                sb0.setLiveIn(livein);
                sb0.setLiveOut(liveout);
                sb0.setSplitDag(true);
                ret.add(sb0);
                status.setInjectedCheckpoints();
            }
        }
        ret.add(sb);
        return ret;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus sate) throws HopsException {
        return sbs;
    }
}

