/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.yarn.DMLAppMaster;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class DMLYarnClient {
    private static final Log LOG = LogFactory.getLog(DMLYarnClient.class);
    public static final String JARFILE_ENV_CONST = "IBM_JAVA_COMMAND_LINE";
    public static final String JVMOPTS_ENV_CONST = "HADOOP_OPTS";
    public static final String MAPRED_HOME_ENV_CONST = "HADOOP_MAPRED_HOME";
    public static final String HADOOP_HOME_ENV_CONST = "HADOOP_HOME";
    public static final int NUM_CORES = 1;
    public static final double MEM_FACTOR = 1.5;
    public static final int MAX_MEM_OVERHEAD = 2048;
    public static final int APP_STATE_INTERVAL = 200;
    public static final String APPMASTER_NAME = "SystemML-AM";
    public static final String DML_SCRIPT_NAME = "script.dml";
    public static final String DML_CONFIG_NAME = "config.xml";
    public static final String DML_JAR_NAME = "SystemML.jar";
    public static final String DML_STOPMSG_NAME = "stop_msg.txt";
    private String _dmlScript = null;
    private DMLConfig _dmlConfig = null;
    private String[] _args = null;
    private String _hdfsJarFile = null;
    private String _hdfsDMLScript = null;
    private String _hdfsDMLConfig = null;

    protected DMLYarnClient(String dmlScriptStr, DMLConfig conf, String[] args) {
        this._dmlScript = dmlScriptStr;
        this._dmlConfig = conf;
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean launchDMLYarnAppmaster() throws IOException, DMLScriptException {
        boolean ret = false;
        String hdfsWD = null;
        try {
            YarnApplicationState appState;
            Timing time = new Timing(true);
            YarnConfiguration yconf = new YarnConfiguration();
            YarnClient yarnClient = YarnClient.createYarnClient();
            yarnClient.init((Configuration)yconf);
            yarnClient.start();
            YarnClientApplication app = yarnClient.createApplication();
            ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
            ApplicationId appId = appContext.getApplicationId();
            LOG.debug((Object)("Created application (applicationID: " + appId + ")"));
            hdfsWD = DMLAppMasterUtils.constructHDFSWorkingDir(this._dmlConfig, appId);
            this.copyResourcesToHdfsWorkingDir(yconf, hdfsWD);
            String command = this.constructAMCommand(this._args, this._dmlConfig);
            LOG.debug((Object)("Constructed application master command: \n" + command));
            ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            amContainer.setCommands(Collections.singletonList(command));
            amContainer.setLocalResources(this.constructLocalResourceMap(yconf));
            amContainer.setEnvironment(DMLYarnClient.constructEnvionmentMap(yconf));
            int memHeap = this._dmlConfig.getIntValue("sysml.yarn.appmaster.mem");
            int memAlloc = (int)DMLYarnClient.computeMemoryAllocation(memHeap);
            Resource capability = (Resource)Records.newRecord(Resource.class);
            capability.setMemory(memAlloc);
            capability.setVirtualCores(1);
            LOG.debug((Object)("Requested application resources: memory=" + memAlloc + ", vcores=" + 1));
            String qname = this._dmlConfig.getTextValue("sysml.yarn.app.queue");
            appContext.setApplicationName(APPMASTER_NAME);
            appContext.setAMContainerSpec(amContainer);
            appContext.setResource(capability);
            appContext.setQueue(qname);
            LOG.debug((Object)("Configured application meta data: name=SystemML-AM, queue=" + qname));
            yarnClient.submitApplication(appContext);
            ApplicationReport appReport = yarnClient.getApplicationReport(appId);
            LOG.info((Object)("Application tracking-URL: " + appReport.getTrackingUrl()));
            YarnApplicationState oldState = appState = appReport.getYarnApplicationState();
            LOG.info((Object)("Application state: " + appState));
            while (appState != YarnApplicationState.FINISHED && appState != YarnApplicationState.KILLED && appState != YarnApplicationState.FAILED) {
                Thread.sleep(200L);
                appReport = yarnClient.getApplicationReport(appId);
                appState = appReport.getYarnApplicationState();
                if (appState == oldState) continue;
                oldState = appState;
                LOG.info((Object)("Application state: " + appState));
            }
            FinalApplicationStatus finalState = appReport.getFinalApplicationStatus();
            LOG.info((Object)("Application final status: " + finalState));
            double appRuntime = (double)(appReport.getFinishTime() - appReport.getStartTime()) / 1000.0;
            LOG.info((Object)("Application runtime: " + appRuntime + " sec."));
            LOG.info((Object)("Total runtime: " + String.format("%.3f", time.stop() / 1000.0) + " sec."));
            if (finalState != FinalApplicationStatus.SUCCEEDED) {
                String stop_msg = DMLYarnClient.readMessageToHDFSWorkingDir(this._dmlConfig, yconf, appId);
                if (stop_msg == null) throw new DMLRuntimeException("DML yarn app master finished with final status: " + finalState + ".");
                throw new DMLScriptException(stop_msg);
            }
            ret = true;
            if (hdfsWD == null) return ret;
        }
        catch (DMLScriptException ex) {
            throw ex;
            catch (Exception ex2) {
                LOG.error((Object)"Failed to run DML yarn app master.", (Throwable)ex2);
                ret = false;
                return ret;
            }
        }
        MapReduceTool.deleteFileIfExistOnHDFS(hdfsWD);
        return ret;
        finally {
            if (hdfsWD != null) {
                MapReduceTool.deleteFileIfExistOnHDFS(hdfsWD);
            }
        }
    }

    private void copyResourcesToHdfsWorkingDir(YarnConfiguration yconf, String hdfsWD) throws ParseException, IOException, DMLRuntimeException, InterruptedException {
        Path confPath = new Path(hdfsWD, DML_CONFIG_NAME);
        FileSystem fs = IOUtilFunctions.getFileSystem(confPath, (Configuration)yconf);
        MapReduceTool.createDirIfNotExistOnHDFS(confPath, "777");
        try (FSDataOutputStream fout = fs.create(confPath, true);){
            fout.writeBytes(this._dmlConfig.serializeDMLConfig() + "\n");
        }
        this._hdfsDMLConfig = confPath.makeQualified(fs).toString();
        LOG.debug((Object)("DML config written to HDFS file: " + this._hdfsDMLConfig + ""));
        Path scriptPath = new Path(hdfsWD, DML_SCRIPT_NAME);
        try (FSDataOutputStream fout2 = fs.create(scriptPath, true);){
            fout2.writeBytes(this._dmlScript);
        }
        this._hdfsDMLScript = scriptPath.makeQualified(fs).toString();
        LOG.debug((Object)("DML script written to HDFS file: " + this._hdfsDMLScript + ""));
        String fname = DMLYarnClient.getLocalJarFileNameFromEnvConst();
        if (fname == null) {
            String lclassFile = DMLYarnClient.class.getProtectionDomain().getCodeSource().getLocation().getPath().toString();
            File flclassFile = new File(lclassFile);
            fname = !flclassFile.isDirectory() ? lclassFile : DMLYarnClient.createJar(lclassFile);
        }
        Path srcPath = new Path(fname);
        Path dstPath = new Path(hdfsWD, srcPath.getName());
        FileUtil.copy((FileSystem)FileSystem.getLocal((Configuration)yconf), (Path)srcPath, (FileSystem)fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)yconf);
        this._hdfsJarFile = dstPath.makeQualified(fs).toString();
        LOG.debug((Object)("Jar file copied from local file: " + srcPath.toString() + " to HDFS file: " + dstPath.toString()));
    }

    private static String getLocalJarFileNameFromEnvConst() {
        String fname = null;
        try {
            Map<String, String> env = System.getenv();
            if (env.containsKey(JARFILE_ENV_CONST)) {
                String tmp = env.get(JARFILE_ENV_CONST);
                String[] tmpargs = tmp.split(" ");
                for (int i = 0; i < tmpargs.length && fname == null; ++i) {
                    if (tmpargs[i] == null || !tmpargs[i].endsWith("RunJar")) continue;
                    fname = tmpargs[i + 1];
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to parse environment variables (" + ex.getMessage() + ")"));
            fname = null;
        }
        if (LOG.isDebugEnabled() && fname == null) {
            LOG.warn((Object)"Failed to find jar file via environment variable 'IBM_JAVA_COMMAND_LINE', fallback to jar packaging.");
        }
        return fname;
    }

    private static String createJar(String dir) throws IOException, InterruptedException {
        String jarname = dir + "/" + DML_JAR_NAME;
        File fdir = new File(dir);
        File[] tmp = fdir.listFiles();
        StringBuilder flist = new StringBuilder();
        for (File ftmp : tmp) {
            flist.append(ftmp.getName());
            flist.append(" ");
        }
        String javahome = System.getProperty("java.home");
        File fjdkhome = new File(new File(javahome).getParent() + File.separator + "bin");
        String jarPrefix = "";
        if (fjdkhome.exists()) {
            jarPrefix = fjdkhome.getAbsolutePath();
            jarPrefix = jarPrefix + File.separator;
        }
        if (jarPrefix.isEmpty()) {
            LOG.warn((Object)("Failed to find jdk home of running jre (java.home=" + javahome + ")."));
        }
        String command = jarPrefix + "jar cf " + jarname + " " + flist.subSequence(0, flist.length() - 1);
        LOG.debug((Object)("Packaging jar of unzipped files: " + command));
        Process child = Runtime.getRuntime().exec(command, null, fdir);
        int c = 0;
        while ((c = child.getInputStream().read()) != -1) {
            System.out.print((char)c);
        }
        while ((c = child.getErrorStream().read()) != -1) {
            System.err.print((char)c);
        }
        child.waitFor();
        return jarname;
    }

    private String constructAMCommand(String[] args, DMLConfig conf) {
        String externalArgs;
        StringBuilder command = new StringBuilder();
        command.append(ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java");
        if (System.getenv().containsKey(JVMOPTS_ENV_CONST) && (externalArgs = System.getenv(JVMOPTS_ENV_CONST)) != null) {
            String[] parts = externalArgs.split(" ");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].startsWith("-Xmx") || parts[i].startsWith("-Xms") || parts[i].startsWith("-Xmn")) continue;
                command.append(" ");
                command.append(parts[i]);
            }
        }
        int memHeap = conf.getIntValue("sysml.yarn.appmaster.mem");
        command.append(" -Xmx" + memHeap + "m");
        command.append(" -Xms" + memHeap + "m");
        command.append(" -Xmn" + memHeap / 10 + "m");
        command.append(' ');
        command.append(DMLAppMaster.class.getName());
        for (int i = 0; i < this._args.length; ++i) {
            String arg = this._args[i];
            command.append(' ');
            if (i > 0 && this._args[i - 1].equals("-f")) {
                command.append(this._hdfsDMLScript);
                command.append(" -config " + this._hdfsDMLConfig);
                continue;
            }
            if (this._args[i].startsWith("-config")) continue;
            command.append(arg);
        }
        command.append(" 1><LOG_DIR>/stdout");
        command.append(" 2><LOG_DIR>/stderr");
        return command.toString();
    }

    private Map<String, LocalResource> constructLocalResourceMap(YarnConfiguration yconf) throws IOException {
        HashMap<String, LocalResource> rMap = new HashMap<String, LocalResource>();
        Path path = new Path(this._hdfsJarFile);
        LocalResource resource = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus jarStat = IOUtilFunctions.getFileSystem(path, (Configuration)yconf).getFileStatus(path);
        resource.setResource(ConverterUtils.getYarnUrlFromPath((Path)path));
        resource.setSize(jarStat.getLen());
        resource.setTimestamp(jarStat.getModificationTime());
        resource.setType(LocalResourceType.FILE);
        resource.setVisibility(LocalResourceVisibility.PUBLIC);
        rMap.put(DML_JAR_NAME, resource);
        return rMap;
    }

    private static Map<String, String> constructEnvionmentMap(YarnConfiguration yconf) throws IOException {
        HashMap<String, String> eMap = new HashMap<String, String>();
        StringBuilder classpath = new StringBuilder();
        for (String value : yconf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(value.trim());
        }
        Map<String, String> env = System.getenv();
        String mapred_home = null;
        if (env.containsKey(MAPRED_HOME_ENV_CONST)) {
            mapred_home = env.get(MAPRED_HOME_ENV_CONST);
        } else if (env.containsKey(HADOOP_HOME_ENV_CONST)) {
            String tmp = env.get(HADOOP_HOME_ENV_CONST);
            mapred_home = tmp + File.separator + ".." + File.separator + "hadoop-mapreduce";
        }
        if (mapred_home != null) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(mapred_home + File.separator + "*");
            classpath.append(File.pathSeparator);
            classpath.append(mapred_home + File.separator + "lib" + File.separator + "*");
        }
        eMap.put(ApplicationConstants.Environment.CLASSPATH.name(), classpath.toString());
        MRApps.setClasspath(eMap, (Configuration)yconf);
        LOG.debug((Object)("Constructed environment classpath: " + classpath.toString()));
        return eMap;
    }

    private static String readMessageToHDFSWorkingDir(DMLConfig conf, YarnConfiguration yconf, ApplicationId appId) {
        String ret;
        block14: {
            ret = null;
            String hdfsWD = DMLAppMasterUtils.constructHDFSWorkingDir(conf, appId);
            Path msgPath = new Path(hdfsWD, DML_STOPMSG_NAME);
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(msgPath, (Configuration)yconf);
                if (!fs.exists(msgPath)) break block14;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(msgPath)));){
                    ret = br.readLine();
                }
                LOG.debug((Object)("Stop message read from HDFS file " + msgPath + ": " + ret));
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to read stop message from HDFS file: " + msgPath), (Throwable)ex);
            }
        }
        return ret;
    }

    public static long computeMemoryAllocation(long heapsize) {
        long ret = heapsize;
        ret = (double)heapsize * 1.5 - (double)heapsize < 2048.0 ? (long)((double)heapsize * 1.5) : heapsize + 2048L;
        return ret;
    }
}

