/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf;

import java.util.ArrayList;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.udf.BinaryObject;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class ExternalFunctionInvocationInstruction
extends Instruction {
    private static final IDSequence _defaultSeq = new IDSequence();
    protected final CPOperand[] inputs;
    protected final CPOperand[] outputs;
    protected final PackageFunction fun;
    protected final String baseDir;
    protected final InputInfo iinfo;

    public ExternalFunctionInvocationInstruction(CPOperand[] inputs, CPOperand[] outputs, PackageFunction fun, String baseDir, InputInfo format) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fun = fun;
        this.baseDir = baseDir;
        this.iinfo = format;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        this.fun.setFunctionInputs(this.getInputObjects(this.inputs, ec.getVariables()));
        this.fun.execute();
        this.verifyAndAttachOutputs(ec, this.fun, this.outputs);
    }

    private ArrayList<FunctionParameter> getInputObjects(CPOperand[] inputs, LocalVariableMap vars) {
        ArrayList<FunctionParameter> ret = new ArrayList<FunctionParameter>();
        block5: for (CPOperand input : inputs) {
            switch (input.getDataType()) {
                case MATRIX: {
                    MatrixObject mobj = (MatrixObject)vars.get(input.getName());
                    ret.add(new Matrix(mobj, this.getMatrixValueType(input.getValueType())));
                    continue block5;
                }
                case SCALAR: {
                    ScalarObject so = (ScalarObject)vars.get(input.getName());
                    ret.add(new Scalar(this.getScalarValueType(input.getValueType()), so.getStringValue()));
                    continue block5;
                }
                case OBJECT: {
                    ret.add(new BinaryObject(vars.get(input.getName())));
                }
            }
        }
        return ret;
    }

    private Scalar.ScalarValueType getScalarValueType(Expression.ValueType vt) {
        switch (vt) {
            case STRING: {
                return Scalar.ScalarValueType.Text;
            }
            case DOUBLE: {
                return Scalar.ScalarValueType.Double;
            }
            case INT: {
                return Scalar.ScalarValueType.Integer;
            }
            case BOOLEAN: {
                return Scalar.ScalarValueType.Boolean;
            }
        }
        throw new RuntimeException("Unknown type: " + vt.name());
    }

    private Matrix.ValueType getMatrixValueType(Expression.ValueType vt) {
        switch (vt) {
            case DOUBLE: {
                return Matrix.ValueType.Double;
            }
            case INT: {
                return Matrix.ValueType.Integer;
            }
        }
        throw new RuntimeException("Unknown type: " + vt.name());
    }

    private void verifyAndAttachOutputs(ExecutionContext ec, PackageFunction fun, CPOperand[] outputs) throws DMLRuntimeException {
        block10: for (int i = 0; i < outputs.length; ++i) {
            CPOperand output = outputs[i];
            switch (fun.getFunctionOutput(i).getType()) {
                case Matrix: {
                    Matrix m = (Matrix)fun.getFunctionOutput(i);
                    MatrixObject newVar = this.createOutputMatrixObject(m);
                    ec.setVariable(output.getName(), newVar);
                    continue block10;
                }
                case Scalar: {
                    Scalar s = (Scalar)fun.getFunctionOutput(i);
                    ScalarObject scalarObject = null;
                    switch (s.getScalarType()) {
                        case Integer: {
                            scalarObject = new IntObject(Long.parseLong(s.getValue()));
                            break;
                        }
                        case Double: {
                            scalarObject = new DoubleObject(Double.parseDouble(s.getValue()));
                            break;
                        }
                        case Boolean: {
                            scalarObject = new BooleanObject(Boolean.parseBoolean(s.getValue()));
                            break;
                        }
                        case Text: {
                            scalarObject = new StringObject(s.getValue());
                            break;
                        }
                        default: {
                            throw new DMLRuntimeException("Unknown scalar value type '" + (Object)((Object)s.getScalarType()) + "' of output '" + output.getName() + "'.");
                        }
                    }
                    ec.setVariable(output.getName(), scalarObject);
                    continue block10;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported data type: " + fun.getFunctionOutput(i).getType().name());
                }
            }
        }
    }

    private MatrixObject createOutputMatrixObject(Matrix m) throws DMLRuntimeException {
        MatrixObject ret = m.getMatrixObject();
        if (ret == null) {
            MatrixCharacteristics mc = new MatrixCharacteristics(m.getNumRows(), m.getNumCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            MetaDataFormat mfmd = new MetaDataFormat(mc, InputInfo.getMatchingOutputInfo(this.iinfo), this.iinfo);
            ret = new MatrixObject(Expression.ValueType.DOUBLE, m.getFilePath(), mfmd);
        }
        if (ret.getFileName().equals("ext_funct")) {
            ret.setFileName(this.createDefaultOutputFilePathAndName());
        }
        return ret;
    }

    private String createDefaultOutputFilePathAndName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseDir);
        sb.append("ext_funct");
        sb.append(_defaultSeq.getNextID());
        return sb.toString();
    }
}

