/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.operators;

import java.io.Serializable;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.runtime.functionobjects.And;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.Divide;
import org.apache.sysml.runtime.functionobjects.Equals;
import org.apache.sysml.runtime.functionobjects.GreaterThan;
import org.apache.sysml.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysml.runtime.functionobjects.IntegerDivide;
import org.apache.sysml.runtime.functionobjects.LessThan;
import org.apache.sysml.runtime.functionobjects.LessThanEquals;
import org.apache.sysml.runtime.functionobjects.Minus;
import org.apache.sysml.runtime.functionobjects.MinusMultiply;
import org.apache.sysml.runtime.functionobjects.MinusNz;
import org.apache.sysml.runtime.functionobjects.Modulus;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.NotEquals;
import org.apache.sysml.runtime.functionobjects.Or;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.functionobjects.Power;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class BinaryOperator
extends Operator
implements Serializable {
    private static final long serialVersionUID = -2547950181558989209L;
    public final ValueFunction fn;

    public BinaryOperator(ValueFunction p) {
        super(p instanceof Plus || p instanceof Multiply || p instanceof Minus || p instanceof And || p instanceof Or || p instanceof PlusMultiply || p instanceof MinusMultiply);
        this.fn = p;
    }

    public Hop.OpOp2 getBinaryOperatorOpOp2() {
        if (this.fn instanceof Plus) {
            return Hop.OpOp2.PLUS;
        }
        if (this.fn instanceof Minus) {
            return Hop.OpOp2.MINUS;
        }
        if (this.fn instanceof Multiply) {
            return Hop.OpOp2.MULT;
        }
        if (this.fn instanceof Divide) {
            return Hop.OpOp2.DIV;
        }
        if (this.fn instanceof Modulus) {
            return Hop.OpOp2.MODULUS;
        }
        if (this.fn instanceof IntegerDivide) {
            return Hop.OpOp2.INTDIV;
        }
        if (this.fn instanceof LessThan) {
            return Hop.OpOp2.LESS;
        }
        if (this.fn instanceof LessThanEquals) {
            return Hop.OpOp2.LESSEQUAL;
        }
        if (this.fn instanceof GreaterThan) {
            return Hop.OpOp2.GREATER;
        }
        if (this.fn instanceof GreaterThanEquals) {
            return Hop.OpOp2.GREATEREQUAL;
        }
        if (this.fn instanceof Equals) {
            return Hop.OpOp2.EQUAL;
        }
        if (this.fn instanceof NotEquals) {
            return Hop.OpOp2.NOTEQUAL;
        }
        if (this.fn instanceof And) {
            return Hop.OpOp2.AND;
        }
        if (this.fn instanceof Or) {
            return Hop.OpOp2.OR;
        }
        if (this.fn instanceof Power) {
            return Hop.OpOp2.POW;
        }
        if (this.fn instanceof MinusNz) {
            return Hop.OpOp2.MINUS_NZ;
        }
        if (this.fn instanceof Builtin) {
            Builtin.BuiltinCode bfc = ((Builtin)this.fn).getBuiltinCode();
            if (bfc == Builtin.BuiltinCode.MIN) {
                return Hop.OpOp2.MIN;
            }
            if (bfc == Builtin.BuiltinCode.MAX) {
                return Hop.OpOp2.MAX;
            }
            if (bfc == Builtin.BuiltinCode.LOG) {
                return Hop.OpOp2.LOG;
            }
            if (bfc == Builtin.BuiltinCode.LOG_NZ) {
                return Hop.OpOp2.LOG_NZ;
            }
        }
        return Hop.OpOp2.INVALID;
    }
}

