/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNNHelper;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;

public class LibMatrixDNNRotate180Helper {

    static class SparseRotate180Worker
    implements Rotate180Worker {
        private final MatrixBlock in;
        private final MatrixBlock out;
        private final ConvolutionParameters params;
        private final boolean trans;

        public SparseRotate180Worker(MatrixBlock input, MatrixBlock output, ConvolutionParameters params, boolean trans) {
            this.in = input;
            this.out = output;
            this.params = params;
            this.trans = trans;
        }

        @Override
        public void execute(int inputN, int outputN) {
            this.out.reset();
            SparseBlock sblock = this.in.sparseBlock;
            if (sblock == null || sblock.isEmpty(inputN)) {
                return;
            }
            int outputOffset = outputN * this.params.P * this.params.Q;
            int[] tensorIndexes = new int[3];
            int apos = sblock.pos(inputN);
            int alen = sblock.size(inputN);
            int[] aix = sblock.indexes(inputN);
            double[] avals = sblock.values(inputN);
            for (int j = apos; j < apos + alen; ++j) {
                LibMatrixDNNHelper.computeTensorIndexes(aix[j], tensorIndexes, this.params.P, this.params.Q);
                int k = tensorIndexes[0];
                int p = tensorIndexes[1];
                int q = tensorIndexes[2];
                if (this.trans) {
                    this.out.appendValue(k, outputOffset + p * this.params.Q + q, avals[j]);
                    continue;
                }
                this.out.appendValue(outputOffset + p * this.params.Q + q, k, avals[j]);
            }
        }
    }

    static class DenseRotate180Worker
    implements Rotate180Worker {
        double[] inputArray;
        double[] outputArray;
        ConvolutionParameters params;

        public DenseRotate180Worker(MatrixBlock input, double[] outputArray, ConvolutionParameters params) {
            this.outputArray = outputArray;
            this.params = params;
            this.inputArray = input.getDenseBlock();
            if (this.inputArray == null || outputArray == null) {
                throw new RuntimeException("Incorrect usage: empty inputs");
            }
        }

        @Override
        public void execute(int inputN, int outputN) {
            int outputOffset = outputN * this.params.K * this.params.P * this.params.Q;
            for (int k = 0; k < this.params.K; ++k) {
                for (int p = 0; p < this.params.P; ++p) {
                    for (int q = 0; q < this.params.Q; ++q) {
                        this.outputArray[outputOffset + p * this.params.Q * this.params.K + q * this.params.K + k] = this.inputArray[inputN * this.params.K * this.params.P * this.params.Q + k * this.params.P * this.params.Q + p * this.params.Q + q];
                    }
                }
            }
        }
    }

    static interface Rotate180Worker {
        public void execute(int var1, int var2);

        public static Rotate180Worker getWorker(MatrixBlock in, MatrixBlock out, ConvolutionParameters params, boolean zeroOutSparseOutput, boolean trans) {
            if (!in.isInSparseFormat()) {
                return new DenseRotate180Worker(in, out.getDenseBlock(), params);
            }
            return new SparseRotate180Worker(in, out, params, trans);
        }
    }
}

