/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;

public class LibMatrixDNNPoolingHelper {
    private static double max(double aval, double[] b, int bi, int len) {
        double ret = aval;
        for (int i = bi; i < bi + len; ++i) {
            ret = Math.max(ret, b[i]);
        }
        return ret;
    }

    public static class SparseMaxPooling
    implements Callable<Long> {
        private final int _rl;
        private final int _ru;
        private final ConvolutionParameters _params;
        private double[] outputArray;
        private final int C;
        private final int P;
        private final int Q;
        private final int W;
        private final int H;
        private final int CPQ;
        private final int PQ;

        public SparseMaxPooling(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
            this.outputArray = params.output.getDenseBlock();
            this.C = params.C;
            this.P = params.P;
            this.Q = params.Q;
            this.H = params.H;
            this.W = params.W;
            this.CPQ = this.C * this.P * this.Q;
            this.PQ = this.P * this.Q;
        }

        @Override
        public Long call() throws Exception {
            Arrays.fill(this.outputArray, this._rl * this.CPQ, this._ru * this.CPQ, this._params.minValForMaxPoolOperations);
            for (int n = this._rl; n < this._ru; ++n) {
                if (!this._params.input1.sparseBlock.isEmpty(n)) {
                    int apos = this._params.input1.sparseBlock.pos(n);
                    int alen = this._params.input1.sparseBlock.size(n);
                    int[] aix = this._params.input1.sparseBlock.indexes(n);
                    double[] avals = this._params.input1.sparseBlock.values(n);
                    int chw = 0;
                    int index = apos;
                    for (int c = 0; c < this.C; ++c) {
                        int outOffset = n * this.CPQ + c * this.PQ;
                        for (int h = 0; h < this.H; ++h) {
                            int w = 0;
                            while (w < this.W) {
                                double nchwVal = 0.0;
                                if (aix[index] == chw) {
                                    nchwVal = avals[index++];
                                    if (index >= apos + alen) {
                                        --index;
                                    }
                                }
                                for (int p = 0; p < this.P; ++p) {
                                    if (h < this._params.start_indexes_h[p] || h >= this._params.end_indexes_h[p]) continue;
                                    int outOffsetWithp = outOffset + p * this.Q;
                                    for (int q = 0; q < this.Q; ++q) {
                                        if (w < this._params.start_indexes_w[q] || w >= this._params.end_indexes_w[q]) continue;
                                        this.outputArray[outOffsetWithp + q] = Math.max(this.outputArray[outOffsetWithp + q], nchwVal);
                                    }
                                }
                                ++w;
                                ++chw;
                            }
                        }
                    }
                    continue;
                }
                Arrays.fill(this.outputArray, n * this.CPQ, (n + 1) * this.CPQ, 0.0);
            }
            return this._params.output.recomputeNonZeros(this._rl, this._ru - 1);
        }
    }

    public static class DenseMaxPooling
    implements Callable<Long> {
        private final int _rl;
        private final int _ru;
        private final ConvolutionParameters _params;

        public DenseMaxPooling(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
        }

        @Override
        public Long call() throws Exception {
            int C = this._params.C;
            int P = this._params.P;
            int Q = this._params.Q;
            int R = this._params.R;
            int S = this._params.S;
            int H = this._params.H;
            int W = this._params.W;
            int HW = this._params.H * this._params.W;
            int CHW = this._params.C * this._params.H * this._params.W;
            int CPQ = C * P * Q;
            double[] in = this._params.input1.getDenseBlock();
            double[] out = this._params.output.getDenseBlock();
            double minValForMaxPoolOperations = this._params.minValForMaxPoolOperations;
            if (!this._params.isStride1Pad0() || !this._params.isAllOnes(P, Q, W)) {
                Arrays.fill(out, this._rl * CPQ, this._ru * CPQ, minValForMaxPoolOperations);
            }
            if (this._params.isStride1Pad0() && this._params.isAllOnes(P, Q, W)) {
                int lenh = Math.min(R, H);
                int i = this._rl;
                int oix = this._rl * C;
                while (i < this._ru) {
                    int c = 0;
                    int off = i * CHW;
                    while (c < C) {
                        out[oix + c] = LibMatrixDNNPoolingHelper.max(minValForMaxPoolOperations, in, off, lenh);
                        ++c;
                        off += H;
                    }
                    ++i;
                    oix += C;
                }
            } else if (this._params.isStride1Pad0()) {
                for (int i = this._rl; i < this._ru; ++i) {
                    int c = 0;
                    int off = i * CHW;
                    int oix = i * CPQ;
                    while (c < C) {
                        int p = 0;
                        while (p < P) {
                            for (int h = p; h < Math.min(p + R, H); ++h) {
                                int off2 = off + h * W;
                                for (int q = 0; q < Q; ++q) {
                                    out[oix + q] = LibMatrixDNNPoolingHelper.max(out[oix + q], in, off2 + q, Math.min(S, W - q));
                                }
                            }
                            ++p;
                            oix += Q;
                        }
                        ++c;
                        off += HW;
                    }
                }
            } else {
                int[] hl = this._params.start_indexes_h;
                int[] hu = this._params.end_indexes_h;
                int[] wl = this._params.start_indexes_w;
                int[] wu = this._params.end_indexes_w;
                for (int i = this._rl; i < this._ru; ++i) {
                    int c = 0;
                    int off = i * CHW;
                    int oix = i * CPQ;
                    while (c < C) {
                        int p = 0;
                        while (p < P) {
                            for (int h = hl[p]; h < hu[p]; ++h) {
                                int off2 = off + h * W;
                                for (int q = 0; q < Q; ++q) {
                                    out[oix + q] = LibMatrixDNNPoolingHelper.max(out[oix + q], in, off2 + wl[q], wu[q] - wl[q]);
                                }
                            }
                            ++p;
                            oix += Q;
                        }
                        ++c;
                        off += HW;
                    }
                }
            }
            return this._params.output.recomputeNonZeros(this._rl, this._ru - 1);
        }
    }
}

