/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.ReaderTextCell;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ReaderTextCellParallel
extends MatrixReader {
    private static final long MIN_FILESIZE_MM = 8192L;
    private boolean _isMMFile = false;
    private int _numThreads = 1;

    public ReaderTextCellParallel(InputInfo info) {
        this._isMMFile = info == InputInfo.MatrixMarketInputInfo;
        this._numThreads = OptimizerUtils.getParallelTextReadParallelism();
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderTextCellParallel.checkValidInputFile(fs, path);
        MatrixBlock ret = ReaderTextCellParallel.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        this.readTextCellMatrixFromHDFS(path, job, ret, rlen, clen, brlen, bclen, this._isMMFile);
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        return new ReaderTextCell(this._isMMFile ? InputInfo.MatrixMarketInputInfo : InputInfo.TextCellInputInfo).readMatrixFromInputStream(is, rlen, clen, brlen, bclen, estnnz);
    }

    private void readTextCellMatrixFromHDFS(Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean matrixMarket) throws IOException {
        int par = this._numThreads;
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        if (this._isMMFile) {
            long len = MapReduceTool.getFilesizeOnHDFS(path);
            par = len < 8192L ? 1 : par;
        }
        try {
            ExecutorService pool = Executors.newFixedThreadPool(par);
            InputSplit[] splits = informat.getSplits(job, par);
            ArrayList<ReadTask> tasks = new ArrayList<ReadTask>();
            for (InputSplit split : splits) {
                ReadTask t = new ReadTask(split, informat, job, dest, rlen, clen, matrixMarket);
                tasks.add(t);
            }
            List rt = pool.invokeAll(tasks);
            long lnnz = 0L;
            for (Future task : rt) {
                lnnz += ((Long)task.get()).longValue();
            }
            dest.setNonZeros(lnnz);
            if (dest.isInSparseFormat()) {
                ReaderTextCellParallel.sortSparseRowsParallel(dest, rlen, this._numThreads, pool);
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
    }

    public static class CellBuffer {
        public static final int CAPACITY = 102400;
        private int[] _rlen = new int[102400];
        private int[] _clen = new int[102400];
        private double[] _vals = new double[102400];
        private int _pos = -1;

        public void addCell(int rlen, int clen, double val) {
            if (val == 0.0) {
                return;
            }
            ++this._pos;
            this._rlen[this._pos] = rlen;
            this._clen[this._pos] = clen;
            this._vals[this._pos] = val;
        }

        public void flushCellBufferToMatrixBlock(MatrixBlock dest) {
            for (int i = 0; i <= this._pos; ++i) {
                dest.appendValue(this._rlen[i], this._clen[i], this._vals[i]);
            }
            this.reset();
        }

        public int size() {
            return this._pos + 1;
        }

        public void reset() {
            this._pos = -1;
        }
    }

    public static class ReadTask
    implements Callable<Long> {
        private InputSplit _split = null;
        private boolean _sparse = false;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private MatrixBlock _dest = null;
        private long _rlen = -1L;
        private long _clen = -1L;
        private boolean _matrixMarket = false;

        public ReadTask(InputSplit split, TextInputFormat informat, JobConf job, MatrixBlock dest, long rlen, long clen, boolean matrixMarket) {
            this._split = split;
            this._sparse = dest.isInSparseFormat();
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._rlen = rlen;
            this._clen = clen;
            this._matrixMarket = matrixMarket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            long lnnz;
            block21: {
                lnnz = 0L;
                LongWritable key = new LongWritable();
                Text value = new Text();
                int row = -1;
                int col = -1;
                FastStringTokenizer st = new FastStringTokenizer(' ');
                RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
                try {
                    MatrixBlock matrixBlock;
                    double lvalue;
                    if (this._matrixMarket) {
                        boolean foundComment = false;
                        while (reader.next((Object)key, (Object)value) && value.toString().charAt(0) == '%') {
                            foundComment = true;
                        }
                        if (!foundComment) {
                            st.reset(value.toString());
                            row = st.nextInt() - 1;
                            col = st.nextInt() - 1;
                            lvalue = st.nextDoubleForParallel();
                            matrixBlock = this._dest;
                            synchronized (matrixBlock) {
                                this._dest.appendValue(row, col, lvalue);
                                ++lnnz;
                            }
                        }
                    }
                    if (this._sparse) {
                        CellBuffer buff = new CellBuffer();
                        while (reader.next((Object)key, (Object)value)) {
                            st.reset(value.toString());
                            row = st.nextInt() - 1;
                            col = st.nextInt() - 1;
                            lvalue = st.nextDoubleForParallel();
                            buff.addCell(row, col, lvalue);
                            if (buff.size() < 102400) continue;
                            matrixBlock = this._dest;
                            synchronized (matrixBlock) {
                                lnnz += (long)buff.size();
                                buff.flushCellBufferToMatrixBlock(this._dest);
                            }
                        }
                        MatrixBlock matrixBlock2 = this._dest;
                        synchronized (matrixBlock2) {
                            lnnz += (long)buff.size();
                            buff.flushCellBufferToMatrixBlock(this._dest);
                            break block21;
                        }
                    }
                    while (reader.next((Object)key, (Object)value)) {
                        st.reset(value.toString());
                        row = st.nextInt() - 1;
                        col = st.nextInt() - 1;
                        double lvalue2 = st.nextDoubleForParallel();
                        this._dest.setValueDenseUnsafe(row, col, lvalue2);
                        lnnz += lvalue2 != 0.0 ? 1L : 0L;
                    }
                }
                catch (Exception ex) {
                    if (row < 0 || (long)(row + 1) > this._rlen || col < 0 || (long)(col + 1) > this._clen) {
                        throw new RuntimeException("Matrix cell [" + (row + 1) + "," + (col + 1) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "]. ", ex);
                    }
                    throw new RuntimeException("Unable to read matrix in text cell format. ", ex);
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            return lnnz;
        }
    }
}

