/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.MatrixMatrixRelationalCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarMatrixRelationalCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarScalarRelationalCPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class RelationalBinaryCPInstruction
extends BinaryCPInstruction {
    protected RelationalBinaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.RelationalBinary, op, in1, in2, out, opcode, istr);
    }

    public static RelationalBinaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        BinaryOperator operator;
        InstructionUtils.checkNumFields(str, 3);
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = RelationalBinaryCPInstruction.parseBinaryInstruction(str, in1, in2, out);
        RelationalBinaryCPInstruction.checkOutputDataType(in1, in2, out);
        Operator operator2 = in1.getDataType() != in2.getDataType() ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType() == Expression.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (in1.getDataType() == Expression.DataType.SCALAR && in2.getDataType() == Expression.DataType.SCALAR) {
            return new ScalarScalarRelationalCPInstruction(operator, in1, in2, out, opcode, str);
        }
        if (in1.getDataType() == Expression.DataType.MATRIX && in2.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixMatrixRelationalCPInstruction(operator, in1, in2, out, opcode, str);
        }
        return new ScalarMatrixRelationalCPInstruction(operator, in1, in2, out, opcode, str);
    }
}

