/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MatrixBuiltinNaryCPInstruction
extends BuiltinNaryCPInstruction {
    protected MatrixBuiltinNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand[] inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock in1 = ec.getMatrixInput(this.inputs[0].getName());
        MatrixBlock[] in2 = new MatrixBlock[this.inputs.length - 1];
        for (int i = 1; i < this.inputs.length; ++i) {
            in2[i - 1] = ec.getMatrixInput(this.inputs[i].getName());
        }
        MatrixBlock outBlock = null;
        if (!"cbind".equals(this.getOpcode()) && !"rbind".equals(this.getOpcode())) {
            throw new DMLRuntimeException("Unknown opcode: " + this.getOpcode());
        }
        boolean cbind = "cbind".equals(this.getOpcode());
        outBlock = in1.appendOperations(in2, new MatrixBlock(), cbind);
        for (int i = 0; i < this.inputs.length; ++i) {
            ec.releaseMatrixInput(this.inputs[i].getName());
        }
        ec.setMatrixOutput(this.output.getName(), outBlock);
    }
}

