/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.StringTokenizer;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.And;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.Divide;
import org.apache.sysml.runtime.functionobjects.Equals;
import org.apache.sysml.runtime.functionobjects.GreaterThan;
import org.apache.sysml.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysml.runtime.functionobjects.IndexFunction;
import org.apache.sysml.runtime.functionobjects.IntegerDivide;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.LessThan;
import org.apache.sysml.runtime.functionobjects.LessThanEquals;
import org.apache.sysml.runtime.functionobjects.Mean;
import org.apache.sysml.runtime.functionobjects.Minus;
import org.apache.sysml.runtime.functionobjects.Minus1Multiply;
import org.apache.sysml.runtime.functionobjects.MinusMultiply;
import org.apache.sysml.runtime.functionobjects.MinusNz;
import org.apache.sysml.runtime.functionobjects.Modulus;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Multiply2;
import org.apache.sysml.runtime.functionobjects.NotEquals;
import org.apache.sysml.runtime.functionobjects.Or;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.functionobjects.Power;
import org.apache.sysml.runtime.functionobjects.Power2;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceDiag;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.GPUInstructionParser;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.SPInstructionParser;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysml.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class InstructionUtils {
    public static int checkNumFields(String str, int expected) throws DMLRuntimeException {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected) throws DMLRuntimeException {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected1, int expected2) throws DMLRuntimeException {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String str, int expected1, int expected2) throws DMLRuntimeException {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static String[] getInstructionParts(String str) {
        StringTokenizer st = new StringTokenizer(str, "\u00b0");
        String[] ret = new String[st.countTokens() - 1];
        st.nextToken();
        ret[0] = st.nextToken();
        int index = 1;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            int ix = tmp.indexOf("\u00b7");
            ret[index++] = tmp.substring(0, ix >= 0 ? ix : tmp.length());
        }
        return ret;
    }

    public static String[] getInstructionPartsWithValueType(String str) {
        String[] parts = str.split("\u00b0", -1);
        String[] ret = new String[parts.length - 1];
        ret[0] = parts[1];
        for (int i = 1; i < parts.length; ++i) {
            ret[i - 1] = parts[i];
        }
        return ret;
    }

    public static String getOpCode(String str) {
        int ix1 = str.indexOf("\u00b0");
        int ix2 = str.indexOf("\u00b0", ix1 + 1);
        return str.substring(ix1 + 1, ix2);
    }

    public static MRInstruction.MRINSTRUCTION_TYPE getMRType(String str) {
        return MRInstructionParser.String2MRInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static SPInstruction.SPINSTRUCTION_TYPE getSPType(String str) {
        return SPInstructionParser.String2SPInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static CPInstruction.CPType getCPType(String str) {
        return CPInstructionParser.String2CPInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static GPUInstruction.GPUINSTRUCTION_TYPE getGPUType(String str) {
        return GPUInstructionParser.String2GPUInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static boolean isBuiltinFunction(String opcode) {
        Builtin.BuiltinCode bfc = Builtin.String2BuiltinCode.get(opcode);
        return bfc != null;
    }

    public static boolean isDistributedCacheUsed(String str) {
        String[] parts;
        for (String inst : parts = str.split("\u2021")) {
            String opcode = InstructionUtils.getOpCode(inst);
            if (!opcode.equalsIgnoreCase("mappend") && !opcode.equalsIgnoreCase("mapmm") && !opcode.equalsIgnoreCase("mapmmchain") && !opcode.equalsIgnoreCase("pmm") && !opcode.equalsIgnoreCase("uaggouterchain") && !opcode.equalsIgnoreCase("mapgroupedagg") && !InstructionUtils.isDistQuaternaryOpcode(opcode) && !BinaryM.isOpcode(opcode)) continue;
            return true;
        }
        return false;
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode) {
        return InstructionUtils.parseBasicAggregateUnaryOperator(opcode, 1);
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode, int numThreads) {
        AggregateUnaryOperator aggun = null;
        if (opcode.equalsIgnoreCase("uak+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uark+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uack+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uasqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarsqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacsqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), true, PartialAggregate.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), true, PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), true, PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), true, PartialAggregate.CorrectionLocationType.LASTTWOROWS);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uavar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            PartialAggregate.CorrectionLocationType cloc = PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, true, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarvar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            PartialAggregate.CorrectionLocationType cloc = PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, true, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacvar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            PartialAggregate.CorrectionLocationType cloc = PartialAggregate.CorrectionLocationType.LASTFOURROWS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, true, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("ua+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uar+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uac+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("ua*")) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamax")) {
            AggregateOperator agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamin")) {
            AggregateOperator agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uatrace")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uaktrace")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmax")) {
            AggregateOperator agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarimax")) {
            AggregateOperator agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("maxindex"), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmin")) {
            AggregateOperator agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarimin")) {
            AggregateOperator agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("minindex"), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmax")) {
            AggregateOperator agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmin")) {
            AggregateOperator agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        }
        return aggun;
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode) {
        return InstructionUtils.parseAggregateTernaryOperator(opcode, 1);
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode, int numThreads) {
        PartialAggregate.CorrectionLocationType corr = opcode.equalsIgnoreCase("tak+*") ? PartialAggregate.CorrectionLocationType.LASTCOLUMN : PartialAggregate.CorrectionLocationType.LASTROW;
        AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, corr);
        IndexFunction ixfun = opcode.equalsIgnoreCase("tak+*") ? ReduceAll.getReduceAllFnObject() : ReduceRow.getReduceRowFnObject();
        return new AggregateTernaryOperator(Multiply.getMultiplyFnObject(), agg, ixfun, numThreads);
    }

    public static AggregateOperator parseAggregateOperator(String opcode, String corrExists, String corrLoc) {
        AggregateOperator agg = null;
        if (opcode.equalsIgnoreCase("ak+") || opcode.equalsIgnoreCase("aktrace")) {
            boolean lcorrExists = corrExists == null ? true : Boolean.parseBoolean(corrExists);
            PartialAggregate.CorrectionLocationType lcorrLoc = corrLoc == null ? PartialAggregate.CorrectionLocationType.LASTCOLUMN : PartialAggregate.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrExists, lcorrLoc);
        } else if (opcode.equalsIgnoreCase("asqk+")) {
            boolean lcorrExists = corrExists == null ? true : Boolean.parseBoolean(corrExists);
            PartialAggregate.CorrectionLocationType lcorrLoc = corrLoc == null ? PartialAggregate.CorrectionLocationType.LASTCOLUMN : PartialAggregate.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), lcorrExists, lcorrLoc);
        } else if (opcode.equalsIgnoreCase("a+")) {
            agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        } else if (opcode.equalsIgnoreCase("a*")) {
            agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
        } else if (opcode.equalsIgnoreCase("arimax")) {
            agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("maxindex"), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amax")) {
            agg = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("max"));
        } else if (opcode.equalsIgnoreCase("amin")) {
            agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("min"));
        } else if (opcode.equalsIgnoreCase("arimin")) {
            agg = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("minindex"), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amean")) {
            boolean lcorrExists = corrExists == null ? true : Boolean.parseBoolean(corrExists);
            PartialAggregate.CorrectionLocationType lcorrLoc = corrLoc == null ? PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS : PartialAggregate.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrExists, lcorrLoc);
        } else if (opcode.equalsIgnoreCase("avar")) {
            boolean lcorrExists = corrExists == null ? true : Boolean.parseBoolean(corrExists);
            PartialAggregate.CorrectionLocationType lcorrLoc = corrLoc == null ? PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS : PartialAggregate.CorrectionLocationType.valueOf(corrLoc);
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            agg = new AggregateOperator(0.0, varFn, lcorrExists, lcorrLoc);
        }
        return agg;
    }

    public static AggregateUnaryOperator parseBasicCumulativeAggregateUnaryOperator(UnaryOperator uop) {
        Builtin f = (Builtin)uop.fn;
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMSUM) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uack+");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMPROD) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uac*");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMIN) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uacmin");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMAX) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uacmax");
        }
        throw new RuntimeException("Unsupported cumulative aggregate unary operator: " + (Object)((Object)f.getBuiltinCode()));
    }

    public static AggregateUnaryOperator parseCumulativeAggregateUnaryOperator(String opcode) {
        AggregateUnaryOperator aggun = null;
        if ("ucumack+".equals(opcode)) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
        } else if ("ucumac*".equals(opcode)) {
            AggregateOperator agg = new AggregateOperator(0.0, Multiply.getMultiplyFnObject(), false, PartialAggregate.CorrectionLocationType.NONE);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
        } else if ("ucumacmin".equals(opcode)) {
            AggregateOperator agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("min"), false, PartialAggregate.CorrectionLocationType.NONE);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
        } else if ("ucumacmax".equals(opcode)) {
            AggregateOperator agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("max"), false, PartialAggregate.CorrectionLocationType.NONE);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
        }
        return aggun;
    }

    public static BinaryOperator parseBinaryOperator(String opcode) throws DMLRuntimeException {
        if (opcode.equalsIgnoreCase("==")) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("!=")) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("<")) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(">")) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase("<=")) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(">=")) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("&&")) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase("||")) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase("+")) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase("-")) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase("*")) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("1-*")) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase("/")) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase("%%")) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase("%/%")) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase("^")) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase("max")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase("min")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        if (opcode.equalsIgnoreCase("+*")) {
            return new BinaryOperator(PlusMultiply.getPlusMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("-*")) {
            return new BinaryOperator(MinusMultiply.getMinusMultiplyFnObject());
        }
        throw new DMLRuntimeException("Unknown binary opcode " + opcode);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar) throws DMLRuntimeException {
        double default_constant = 0.0;
        return InstructionUtils.parseScalarBinaryOperator(opcode, arg1IsScalar, default_constant);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar, double constant) throws DMLRuntimeException {
        if (opcode.equalsIgnoreCase("+")) {
            return new RightScalarOperator(Plus.getPlusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("*")) {
            return new RightScalarOperator(Multiply.getMultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("-")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
            }
            return new RightScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("-nz")) {
            return new RightScalarOperator(MinusNz.getMinusNzFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("/")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
            }
            return new RightScalarOperator(Divide.getDivideFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("%%")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Modulus.getFnObject(), constant);
            }
            return new RightScalarOperator(Modulus.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("%/%")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(IntegerDivide.getFnObject(), constant);
            }
            return new RightScalarOperator(IntegerDivide.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("^")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Power.getPowerFnObject(), constant);
            }
            return new RightScalarOperator(Power.getPowerFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("max")) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("max"), constant);
        }
        if (opcode.equalsIgnoreCase("min")) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("min"), constant);
        }
        if (opcode.equalsIgnoreCase("log") || opcode.equalsIgnoreCase("log_nz")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
            }
            return new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
        }
        if (opcode.equalsIgnoreCase(">")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(">=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("<")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThan.getLessThanFnObject(), constant);
            }
            return new RightScalarOperator(LessThan.getLessThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("<=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("==")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Equals.getEqualsFnObject(), constant);
            }
            return new RightScalarOperator(Equals.getEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("!=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
            }
            return new RightScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new RightScalarOperator(Multiply2.getMultiply2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new RightScalarOperator(Power2.getPower2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("1-*")) {
            return new RightScalarOperator(Minus1Multiply.getMinus1MultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("s-r")) {
            return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("so")) {
            return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
        }
        throw new DMLRuntimeException("Unknown binary opcode " + opcode);
    }

    public static BinaryOperator parseExtendedBinaryOperator(String opcode) throws DMLRuntimeException {
        if (opcode.equalsIgnoreCase("==") || opcode.equalsIgnoreCase("map==")) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("!=") || opcode.equalsIgnoreCase("map!=")) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("<") || opcode.equalsIgnoreCase("map<")) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(">") || opcode.equalsIgnoreCase("map>")) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase("<=") || opcode.equalsIgnoreCase("map<=")) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(">=") || opcode.equalsIgnoreCase("map>=")) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("&&")) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase("||")) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase("+") || opcode.equalsIgnoreCase("map+")) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase("-") || opcode.equalsIgnoreCase("map-")) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase("*") || opcode.equalsIgnoreCase("map*")) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("1-*") || opcode.equalsIgnoreCase("map1-*")) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase("/") || opcode.equalsIgnoreCase("map/")) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase("%%") || opcode.equalsIgnoreCase("map%%")) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase("%/%") || opcode.equalsIgnoreCase("map%/%")) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase("^") || opcode.equalsIgnoreCase("map^")) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase("max") || opcode.equalsIgnoreCase("mapmax")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase("min") || opcode.equalsIgnoreCase("mapmin")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        throw new DMLRuntimeException("Unknown binary opcode " + opcode);
    }

    public static String deriveAggregateOperatorOpcode(String opcode) {
        if (opcode.equalsIgnoreCase("uak+") || opcode.equalsIgnoreCase("uark+") || opcode.equalsIgnoreCase("uack+")) {
            return "ak+";
        }
        if (opcode.equalsIgnoreCase("uasqk+") || opcode.equalsIgnoreCase("uarsqk+") || opcode.equalsIgnoreCase("uacsqk+")) {
            return "asqk+";
        }
        if (opcode.equalsIgnoreCase("uamean") || opcode.equalsIgnoreCase("uarmean") || opcode.equalsIgnoreCase("uacmean")) {
            return "amean";
        }
        if (opcode.equalsIgnoreCase("uavar") || opcode.equalsIgnoreCase("uarvar") || opcode.equalsIgnoreCase("uacvar")) {
            return "avar";
        }
        if (opcode.equalsIgnoreCase("ua+") || opcode.equalsIgnoreCase("uar+") || opcode.equalsIgnoreCase("uac+")) {
            return "a+";
        }
        if (opcode.equalsIgnoreCase("ua*")) {
            return "a*";
        }
        if (opcode.equalsIgnoreCase("uatrace") || opcode.equalsIgnoreCase("uaktrace")) {
            return "aktrace";
        }
        if (opcode.equalsIgnoreCase("uamax") || opcode.equalsIgnoreCase("uarmax") || opcode.equalsIgnoreCase("uacmax")) {
            return "amax";
        }
        if (opcode.equalsIgnoreCase("uamin") || opcode.equalsIgnoreCase("uarmin") || opcode.equalsIgnoreCase("uacmin")) {
            return "amin";
        }
        if (opcode.equalsIgnoreCase("uarimax")) {
            return "arimax";
        }
        if (opcode.equalsIgnoreCase("uarimin")) {
            return "arimin";
        }
        return null;
    }

    public static PartialAggregate.CorrectionLocationType deriveAggregateOperatorCorrectionLocation(String opcode) {
        if (opcode.equalsIgnoreCase("uak+") || opcode.equalsIgnoreCase("uark+") || opcode.equalsIgnoreCase("uasqk+") || opcode.equalsIgnoreCase("uarsqk+") || opcode.equalsIgnoreCase("uatrace") || opcode.equalsIgnoreCase("uaktrace")) {
            return PartialAggregate.CorrectionLocationType.LASTCOLUMN;
        }
        if (opcode.equalsIgnoreCase("uack+") || opcode.equalsIgnoreCase("uacsqk+")) {
            return PartialAggregate.CorrectionLocationType.LASTROW;
        }
        if (opcode.equalsIgnoreCase("uamean") || opcode.equalsIgnoreCase("uarmean")) {
            return PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS;
        }
        if (opcode.equalsIgnoreCase("uacmean")) {
            return PartialAggregate.CorrectionLocationType.LASTTWOROWS;
        }
        if (opcode.equalsIgnoreCase("uavar") || opcode.equalsIgnoreCase("uarvar")) {
            return PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS;
        }
        if (opcode.equalsIgnoreCase("uacvar")) {
            return PartialAggregate.CorrectionLocationType.LASTFOURROWS;
        }
        if (opcode.equalsIgnoreCase("uarimax") || opcode.equalsIgnoreCase("uarimin")) {
            return PartialAggregate.CorrectionLocationType.LASTCOLUMN;
        }
        return PartialAggregate.CorrectionLocationType.NONE;
    }

    public static boolean isDistQuaternaryOpcode(String opcode) {
        return "mapwsloss".equalsIgnoreCase(opcode) || "redwsloss".equalsIgnoreCase(opcode) || "mapwsigmoid".equalsIgnoreCase(opcode) || "redwsigmoid".equalsIgnoreCase(opcode) || "mapwdivmm".equalsIgnoreCase(opcode) || "redwdivmm".equalsIgnoreCase(opcode) || "mapwcemm".equalsIgnoreCase(opcode) || "redwcemm".equalsIgnoreCase(opcode) || "mapwumm".equalsIgnoreCase(opcode) || "redwumm".equalsIgnoreCase(opcode);
    }
}

