/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNodeStatistics;

public class OptNode {
    private ArrayList<OptNode> _childs = null;
    private long _id = -1L;
    private NodeType _ntype = null;
    private ExecType _etype = null;
    private int _k = -1;
    private HashMap<ParamType, String> _params = null;
    private OptNodeStatistics _stats = null;
    private int _beginLine = -1;
    private int _endLine = -1;

    public OptNode(NodeType type) {
        this(type, null);
    }

    public OptNode(NodeType ntype, ExecType etype) {
        this._ntype = ntype;
        this._etype = etype;
        this._k = 1;
    }

    public NodeType getNodeType() {
        return this._ntype;
    }

    public void setNodeType(NodeType type) {
        this._ntype = type;
    }

    public boolean isNodeType(NodeType ... types) {
        return ArrayUtils.contains((Object[])types, (Object)((Object)this._ntype));
    }

    public ExecType getExecType() {
        return this._etype;
    }

    public void setExecType(ExecType type) {
        this._etype = type;
    }

    public void setID(long id) {
        this._id = id;
    }

    public long getID() {
        return this._id;
    }

    public void addParam(ParamType ptype, String val) {
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(ptype, val);
    }

    public void setParams(HashMap<ParamType, String> params) {
        this._params = params;
    }

    public String getParam(ParamType type) {
        return this._params != null ? this._params.get((Object)type) : null;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    public void setBeginLine(int line) {
        this._beginLine = line;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public void setEndLine(int line) {
        this._endLine = line;
    }

    public void setLineNumbers(int begin, int end) {
        this.setBeginLine(begin);
        this.setEndLine(end);
    }

    public void addChild(OptNode child) {
        if (this._childs == null) {
            this._childs = new ArrayList();
        }
        this._childs.add(child);
    }

    public void addChilds(ArrayList<OptNode> childs) {
        if (this._childs == null) {
            this._childs = new ArrayList();
        }
        this._childs.addAll(childs);
    }

    public void setChilds(ArrayList<OptNode> childs) {
        this._childs = childs;
    }

    public ArrayList<OptNode> getChilds() {
        return this._childs;
    }

    public int getK() {
        return this._k;
    }

    public void setK(int k) {
        this._k = k;
    }

    public OptNodeStatistics getStatistics() {
        return this._stats;
    }

    public void setStatistics(OptNodeStatistics stats) {
        this._stats = stats;
    }

    public boolean exchangeChild(OptNode oldNode, OptNode newNode) {
        if (this.isLeaf()) {
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < this._childs.size(); ++i) {
            if (this._childs.get(i) != oldNode) continue;
            this._childs.set(i, newNode);
            ret = true;
        }
        return ret;
    }

    public boolean isLeaf() {
        return this._childs == null || this._childs.isEmpty();
    }

    public boolean hasOnlySimpleChilds() {
        if (this.isLeaf()) {
            return true;
        }
        boolean ret = true;
        for (OptNode n : this._childs) {
            if (n.getNodeType() == NodeType.GENERIC) {
                ret &= n.hasOnlySimpleChilds();
                continue;
            }
            if (n.getNodeType() == NodeType.HOP) continue;
            return false;
        }
        return ret;
    }

    public String getInstructionName() {
        return String.valueOf((Object)this._etype) + "\u00b0" + this.getParam(ParamType.OPSTRING);
    }

    public boolean isRecursive() {
        String rec = this.getParam(ParamType.RECURSIVE_CALL);
        return rec != null ? Boolean.parseBoolean(rec) : false;
    }

    public Collection<OptNode> getNodeList() {
        ArrayList<OptNode> nodes = new ArrayList<OptNode>();
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                nodes.addAll(n.getNodeList());
            }
        }
        nodes.add(this);
        return nodes;
    }

    public Collection<OptNode> getNodeList(ExecType et) {
        ArrayList<OptNode> nodes = new ArrayList<OptNode>();
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                nodes.addAll(n.getNodeList(et));
            }
        }
        if (this._etype == et) {
            nodes.add(this);
        }
        return nodes;
    }

    public Collection<OptNode> getRelevantNodeList() {
        ArrayList<OptNode> nodes = new ArrayList<OptNode>();
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                nodes.addAll(n.getRelevantNodeList());
            }
        }
        if (this._ntype == NodeType.PARFOR || this._ntype == NodeType.HOP) {
            nodes.add(this);
        }
        return nodes;
    }

    public void setSerialParFor() {
        if (this._ntype == NodeType.PARFOR) {
            this._k = 1;
            this._etype = ExecType.CP;
        }
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                n.setSerialParFor();
            }
        }
    }

    public int size() {
        int count = 1;
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                count += n.size();
            }
        }
        return count;
    }

    public boolean isCPOnly() {
        boolean ret;
        boolean bl = ret = this._etype == ExecType.CP;
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                if (!ret) break;
                ret &= n.isCPOnly();
            }
        }
        return ret;
    }

    public int getTotalK() {
        int k = 1;
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                k = Math.max(k, n.getTotalK());
            }
        }
        if (this._ntype == NodeType.PARFOR) {
            k = this._etype == ExecType.CP ? this._k * k : 1;
        }
        return k;
    }

    public long getMaxC(long N) {
        String ts;
        long maxc = N;
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                maxc = Math.min(maxc, n.getMaxC(N));
            }
        }
        if (this._ntype == NodeType.HOP && (ts = this.getParam(ParamType.TASK_SIZE)) != null) {
            maxc = Math.min(maxc, (long)Integer.parseInt(ts));
        }
        if (this._ntype == NodeType.PARFOR && this._etype == ExecType.CP) {
            maxc /= (long)this._k;
        }
        return maxc;
    }

    public boolean hasNestedParallelism(boolean flagNested) {
        boolean ret = false;
        if (this._ntype == NodeType.PARFOR) {
            if (flagNested) {
                return true;
            }
            flagNested = true;
        }
        if (!this.isLeaf()) {
            for (int i = 0; i < this._childs.size() && !ret; ret |= this._childs.get(i).hasNestedParallelism(flagNested), ++i) {
            }
        }
        return ret;
    }

    public boolean hasNestedPartitionReads(boolean flagNested) {
        OptNode n;
        if (this.isLeaf()) {
            String tmp = this.getParam(ParamType.DATA_PARTITION_FORMAT);
            return tmp != null && flagNested && ParForProgramBlock.PartitionFormat.valueOf((String)tmp)._dpf != ParForProgramBlock.PDataPartitionFormat.NONE;
        }
        boolean ret = false;
        for (int i = 0; i < this._childs.size() && !ret; ret |= n.hasNestedPartitionReads(flagNested), ++i) {
            n = this._childs.get(i);
            if (!n._ntype.isLoop()) continue;
            flagNested = true;
        }
        return ret;
    }

    public void checkAndCleanupLeafNodes() {
        if (this.isLeaf()) {
            return;
        }
        for (int i = 0; i < this._childs.size(); ++i) {
            OptNode n = this._childs.get(i);
            n.checkAndCleanupLeafNodes();
            if (!n.isLeaf() || n._ntype == NodeType.HOP || n._ntype == NodeType.INST || n._ntype == NodeType.FUNCCALL) continue;
            this._childs.remove(i);
            --i;
        }
    }

    public void checkAndCleanupRecursiveFunc(Set<String> stack) {
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                n.checkAndCleanupRecursiveFunc(stack);
            }
        }
        if (this._ntype == NodeType.FUNCCALL) {
            String rec = this.getParam(ParamType.RECURSIVE_CALL);
            String fname = this.getParam(ParamType.OPSTRING);
            if (rec != null && Boolean.parseBoolean(rec)) {
                stack.add(fname);
            } else if (stack.contains(fname)) {
                this.addParam(ParamType.RECURSIVE_CALL, "true");
            }
        }
    }

    public String explain(int level, boolean withDetails) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("--");
        }
        if (this._ntype == NodeType.INST || this._ntype == NodeType.HOP) {
            sb.append(this._params.get((Object)ParamType.OPSTRING));
        } else {
            sb.append((Object)this._ntype);
            if (this._beginLine > 0 && this._endLine > 0) {
                sb.append(" (lines ");
                sb.append(this._beginLine);
                sb.append("-");
                sb.append(this._endLine);
                sb.append(")");
            }
        }
        sb.append(", exec=");
        sb.append((Object)this._etype);
        sb.append(", k=");
        sb.append(this._k);
        switch (this._ntype) {
            case PARFOR: {
                sb.append(", dp=");
                sb.append(this._params.get((Object)ParamType.DATA_PARTITIONER));
                sb.append(", tp=");
                sb.append(this._params.get((Object)ParamType.TASK_PARTITIONER));
                sb.append(", rm=");
                sb.append(this._params.get((Object)ParamType.RESULT_MERGE));
                break;
            }
            case FUNCCALL: {
                sb.append(", name=");
                sb.append(this._params.get((Object)ParamType.OPSTRING));
                if (this._params.get((Object)ParamType.RECURSIVE_CALL) == null || !Boolean.parseBoolean(this._params.get((Object)ParamType.RECURSIVE_CALL))) break;
                sb.append(", recursive");
                break;
            }
        }
        sb.append("\n");
        if (this._childs != null) {
            for (OptNode n : this._childs) {
                sb.append(n.explain(level + 1, withDetails));
            }
        }
        return sb.toString();
    }

    public long getMaxProblemSize() {
        long max = 1L;
        if (!this.isLeaf()) {
            for (OptNode n : this._childs) {
                max = Math.max(max, n.getMaxProblemSize());
            }
        }
        if (this._ntype.isLoop() && !this.isLeaf()) {
            String numIter = this.getParam(ParamType.NUM_ITERATIONS);
            max *= numIter != null ? Long.parseLong(numIter) : 10L;
        }
        return max;
    }

    public static enum ParamType {
        OPSTRING,
        TASK_PARTITIONER,
        TASK_SIZE,
        DATA_PARTITIONER,
        DATA_PARTITION_FORMAT,
        DATA_PARTITION_COND,
        DATA_PARTITION_COND_MEM,
        RESULT_MERGE,
        NUM_ITERATIONS,
        RECURSIVE_CALL;

    }

    public static enum ExecType {
        CP,
        MR,
        SPARK;


        public ParForProgramBlock.PExecMode toParForExecMode() {
            switch (this) {
                case CP: {
                    return ParForProgramBlock.PExecMode.LOCAL;
                }
                case MR: {
                    return ParForProgramBlock.PExecMode.REMOTE_MR;
                }
                case SPARK: {
                    return ParForProgramBlock.PExecMode.REMOTE_SPARK;
                }
            }
            return null;
        }
    }

    public static enum NodeType {
        GENERIC,
        FUNCCALL,
        IF,
        WHILE,
        FOR,
        PARFOR,
        INST,
        HOP;


        public boolean isLoop() {
            return this == WHILE || this == FOR || this == PARFOR;
        }
    }
}

