/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupValue;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;

public abstract class ColGroupDDC
extends ColGroupValue {
    private static final long serialVersionUID = -3204391646123465004L;

    public ColGroupDDC() {
    }

    public ColGroupDDC(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
    }

    protected ColGroupDDC(int[] colIndices, int numRows, double[] values) {
        super(colIndices, numRows, values);
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            for (int colIx = 0; colIx < this._colIndexes.length; ++colIx) {
                int col = this._colIndexes[colIx];
                double cellVal = this.getData(i, colIx);
                target.quickSetValue(i, col, cellVal);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colIndexTargets) {
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        for (int i = 0; i < nrow; ++i) {
            for (int colIx = 0; colIx < ncol; ++colIx) {
                int origMatrixColIx = this.getColIndex(colIx);
                int col = colIndexTargets[origMatrixColIx];
                double cellVal = this.getData(i, colIx);
                target.quickSetValue(i, col, cellVal);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int nrow = this.getNumRows();
        for (int i = 0; i < nrow; ++i) {
            double cellVal = this.getData(i, colpos);
            target.quickSetValue(i, 0, cellVal);
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in DDC group.");
        }
        return this.getData(r, ix);
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int ncol = this.getNumCols();
        for (int i = rl; i < ru; ++i) {
            int lnnz = 0;
            for (int colIx = 0; colIx < ncol; ++colIx) {
                lnnz += this.getData(i, colIx) != 0.0 ? 1 : 0;
            }
            int n = i - rl;
            rnnz[n] = rnnz[n] + lnnz;
        }
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        if (op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq) {
            KahanFunction kplus;
            KahanFunction kahanFunction = kplus = op.aggOp.increOp.fn instanceof KahanPlus ? KahanPlus.getKahanPlusFnObject() : KahanPlusSq.getKahanPlusSqFnObject();
            if (op.indexFn instanceof ReduceAll) {
                this.computeSum(result, kplus);
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowSums(result, kplus, rl, ru);
            } else if (op.indexFn instanceof ReduceRow) {
                this.computeColSums(result, kplus);
            }
        } else if (op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX || ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN)) {
            Builtin builtin = (Builtin)op.aggOp.increOp.fn;
            if (op.indexFn instanceof ReduceAll) {
                this.computeMxx(result, builtin, false);
            } else if (op.indexFn instanceof ReduceCol) {
                this.computeRowMxx(result, builtin, rl, ru);
            } else if (op.indexFn instanceof ReduceRow) {
                this.computeColMxx(result, builtin, false);
            }
        }
    }

    protected void computeSum(MatrixBlock result, KahanFunction kplus) {
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        KahanObject kbuff = new KahanObject(result.quickGetValue(0, 0), result.quickGetValue(0, 1));
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                kplus.execute2(kbuff, this.getData(i, j));
            }
        }
        result.quickSetValue(0, 0, kbuff._sum);
        result.quickSetValue(0, 1, kbuff._correction);
    }

    protected void computeColSums(MatrixBlock result, KahanFunction kplus) {
        int j;
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        KahanObject[] kbuff = new KahanObject[this.getNumCols()];
        for (j = 0; j < ncol; ++j) {
            kbuff[j] = new KahanObject(result.quickGetValue(0, this._colIndexes[j]), result.quickGetValue(1, this._colIndexes[j]));
        }
        for (int i = 0; i < nrow; ++i) {
            for (int j2 = 0; j2 < ncol; ++j2) {
                kplus.execute2(kbuff[j2], this.getData(i, j2));
            }
        }
        for (j = 0; j < ncol; ++j) {
            result.quickSetValue(0, this._colIndexes[j], kbuff[j]._sum);
            result.quickSetValue(1, this._colIndexes[j], kbuff[j]._correction);
        }
    }

    protected void computeRowSums(MatrixBlock result, KahanFunction kplus, int rl, int ru) {
        int ncol = this.getNumCols();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        for (int i = rl; i < ru; ++i) {
            kbuff.set(result.quickGetValue(i, 0), result.quickGetValue(i, 1));
            for (int j = 0; j < ncol; ++j) {
                kplus.execute2(kbuff, this.getData(i, j));
            }
            result.quickSetValue(i, 0, kbuff._sum);
            result.quickSetValue(i, 1, kbuff._correction);
        }
    }

    protected void computeRowMxx(MatrixBlock result, Builtin builtin, int rl, int ru) {
        double[] c = result.getDenseBlock();
        int ncol = this.getNumCols();
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < ncol; ++j) {
                c[i] = builtin.execute2(c[i], this.getData(i, j));
            }
        }
    }

    protected final void postScaling(double[] vals, double[] c) {
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        int k = 0;
        int valOff = 0;
        while (k < numVals) {
            double aval = vals[k];
            for (int j = 0; j < ncol; ++j) {
                int colIx;
                int n = colIx = this._colIndexes[j];
                c[n] = c[n] + aval * this._values[valOff + j];
            }
            ++k;
            valOff += ncol;
        }
    }

    protected abstract double getData(int var1);

    protected abstract double getData(int var1, int var2);

    protected abstract void setData(int var1, int var2);

    protected abstract int getCode(int var1);

    @Override
    public long estimateInMemorySize() {
        return super.estimateInMemorySize();
    }

    @Override
    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros, boolean rowMajor) {
        return new DDCIterator(rl, ru, inclZeros);
    }

    @Override
    public ColGroup.ColGroupRowIterator getRowIterator(int rl, int ru) {
        return new DDCRowIterator(rl, ru);
    }

    private class DDCRowIterator
    extends ColGroup.ColGroupRowIterator {
        public DDCRowIterator(int rl, int ru) {
        }

        @Override
        public void next(double[] buff, int rowIx, int segIx, boolean last) {
            int clen = ColGroupDDC.this.getNumCols();
            int off = ColGroupDDC.this.getCode(rowIx) * clen;
            for (int j = 0; j < clen; ++j) {
                buff[ColGroupDDC.this._colIndexes[j]] = ColGroupDDC.this._values[off + j];
            }
        }
    }

    private class DDCIterator
    implements Iterator<IJV> {
        private final int _ru;
        private final boolean _inclZeros;
        private final IJV _buff = new IJV();
        private int _rpos = -1;
        private int _cpos = -1;
        private double _value = 0.0;

        public DDCIterator(int rl, int ru, boolean inclZeros) {
            this._ru = ru;
            this._inclZeros = inclZeros;
            this._rpos = rl;
            this._cpos = -1;
            this.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public IJV next() {
            this._buff.set(this._rpos, ColGroupDDC.this._colIndexes[this._cpos], this._value);
            this.getNextValue();
            return this._buff;
        }

        private void getNextValue() {
            do {
                boolean nextRow = this._cpos + 1 >= ColGroupDDC.this.getNumCols();
                this._rpos += nextRow ? 1 : 0;
                int n = this._cpos = nextRow ? 0 : this._cpos + 1;
                if (this._rpos >= this._ru) {
                    return;
                }
                this._value = ColGroupDDC.this.getData(this._rpos, this._cpos);
            } while (!this._inclZeros && this._value == 0.0);
        }
    }
}

