/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.pydml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringUtils;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BuiltinFunctionExpression;
import org.apache.sysml.parser.ConditionalPredicate;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.ImportStatement;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.IterablePredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.parser.PathStatement;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.common.CommonSyntacticValidator;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.common.ExpressionInfo;
import org.apache.sysml.parser.common.StatementInfo;
import org.apache.sysml.parser.pydml.PyDMLParserWrapper;
import org.apache.sysml.parser.pydml.PydmlListener;
import org.apache.sysml.parser.pydml.PydmlParser;

public class PydmlSyntacticValidator
extends CommonSyntacticValidator
implements PydmlListener {
    public PydmlSyntacticValidator(CustomErrorListener errorListener, Map<String, String> argVals, String sourceNamespace, Set<String> prepFunctions) {
        super(errorListener, argVals, sourceNamespace, prepFunctions);
    }

    @Override
    public String namespaceResolutionOp() {
        return ".";
    }

    @Override
    public String trueStringLiteral() {
        return "True";
    }

    @Override
    public String falseStringLiteral() {
        return "False";
    }

    protected ArrayList<ParameterExpression> getParameterExpressionList(List<PydmlParser.ParameterizedExpressionContext> paramExprs) {
        ArrayList<ParameterExpression> retVal = new ArrayList<ParameterExpression>();
        for (PydmlParser.ParameterizedExpressionContext ctx : paramExprs) {
            String paramName = null;
            if (ctx.paramName != null && ctx.paramName.getText() != null && !ctx.paramName.getText().isEmpty()) {
                paramName = ctx.paramName.getText();
            }
            ParameterExpression myArg = new ParameterExpression(paramName, ctx.paramVal.info.expr);
            retVal.add(myArg);
        }
        return retVal;
    }

    @Override
    public void enterEveryRule(ParserRuleContext arg0) {
        if (arg0 instanceof PydmlParser.StatementContext && ((PydmlParser.StatementContext)arg0).info == null) {
            ((PydmlParser.StatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof PydmlParser.FunctionStatementContext && ((PydmlParser.FunctionStatementContext)arg0).info == null) {
            ((PydmlParser.FunctionStatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof PydmlParser.ExpressionContext && ((PydmlParser.ExpressionContext)arg0).info == null) {
            ((PydmlParser.ExpressionContext)arg0).info = new ExpressionInfo();
        }
        if (arg0 instanceof PydmlParser.DataIdentifierContext && ((PydmlParser.DataIdentifierContext)arg0).dataInfo == null) {
            ((PydmlParser.DataIdentifierContext)arg0).dataInfo = new ExpressionInfo();
        }
    }

    @Override
    public void exitAddSubExpression(PydmlParser.AddSubExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitModIntDivExpression(PydmlParser.ModIntDivExpressionContext ctx) {
        String op = ctx.op.getText();
        String dmlOperator = "";
        if (op.equals("//")) {
            dmlOperator = "%/%";
        } else if (op.equals("%")) {
            dmlOperator = "%%";
        } else {
            this.notifyErrorListeners("Incorrect operator (expected // or %)", ctx.op);
            return;
        }
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, dmlOperator);
    }

    @Override
    public void exitUnaryExpression(PydmlParser.UnaryExpressionContext ctx) {
        this.unaryExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitMultDivExpression(PydmlParser.MultDivExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitPowerExpression(PydmlParser.PowerExpressionContext ctx) {
        String dmlOperator = "";
        String op = ctx.op.getText();
        if (!op.equals("**")) {
            this.notifyErrorListeners("Incorrect operator (expected **)", ctx.op);
            return;
        }
        dmlOperator = "^";
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, dmlOperator);
    }

    @Override
    public void exitRelationalExpression(PydmlParser.RelationalExpressionContext ctx) {
        this.relationalExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanAndExpression(PydmlParser.BooleanAndExpressionContext ctx) {
        String op = ctx.op.getText();
        String dmlOperator = "";
        if (!op.equals("&") && !op.equals("and")) {
            this.notifyErrorListeners("Incorrect operator (expected &)", ctx.op);
            return;
        }
        dmlOperator = "&";
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, dmlOperator);
    }

    @Override
    public void exitBooleanOrExpression(PydmlParser.BooleanOrExpressionContext ctx) {
        String op = ctx.op.getText();
        String dmlOperator = "";
        if (!op.equals("|") && !op.equals("or")) {
            this.notifyErrorListeners("Incorrect operator (expected |)", ctx.op);
            return;
        }
        dmlOperator = "|";
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, dmlOperator);
    }

    @Override
    public void exitBooleanNotExpression(PydmlParser.BooleanNotExpressionContext ctx) {
        this.unaryBooleanExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitAtomicExpression(PydmlParser.AtomicExpressionContext ctx) {
        ctx.info.expr = ctx.left.info.expr;
        this.setFileLineColumn(ctx.info.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitConstFalseExpression(PydmlParser.ConstFalseExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, false, ctx.info);
    }

    @Override
    public void exitConstTrueExpression(PydmlParser.ConstTrueExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, true, ctx.info);
    }

    @Override
    public void exitConstDoubleIdExpression(PydmlParser.ConstDoubleIdExpressionContext ctx) {
        this.constDoubleIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstIntIdExpression(PydmlParser.ConstIntIdExpressionContext ctx) {
        this.constIntIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstStringIdExpression(PydmlParser.ConstStringIdExpressionContext ctx) {
        this.constStringIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitDataIdExpression(PydmlParser.DataIdExpressionContext ctx) {
        this.exitDataIdExpressionHelper(ctx, ctx.info, ctx.dataIdentifier().dataInfo);
    }

    @Override
    public void exitSimpleDataIdentifierExpression(PydmlParser.SimpleDataIdentifierExpressionContext ctx) {
        ctx.dataInfo.expr = new DataIdentifier(ctx.getText());
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitIndexedExpression(PydmlParser.IndexedExpressionContext ctx) {
        boolean isRowLower = ctx.rowLower != null && !ctx.rowLower.isEmpty() && ctx.rowLower.info.expr != null;
        boolean isRowUpper = ctx.rowUpper != null && !ctx.rowUpper.isEmpty() && ctx.rowUpper.info.expr != null;
        boolean isColLower = ctx.colLower != null && !ctx.colLower.isEmpty() && ctx.colLower.info.expr != null;
        boolean isColUpper = ctx.colUpper != null && !ctx.colUpper.isEmpty() && ctx.colUpper.info.expr != null;
        boolean isRowSliceImplicit = ctx.rowImplicitSlice != null;
        boolean isColSliceImplicit = ctx.colImplicitSlice != null;
        ExpressionInfo rowLower = isRowLower ? ctx.rowLower.info : null;
        ExpressionInfo rowUpper = isRowUpper ? ctx.rowUpper.info : null;
        ExpressionInfo colLower = isColLower ? ctx.colLower.info : null;
        ExpressionInfo colUpper = isColUpper ? ctx.colUpper.info : null;
        ctx.dataInfo.expr = new IndexedIdentifier(ctx.name.getText(), false, false);
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
        try {
            IntIdentifier one;
            BuiltinFunctionExpression expr;
            DataIdentifier x;
            Expression.BuiltinFunctionOp bop;
            ArrayList<ArrayList<Expression>> exprList = new ArrayList<ArrayList<Expression>>();
            ArrayList<Expression> rowIndices = new ArrayList<Expression>();
            ArrayList<Expression> colIndices = new ArrayList<Expression>();
            if (!isRowLower && !isRowUpper) {
                rowIndices.add(null);
                rowIndices.add(null);
            } else if (isRowLower && isRowUpper) {
                rowIndices.add(this.incrementByOne(rowLower.expr, ctx));
                rowIndices.add(rowUpper.expr);
            } else if (isRowLower && !isRowUpper) {
                rowIndices.add(this.incrementByOne(rowLower.expr, ctx));
                if (isRowSliceImplicit) {
                    bop = Expression.BuiltinFunctionOp.NROW;
                    x = new DataIdentifier(ctx.name.getText());
                    expr = new BuiltinFunctionExpression((ParserRuleContext)ctx, bop, new Expression[]{x}, this.currentFile);
                    rowIndices.add(expr);
                }
            } else if (!isRowLower && isRowUpper && isRowSliceImplicit) {
                one = new IntIdentifier(ctx, 1L, this.currentFile);
                rowIndices.add(one);
                rowIndices.add(rowUpper.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for row", ctx.start);
                return;
            }
            if (!isColLower && !isColUpper) {
                colIndices.add(null);
                colIndices.add(null);
            } else if (isColLower && isColUpper) {
                colIndices.add(this.incrementByOne(colLower.expr, ctx));
                colIndices.add(colUpper.expr);
            } else if (isColLower && !isColUpper) {
                colIndices.add(this.incrementByOne(colLower.expr, ctx));
                if (isColSliceImplicit) {
                    bop = Expression.BuiltinFunctionOp.NCOL;
                    x = new DataIdentifier(ctx.name.getText());
                    expr = new BuiltinFunctionExpression((ParserRuleContext)ctx, bop, new Expression[]{x}, this.currentFile);
                    colIndices.add(expr);
                }
            } else if (!isColLower && isColUpper && isColSliceImplicit) {
                one = new IntIdentifier(ctx, 1L, this.currentFile);
                colIndices.add(one);
                colIndices.add(colUpper.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for column", ctx.start);
                return;
            }
            exprList.add(rowIndices);
            exprList.add(colIndices);
            ((IndexedIdentifier)ctx.dataInfo.expr).setIndices(exprList);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot set the indices", ctx.start);
            return;
        }
    }

    private Expression incrementByOne(Expression expr, ParserRuleContext ctx) {
        Expression.BinaryOp bop = Expression.getBinaryOp("+");
        BinaryExpression retVal = new BinaryExpression(bop);
        retVal.setLeft(expr);
        retVal.setRight(new DoubleIdentifier(ctx, 1.0, this.currentFile));
        this.setFileLineColumn(retVal, ctx);
        return retVal;
    }

    @Override
    public void exitCommandlineParamExpression(PydmlParser.CommandlineParamExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    @Override
    public void exitCommandlinePositionExpression(PydmlParser.CommandlinePositionExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    private void handleCommandlineArgumentExpression(PydmlParser.DataIdentifierContext ctx) {
        String varName = ctx.getText().trim();
        this.fillExpressionInfoCommandLineParameters(ctx, varName, ctx.dataInfo);
        if (ctx.dataInfo.expr == null && !(ctx.parent instanceof PydmlParser.IfdefAssignmentStatementContext)) {
            String msg = "The parameter " + varName + " either needs to be passed through commandline or initialized to default value.";
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS)) {
                ctx.dataInfo.expr = this.getConstIdFromString(ctx, " ");
                if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.MLCONTEXT)) {
                    this.raiseWarning(msg, ctx.start);
                }
            } else {
                this.notifyErrorListeners(msg, ctx.start);
            }
        }
    }

    @Override
    public void exitImportStatement(PydmlParser.ImportStatementContext ctx) {
        File file;
        String filePath = ctx.filePath.getText();
        String namespace = ".defaultNS";
        if (ctx.namespace != null && ctx.namespace.getText() != null && !ctx.namespace.getText().isEmpty()) {
            namespace = ctx.namespace.getText();
        }
        if (filePath.startsWith("\"") && filePath.endsWith("\"") || filePath.startsWith("'") && filePath.endsWith("'")) {
            filePath = filePath.substring(1, filePath.length() - 1);
        }
        if (!(file = new File(filePath)).isAbsolute()) {
            filePath = this._workingDir + File.separator + filePath;
        }
        this.validateNamespace(namespace, filePath, ctx);
        String scriptID = DMLProgram.constructFunctionKey(namespace, filePath);
        DMLProgram prog = null;
        if (!((HashMap)_scripts.get()).containsKey(scriptID)) {
            ((HashMap)_scripts.get()).put(scriptID, namespace);
            try {
                prog = new PyDMLParserWrapper().doParse(filePath, null, this.getQualifiedNamespace(namespace), this.argVals);
            }
            catch (ParseException e) {
                this.notifyErrorListeners(e.getMessage(), ctx.start);
                return;
            }
            if (prog == null) {
                this.notifyErrorListeners("One or more errors found during importing a program from file " + filePath, ctx.start);
                return;
            }
            ctx.info.namespaces = new HashMap();
            ctx.info.namespaces.put(this.getQualifiedNamespace(namespace), prog);
            ctx.info.stmt = new ImportStatement();
            ((ImportStatement)ctx.info.stmt).setCompletePath(filePath);
            ((ImportStatement)ctx.info.stmt).setFilePath(ctx.filePath.getText());
            ((ImportStatement)ctx.info.stmt).setNamespace(namespace);
        } else {
            prog = new DMLProgram();
            ctx.info.namespaces = new HashMap();
            ctx.info.namespaces.put(this.getQualifiedNamespace(namespace), prog);
            ctx.info.stmt = new ImportStatement();
            ((ImportStatement)ctx.info.stmt).setCompletePath(filePath);
            ((ImportStatement)ctx.info.stmt).setFilePath(ctx.filePath.getText());
            ((ImportStatement)ctx.info.stmt).setNamespace(namespace);
        }
    }

    @Override
    public void exitAssignmentStatement(PydmlParser.AssignmentStatementContext ctx) {
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect parsing for assignment", ctx.start);
            return;
        }
        this.exitAssignmentStatementHelper(ctx, ctx.targetList.getText(), ctx.targetList.dataInfo, ctx.targetList.start, ctx.source.info, ctx.info);
    }

    private static int getAxis(ParameterExpression ctx) {
        if (ctx.getName() != null && ctx.getName() != null && !ctx.getName().equals("axis")) {
            return -1;
        }
        String val = ctx.getExpr().toString();
        if (val != null && val.equals("0")) {
            return 0;
        }
        if (val != null && val.equals("1")) {
            return 1;
        }
        return -1;
    }

    private static String getPythonAggFunctionNames(String functionName, int axis) {
        if (axis != 0 && axis != 1) {
            return functionName;
        }
        if (functionName.equals("sum")) {
            return axis == 0 ? "colSums" : "rowSums";
        }
        if (functionName.equals("mean")) {
            return axis == 0 ? "colMeans" : "rowMeans";
        }
        if (functionName.equals("var")) {
            return axis == 0 ? "colVars" : "rowVars";
        }
        if (functionName.equals("sd")) {
            return axis == 0 ? "colSds" : "rowSds";
        }
        if (functionName.equals("avg")) {
            return axis == 0 ? "colMeans" : "rowMeans";
        }
        if (functionName.equals("max")) {
            return axis == 0 ? "colMaxs" : "rowMaxs";
        }
        if (functionName.equals("min")) {
            return axis == 0 ? "colMins" : "rowMins";
        }
        if (functionName.equals("argmin")) {
            return axis == 0 ? "Not Supported" : "rowIndexMin";
        }
        if (functionName.equals("argmax")) {
            return axis == 0 ? "Not Supported" : "rowIndexMax";
        }
        if (functionName.equals("cumsum")) {
            return axis == 0 ? "cumsum" : "Not Supported";
        }
        if (functionName.equals("transpose")) {
            return axis == 0 ? "Not Supported" : "Not Supported";
        }
        if (functionName.equals("trace")) {
            return axis == 0 ? "Not Supported" : "Not Supported";
        }
        return functionName;
    }

    @Override
    public CommonSyntacticValidator.ConvertedDMLSyntax convertToDMLSyntax(ParserRuleContext ctx, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, Token fnName) {
        return this.convertPythonBuiltinFunctionToDMLSyntax(ctx, namespace, functionName, paramExpression, fnName);
    }

    private CommonSyntacticValidator.ConvertedDMLSyntax convertPythonBuiltinFunctionToDMLSyntax(ParserRuleContext ctx, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, Token fnName) {
        if (this.sources.containsValue(namespace) || this.functions.contains(functionName)) {
            return new CommonSyntacticValidator.ConvertedDMLSyntax(namespace, functionName, paramExpression);
        }
        if (namespace.equals(".defaultNS") && functionName.equals("len")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 1 arguments", fnName);
                return null;
            }
            functionName = "length";
        } else if (functionName.equals("sum") || functionName.equals("mean") || functionName.equals("avg") || functionName.equals("min") || functionName.equals("max") || functionName.equals("argmax") || functionName.equals("argmin") || functionName.equals("cumsum") || functionName.equals("transpose") || functionName.equals("trace") || functionName.equals("var") || functionName.equals("sd")) {
            if (namespace.equals(".defaultNS") && paramExpression.size() == 1) {
                if (functionName.equals("avg")) {
                    functionName = "mean";
                } else if (functionName.equals("transpose")) {
                    functionName = "t";
                } else if (functionName.equals("argmax") || functionName.equals("argmin") || functionName.equals("cumsum")) {
                    this.notifyErrorListeners("The builtin function '" + functionName + "' for entire matrix is not supported", fnName);
                    return null;
                }
            } else if (!namespace.equals(".defaultNS") && paramExpression.size() == 0) {
                paramExpression = new ArrayList();
                paramExpression.add(new ParameterExpression(null, new DataIdentifier(namespace)));
                if (functionName.equals("avg")) {
                    functionName = "mean";
                } else if (functionName.equals("transpose")) {
                    functionName = "t";
                } else if (functionName.equals("argmax") || functionName.equals("argmin") || functionName.equals("cumsum")) {
                    this.notifyErrorListeners("The builtin function '" + functionName + "' for entire matrix is not supported", fnName);
                    return null;
                }
            } else if (namespace.equals(".defaultNS") && paramExpression.size() == 2) {
                int axis = PydmlSyntacticValidator.getAxis(paramExpression.get(1));
                if (axis != -1 || !functionName.equals("min") && !functionName.equals("max")) {
                    if (axis == -1) {
                        this.notifyErrorListeners("The builtin function '" + functionName + "' for given arguments is not supported", fnName);
                        return null;
                    }
                    ArrayList<ParameterExpression> temp = new ArrayList<ParameterExpression>();
                    temp.add(paramExpression.get(0));
                    paramExpression = temp;
                    functionName = PydmlSyntacticValidator.getPythonAggFunctionNames(functionName, axis);
                    if (functionName.equals("Not Supported")) {
                        this.notifyErrorListeners("The builtin function '" + functionName + "' for given arguments is not supported", fnName);
                        return null;
                    }
                }
            } else if (!namespace.equals(".defaultNS") && paramExpression.size() == 1) {
                int axis = PydmlSyntacticValidator.getAxis(paramExpression.get(0));
                if (axis == -1) {
                    this.notifyErrorListeners("The builtin function '" + functionName + "' for given arguments is not supported", fnName);
                    return null;
                }
                paramExpression = new ArrayList();
                paramExpression.add(new ParameterExpression(null, new DataIdentifier(namespace)));
                functionName = PydmlSyntacticValidator.getPythonAggFunctionNames(functionName, axis);
                if (functionName.equals("Not Supported")) {
                    this.notifyErrorListeners("The builtin function '" + functionName + "' for given arguments is not supported", fnName);
                    return null;
                }
            } else {
                this.notifyErrorListeners("Incorrect number of arguments for the builtin function '" + functionName + "'.", fnName);
                return null;
            }
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("concatenate")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 2 arguments (Note: concatenate append columns of two matrices)", fnName);
                return null;
            }
            functionName = "append";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("minimum")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 2 arguments", fnName);
                return null;
            }
            functionName = "min";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("maximum")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 2 arguments", fnName);
                return null;
            }
            functionName = "max";
            namespace = ".defaultNS";
        } else if (!namespace.equals(".defaultNS") && functionName.equals("shape")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts only 1 argument (0 or 1)", fnName);
                return null;
            }
            int axis = PydmlSyntacticValidator.getAxis(paramExpression.get(0));
            if (axis == -1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts only 1 argument (0 or 1)", fnName);
                return null;
            }
            paramExpression = new ArrayList();
            paramExpression.add(new ParameterExpression(null, new DataIdentifier(namespace)));
            namespace = ".defaultNS";
            if (axis == 0) {
                functionName = "nrow";
            } else if (axis == 1) {
                functionName = "ncol";
            }
        } else if (namespace.equals("random") && functionName.equals("normal")) {
            if (paramExpression.size() != 3) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 3 arguments (number of rows, number of columns, sparsity)", fnName);
                return null;
            }
            paramExpression.get(0).setName("rows");
            paramExpression.get(1).setName("cols");
            paramExpression.get(2).setName("sparsity");
            paramExpression.add(new ParameterExpression("pdf", new StringIdentifier(ctx, "normal", this.currentFile)));
            functionName = "rand";
            namespace = ".defaultNS";
        } else if (namespace.equals("random") && functionName.equals("poisson")) {
            if (paramExpression.size() != 4) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 3 arguments (number of rows, number of columns, sparsity, lambda)", fnName);
                return null;
            }
            paramExpression.get(0).setName("rows");
            paramExpression.get(1).setName("cols");
            paramExpression.get(2).setName("sparsity");
            paramExpression.get(3).setName("lambda");
            paramExpression.add(new ParameterExpression("pdf", new StringIdentifier(ctx, "poisson", this.currentFile)));
            functionName = "rand";
            namespace = ".defaultNS";
        } else if (namespace.equals("random") && functionName.equals("uniform")) {
            if (paramExpression.size() != 5) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 5 arguments (number of rows, number of columns, sparsity, min, max)", fnName);
                return null;
            }
            paramExpression.get(0).setName("rows");
            paramExpression.get(1).setName("cols");
            paramExpression.get(2).setName("sparsity");
            paramExpression.get(3).setName("min");
            paramExpression.get(4).setName("max");
            paramExpression.add(new ParameterExpression("pdf", new StringIdentifier(ctx, "uniform", this.currentFile)));
            functionName = "rand";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("full")) {
            if (paramExpression.size() != 3) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 3 arguments (constant float value, number of rows, number of columns)", fnName);
                return null;
            }
            paramExpression.get(1).setName("rows");
            paramExpression.get(2).setName("cols");
            functionName = "matrix";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("matrix")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 1 argument (either str or float value)", fnName);
                return null;
            }
            if (paramExpression.get(0).getExpr() instanceof StringIdentifier) {
                String initializerString = ((StringIdentifier)paramExpression.get(0).getExpr()).getValue().trim();
                if (!initializerString.startsWith("[") || !initializerString.endsWith("]")) {
                    this.notifyErrorListeners("Incorrect initializer string for builtin function '" + functionName + "' (Eg: matrix(\"[1 2 3; 4 5 6]\"))", fnName);
                    return null;
                }
                int rows = StringUtils.countMatches((String)initializerString, (String)";") + 1;
                initializerString = initializerString.replaceAll("; ", ";");
                initializerString = initializerString.replaceAll(" ;", ";");
                initializerString = initializerString.replaceAll("\\[ ", "\\[");
                initializerString = initializerString.replaceAll(" \\]", "\\]");
                int cols = StringUtils.countMatches((String)initializerString, (String)" ") / rows + 1;
                initializerString = initializerString.replaceAll(";", " ");
                initializerString = initializerString.replaceAll("\\[", "");
                initializerString = initializerString.replaceAll("\\]", "");
                paramExpression = new ArrayList();
                paramExpression.add(new ParameterExpression(null, new StringIdentifier(ctx, initializerString, this.currentFile)));
                paramExpression.add(new ParameterExpression("rows", new IntIdentifier(ctx, rows, this.currentFile)));
                paramExpression.add(new ParameterExpression("cols", new IntIdentifier(ctx, cols, this.currentFile)));
            } else {
                functionName = "as.matrix";
            }
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("scalar")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 1 argument", fnName);
                return null;
            }
            functionName = "as.scalar";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("float")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 1 argument", fnName);
                return null;
            }
            functionName = "as.double";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("int")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 1 argument", fnName);
                return null;
            }
            functionName = "as.integer";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("bool")) {
            if (paramExpression.size() != 1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 1 argument", fnName);
                return null;
            }
            functionName = "as.logical";
            namespace = ".defaultNS";
        } else if (!namespace.equals(".defaultNS") && functionName.equals("reshape")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 2 arguments (number of rows, number of columns)", fnName);
                return null;
            }
            paramExpression.get(0).setName("rows");
            paramExpression.get(1).setName("cols");
            ArrayList<ParameterExpression> temp = new ArrayList<ParameterExpression>();
            temp.add(new ParameterExpression(null, new DataIdentifier(namespace)));
            temp.add(paramExpression.get(0));
            temp.add(paramExpression.get(1));
            paramExpression = temp;
            functionName = "matrix";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("removeEmpty")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 2 arguments (matrix, axis=0 or 1)", fnName);
                return null;
            }
            int axis = PydmlSyntacticValidator.getAxis(paramExpression.get(1));
            if (axis == -1) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 2 arguments (matrix, axis=0 or 1)", fnName);
                return null;
            }
            StringIdentifier marginVal = null;
            marginVal = axis == 0 ? new StringIdentifier(ctx, "rows", this.currentFile) : new StringIdentifier(ctx, "cols", this.currentFile);
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("margin");
            paramExpression.get(1).setExpr(marginVal);
            functionName = "removeEmpty";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("replace")) {
            if (paramExpression.size() != 3) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 3 arguments (matrix, scalar value that should be replaced (pattern), scalar value (replacement))", fnName);
                return null;
            }
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("pattern");
            paramExpression.get(2).setName("replacement");
            functionName = "replace";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("range")) {
            if (paramExpression.size() < 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 3 arguments (from, to, increment), with the first 2 lacking default values", fnName);
                return null;
            }
            if (paramExpression.size() > 3) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts 3 arguments (from, to, increment)", fnName);
            }
            functionName = "seq";
            namespace = ".defaultNS";
        } else if (namespace.equals("norm") && functionName.equals("cdf")) {
            if (paramExpression.size() != 3) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 3 arguments (target, mean, sd)", fnName);
                return null;
            }
            functionName = "cdf";
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("mean");
            paramExpression.get(2).setName("sd");
            paramExpression.add(new ParameterExpression("dist", new StringIdentifier(ctx, "normal", this.currentFile)));
            namespace = ".defaultNS";
        } else if (namespace.equals("expon") && functionName.equals("cdf")) {
            if (paramExpression.size() != 2) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 2 arguments (target, mean)", fnName);
                return null;
            }
            functionName = "cdf";
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("mean");
            paramExpression.add(new ParameterExpression("dist", new StringIdentifier(ctx, "exp", this.currentFile)));
            namespace = ".defaultNS";
        } else if (namespace.equals("chi") && functionName.equals("cdf")) {
            if (paramExpression.size() != 2) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 2 arguments (target, df)", fnName);
                return null;
            }
            functionName = "cdf";
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("df");
            paramExpression.add(new ParameterExpression("dist", new StringIdentifier(ctx, "chisq", this.currentFile)));
            namespace = ".defaultNS";
        } else if (namespace.equals("f") && functionName.equals("cdf")) {
            if (paramExpression.size() != 3) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 3 arguments (target, df1, df2)", fnName);
                return null;
            }
            functionName = "cdf";
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("df1");
            paramExpression.get(2).setName("df2");
            paramExpression.add(new ParameterExpression("dist", new StringIdentifier(ctx, "f", this.currentFile)));
            namespace = ".defaultNS";
        } else if (namespace.equals("t") && functionName.equals("cdf")) {
            if (paramExpression.size() != 2) {
                String qualifiedName = namespace + this.namespaceResolutionOp() + functionName;
                this.notifyErrorListeners("The builtin function '" + qualifiedName + "' accepts exactly 2 arguments (target, df)", fnName);
                return null;
            }
            functionName = "cdf";
            paramExpression.get(0).setName("target");
            paramExpression.get(1).setName("df");
            paramExpression.add(new ParameterExpression("dist", new StringIdentifier(ctx, "t", this.currentFile)));
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("percentile")) {
            if (paramExpression.size() != 2 && paramExpression.size() != 3) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts either 2 or 3 arguments", fnName);
                return null;
            }
            functionName = "quantile";
            namespace = ".defaultNS";
        } else if (namespace.equals(".defaultNS") && functionName.equals("arcsin")) {
            functionName = "asin";
        } else if (namespace.equals(".defaultNS") && functionName.equals("arccos")) {
            functionName = "acos";
        } else if (namespace.equals(".defaultNS") && functionName.equals("arctan")) {
            functionName = "atan";
        } else if (namespace.equals(".defaultNS") && functionName.equals("load")) {
            functionName = "read";
        } else if (namespace.equals(".defaultNS") && functionName.equals("eigen")) {
            functionName = "eig";
        } else if (namespace.equals(".defaultNS") && functionName.equals("power")) {
            if (paramExpression.size() != 2) {
                this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 2 arguments", fnName);
                return null;
            }
        } else if (namespace.equals(".defaultNS") && functionName.equals("dot") && paramExpression.size() != 2) {
            this.notifyErrorListeners("The builtin function '" + functionName + "' accepts exactly 2 arguments", fnName);
            return null;
        }
        return new CommonSyntacticValidator.ConvertedDMLSyntax(namespace, functionName, paramExpression);
    }

    @Override
    protected Expression handleLanguageSpecificFunction(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpression) {
        if (functionName.equals("dot") && paramExpression.size() == 2) {
            Expression.BinaryOp bop = Expression.getBinaryOp("%*%");
            BinaryExpression expr = new BinaryExpression(bop);
            expr.setLeft(paramExpression.get(0).getExpr());
            expr.setRight(paramExpression.get(1).getExpr());
            return expr;
        }
        return null;
    }

    @Override
    public void exitFunctionCallAssignmentStatement(PydmlParser.FunctionCallAssignmentStatementContext ctx) {
        HashSet<String> printStatements = new HashSet<String>();
        printStatements.add("print");
        printStatements.add("stop");
        HashSet<String> outputStatements = new HashSet<String>();
        outputStatements.add("save");
        String[] fnNames = this.getQualifiedNames(ctx.name.getText());
        if (fnNames == null) {
            String errorMsg = "incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)";
            this.notifyErrorListeners(errorMsg, ctx.name);
            return;
        }
        String namespace = fnNames[0];
        String functionName = fnNames[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        boolean hasLHS = ctx.targetList != null;
        this.functionCallAssignmentStatementHelper(ctx, printStatements, outputStatements, hasLHS ? ctx.targetList.dataInfo.expr : null, ctx.info, ctx.name, hasLHS ? ctx.targetList.start : null, namespace, functionName, paramExpression, hasLHS);
    }

    private void castAsScalarDeprecationCheck(String functionName, ParserRuleContext ctx) {
        if ("castAsScalar".equalsIgnoreCase(functionName)) {
            this.raiseWarning("castAsScalar() has been deprecated. Please use scalar().", ctx.start);
        }
    }

    @Override
    public void exitBuiltinFunctionExpression(PydmlParser.BuiltinFunctionExpressionContext ctx) {
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        CommonSyntacticValidator.ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        final ExpressionInfo info = ctx.info;
        CommonSyntacticValidator.Action f = new CommonSyntacticValidator.Action(){

            @Override
            public void execute(Expression e) {
                info.expr = e;
            }
        };
        boolean validBIF = this.buildForBuiltInFunction(ctx, functionName, paramExpression, f);
        if (validBIF) {
            return;
        }
        this.notifyErrorListeners("only builtin functions allowed as part of expression", ctx.start);
    }

    @Override
    public void exitFunctionCallMultiAssignmentStatement(PydmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
        PydmlParser.FunctionCallMultiAssignmentStatementContext fctx;
        CommonSyntacticValidator.Action f;
        boolean validBIF;
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace.functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        CommonSyntacticValidator.ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        namespace = convertedSyntax.namespace;
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        FunctionCallIdentifier functCall = new FunctionCallIdentifier(paramExpression);
        functCall.setFunctionName(functionName);
        functCall.setFunctionNamespace(namespace);
        final ArrayList<DataIdentifier> targetList = new ArrayList<DataIdentifier>();
        for (PydmlParser.DataIdentifierContext dataCtx : ctx.targetList) {
            if (dataCtx.dataInfo.expr instanceof DataIdentifier) {
                targetList.add((DataIdentifier)dataCtx.dataInfo.expr);
                continue;
            }
            this.notifyErrorListeners("incorrect type for variable ", dataCtx.start);
            return;
        }
        if (namespace.equals(".defaultNS") && (validBIF = this.buildForBuiltInFunction(ctx, functionName, paramExpression, f = new CommonSyntacticValidator.Action(fctx = ctx){
            final /* synthetic */ PydmlParser.FunctionCallMultiAssignmentStatementContext val$fctx;
            {
                this.val$fctx = functionCallMultiAssignmentStatementContext;
            }

            @Override
            public void execute(Expression e) {
                PydmlSyntacticValidator.this.setMultiAssignmentStatement(targetList, e, this.val$fctx, this.val$fctx.info);
            }
        }))) {
            return;
        }
        String inferNamespace = this.sourceNamespace != null && this.sourceNamespace.length() > 0 && ".defaultNS".equals(namespace) ? this.sourceNamespace : namespace;
        functCall.setFunctionNamespace(inferNamespace);
        this.setMultiAssignmentStatement(targetList, functCall, ctx, ctx.info);
    }

    private static StatementBlock getStatementBlock(Statement current) {
        return ParserWrapper.getStatementBlock(current);
    }

    @Override
    public void exitIfStatement(PydmlParser.IfStatementContext ctx) {
        IfStatement ifStmt = new IfStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        ifStmt.setConditionalPredicate(predicate);
        ifStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.ifBody.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.ifBody) {
                ifStmt.addStatementBlockIfBody(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            ifStmt.mergeStatementBlocksIfBody();
        }
        IfStatement tailIfStmt = ifStmt;
        if (ctx.elifBranches.size() > 0) {
            for (PydmlParser.ElifBranchContext elifCtx : ctx.elifBranches) {
                tailIfStmt.addStatementBlockElseBody(PydmlSyntacticValidator.getStatementBlock(elifCtx.info.stmt));
                tailIfStmt = (IfStatement)elifCtx.info.stmt;
            }
        }
        if (ctx.elseBody.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.elseBody) {
                tailIfStmt.addStatementBlockElseBody(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            tailIfStmt.mergeStatementBlocksElseBody();
        }
        ctx.info.stmt = ifStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitElifBranch(PydmlParser.ElifBranchContext ctx) {
        IfStatement elifStmt = new IfStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        elifStmt.setConditionalPredicate(predicate);
        elifStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.elifBody.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.elifBody) {
                elifStmt.addStatementBlockIfBody(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            elifStmt.mergeStatementBlocksIfBody();
        }
        ctx.info.stmt = elifStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitWhileStatement(PydmlParser.WhileStatementContext ctx) {
        WhileStatement whileStmt = new WhileStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        whileStmt.setPredicate(predicate);
        whileStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.body.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.body) {
                whileStmt.addStatementBlock(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            whileStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = whileStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitForStatement(PydmlParser.ForStatementContext ctx) {
        ForStatement forStmt = new ForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = null;
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        forStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.body) {
                forStmt.addStatementBlock(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            forStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = forStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitParForStatement(PydmlParser.ParForStatementContext ctx) {
        ParForStatement parForStmt = new ParForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = new HashMap<String, String>();
        if (ctx.parForParams != null && ctx.parForParams.size() > 0) {
            for (PydmlParser.StrictParameterizedExpressionContext parForParamCtx : ctx.parForParams) {
                String paramVal = parForParamCtx.paramVal.getText();
                if (this.argVals.containsKey(paramVal)) {
                    paramVal = (String)this.argVals.get(paramVal);
                }
                parForParamValues.put(parForParamCtx.paramName.getText(), paramVal);
            }
        }
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        parForStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (PydmlParser.StatementContext stmtCtx : ctx.body) {
                parForStmt.addStatementBlock(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            parForStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = parForStmt;
    }

    @Override
    public void exitIterablePredicateColonExpression(PydmlParser.IterablePredicateColonExpressionContext ctx) {
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        ctx.info.increment = null;
    }

    @Override
    public void exitIterablePredicateSeqExpression(PydmlParser.IterablePredicateSeqExpressionContext ctx) {
        if (!ctx.ID().getText().equals("range")) {
            this.notifyErrorListeners("incorrect function:'" + ctx.ID().getText() + "'. expected 'range'", ctx.start);
            return;
        }
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        if (ctx.increment != null && ctx.increment.info != null) {
            ctx.info.increment = ctx.increment.info.expr;
        }
    }

    private ArrayList<DataIdentifier> getFunctionParameters(List<PydmlParser.TypedArgNoAssignContext> ctx) {
        ArrayList<DataIdentifier> retVal = new ArrayList<DataIdentifier>();
        for (PydmlParser.TypedArgNoAssignContext paramCtx : ctx) {
            DataIdentifier dataId = new DataIdentifier(paramCtx.paramName.getText());
            String dataType = null;
            String valueType = null;
            dataType = paramCtx.paramType == null || paramCtx.paramType.dataType() == null || paramCtx.paramType.dataType().getText() == null || paramCtx.paramType.dataType().getText().isEmpty() ? "scalar" : paramCtx.paramType.dataType().getText();
            this.checkValidDataType(dataType, paramCtx.start);
            if (dataType.equals("matrix")) {
                dataId.setDataType(Expression.DataType.MATRIX);
            } else if (dataType.equals("frame")) {
                dataId.setDataType(Expression.DataType.FRAME);
            } else if (dataType.equals("scalar")) {
                dataId.setDataType(Expression.DataType.SCALAR);
            }
            valueType = paramCtx.paramType.valueType().getText();
            if (valueType.equals("int")) {
                dataId.setValueType(Expression.ValueType.INT);
            } else if (valueType.equals("str")) {
                dataId.setValueType(Expression.ValueType.STRING);
            } else if (valueType.equals("bool")) {
                dataId.setValueType(Expression.ValueType.BOOLEAN);
            } else if (valueType.equals("float")) {
                dataId.setValueType(Expression.ValueType.DOUBLE);
            } else {
                this.notifyErrorListeners("invalid valuetype " + valueType, paramCtx.start);
                return null;
            }
            retVal.add(dataId);
        }
        return retVal;
    }

    @Override
    public void exitInternalFunctionDefExpression(PydmlParser.InternalFunctionDefExpressionContext ctx) {
        ArrayList<StatementBlock> body;
        FunctionStatement functionStmt = new FunctionStatement();
        ArrayList<DataIdentifier> functionInputs = this.getFunctionParameters(ctx.inputParams);
        functionStmt.setInputParams(functionInputs);
        ArrayList<DataIdentifier> functionOutputs = this.getFunctionParameters(ctx.outputParams);
        functionStmt.setOutputParams(functionOutputs);
        functionStmt.setName(ctx.name.getText());
        if (ctx.body.size() > 0) {
            body = new ArrayList<StatementBlock>();
            for (PydmlParser.StatementContext stmtCtx : ctx.body) {
                body.add(PydmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
        } else {
            this.notifyErrorListeners("functions with no statements are not allowed", ctx.start);
            return;
        }
        functionStmt.setBody(body);
        functionStmt.mergeStatementBlocks();
        ctx.info.stmt = functionStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
        ctx.info.functionName = ctx.name.getText();
    }

    @Override
    public void exitExternalFunctionDefExpression(PydmlParser.ExternalFunctionDefExpressionContext ctx) {
        ExternalFunctionStatement functionStmt = new ExternalFunctionStatement();
        ArrayList<DataIdentifier> functionInputs = this.getFunctionParameters(ctx.inputParams);
        functionStmt.setInputParams(functionInputs);
        ArrayList<DataIdentifier> functionOutputs = this.getFunctionParameters(ctx.outputParams);
        functionStmt.setOutputParams(functionOutputs);
        functionStmt.setName(ctx.name.getText());
        HashMap<String, String> otherParams = new HashMap<String, String>();
        boolean atleastOneClassName = false;
        for (PydmlParser.StrictParameterizedKeyValueStringContext otherParamCtx : ctx.otherParams) {
            String paramName = otherParamCtx.paramName.getText();
            String val = "";
            String text = otherParamCtx.paramVal.getText();
            if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                if (text.length() > 2) {
                    val = text.substring(1, text.length() - 1);
                }
            } else {
                this.notifyErrorListeners("the value of user parameter for external function should be of type str", ctx.start);
                return;
            }
            otherParams.put(paramName, val);
            if (!paramName.equals("classname")) continue;
            atleastOneClassName = true;
        }
        functionStmt.setOtherParams(otherParams);
        if (!atleastOneClassName) {
            this.notifyErrorListeners("the parameter 'className' needs to be passed for defExternal", ctx.start);
            return;
        }
        ctx.info.stmt = functionStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
        ctx.info.functionName = ctx.name.getText();
    }

    @Override
    public void exitPathStatement(PydmlParser.PathStatementContext ctx) {
        PathStatement stmt = new PathStatement(ctx.pathValue.getText());
        String filePath = ctx.pathValue.getText();
        if (filePath.startsWith("\"") && filePath.endsWith("\"") || filePath.startsWith("'") && filePath.endsWith("'")) {
            filePath = filePath.substring(1, filePath.length() - 1);
        }
        this._workingDir = filePath;
        ctx.info.stmt = stmt;
    }

    @Override
    public void exitIfdefAssignmentStatement(PydmlParser.IfdefAssignmentStatementContext ctx) {
        if (!ctx.commandLineParam.getText().startsWith("$")) {
            this.notifyErrorListeners("the first argument of ifdef function should be a commandline argument parameter (which starts with $)", ctx.commandLineParam.start);
            return;
        }
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect lvalue in ifdef function ", ctx.start);
            return;
        }
        String targetListText = ctx.targetList.getText();
        if (targetListText.startsWith("$")) {
            this.notifyErrorListeners("lhs of ifdef function cannot be a commandline parameters. Use local variable instead", ctx.start);
            return;
        }
        DataIdentifier target = null;
        if (ctx.targetList.dataInfo.expr instanceof DataIdentifier) {
            target = (DataIdentifier)ctx.targetList.dataInfo.expr;
            Expression source = null;
            source = ctx.commandLineParam.dataInfo.expr != null ? ctx.commandLineParam.dataInfo.expr : ctx.source.info.expr;
            try {
                ctx.info.stmt = new AssignmentStatement(ctx, target, source, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("invalid assignment for ifdef function", ctx.targetList.start);
                return;
            }
        } else {
            this.notifyErrorListeners("incorrect lvalue in ifdef function ", ctx.targetList.start);
            return;
        }
    }

    @Override
    public void exitMatrixDataTypeCheck(PydmlParser.MatrixDataTypeCheckContext ctx) {
        this.checkValidDataType(ctx.ID().getText(), ctx.start);
        String datatype = ctx.ID().getText();
        if (datatype.equals("Matrix")) {
            this.notifyErrorListeners("incorrect datatype (Hint: use matrix instead of Matrix)", ctx.start);
        } else if (datatype.equals("Frame")) {
            this.notifyErrorListeners("incorrect datatype (Hint: use frame instead of Frame)", ctx.start);
        } else if (datatype.equals("Scalar")) {
            this.notifyErrorListeners("incorrect datatype (Hint: use scalar instead of Scalar)", ctx.start);
        } else if (datatype.equals("int") || datatype.equals("str") || datatype.equals("bool") || datatype.equals("float")) {
            this.notifyErrorListeners("expected datatype but found a valuetype (Hint: use matrix, frame or scalar instead of " + datatype + ")", ctx.start);
        }
    }

    @Override
    public void exitIgnoreNewLine(PydmlParser.IgnoreNewLineContext ctx) {
        try {
            ctx.info.stmt = new AssignmentStatement(ctx, null, null);
            ctx.info.stmt.setEmptyNewLineStatement(true);
        }
        catch (LanguageException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exitValueDataTypeCheck(PydmlParser.ValueDataTypeCheckContext ctx) {
        if (!(ctx.ID().getText().equals("int") || ctx.ID().getText().equals("str") || ctx.ID().getText().equals("bool") || ctx.ID().getText().equals("float"))) {
            if (ctx.ID().getText().equals("integer")) {
                this.notifyErrorListeners("incorrect valuetype (Hint: use int instead of integer)", ctx.start);
            } else if (ctx.ID().getText().equals("double")) {
                this.notifyErrorListeners("incorrect valuetype (Hint: use float instead of double)", ctx.start);
            } else if (ctx.ID().getText().equals("boolean")) {
                this.notifyErrorListeners("incorrect valuetype (Hint: use bool instead of boolean)", ctx.start);
            } else if (ctx.ID().getText().equals("string")) {
                this.notifyErrorListeners("incorrect valuetype (Hint: use str instead of string)", ctx.start);
            } else {
                this.notifyErrorListeners("incorrect valuetype (expected int, str, bool or float)", ctx.start);
            }
        }
    }

    @Override
    public void visitTerminal(TerminalNode node) {
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterModIntDivExpression(PydmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void enterExternalFunctionDefExpression(PydmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBooleanNotExpression(PydmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void enterPowerExpression(PydmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void enterInternalFunctionDefExpression(PydmlParser.InternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBuiltinFunctionExpression(PydmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void enterConstIntIdExpression(PydmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void enterAtomicExpression(PydmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void enterIfdefAssignmentStatement(PydmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void enterConstStringIdExpression(PydmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void enterConstTrueExpression(PydmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void enterValueDataTypeCheck(PydmlParser.ValueDataTypeCheckContext ctx) {
    }

    @Override
    public void enterParForStatement(PydmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void enterUnaryExpression(PydmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void enterImportStatement(PydmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void enterPathStatement(PydmlParser.PathStatementContext ctx) {
    }

    @Override
    public void enterWhileStatement(PydmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void enterCommandlineParamExpression(PydmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallAssignmentStatement(PydmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void enterAddSubExpression(PydmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void enterIfStatement(PydmlParser.IfStatementContext ctx) {
    }

    @Override
    public void enterElifBranch(PydmlParser.ElifBranchContext ctx) {
    }

    @Override
    public void enterIgnoreNewLine(PydmlParser.IgnoreNewLineContext ctx) {
    }

    @Override
    public void enterConstDoubleIdExpression(PydmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void enterMatrixDataTypeCheck(PydmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void enterCommandlinePositionExpression(PydmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void enterIterablePredicateColonExpression(PydmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void enterAssignmentStatement(PydmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void enterMl_type(PydmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void exitMl_type(PydmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void enterBooleanAndExpression(PydmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void enterForStatement(PydmlParser.ForStatementContext ctx) {
    }

    @Override
    public void enterRelationalExpression(PydmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void enterTypedArgNoAssign(PydmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void exitTypedArgNoAssign(PydmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void enterStrictParameterizedExpression(PydmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitStrictParameterizedExpression(PydmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterMultDivExpression(PydmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void enterConstFalseExpression(PydmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void enterStrictParameterizedKeyValueString(PydmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void exitStrictParameterizedKeyValueString(PydmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void enterProgramroot(PydmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void exitProgramroot(PydmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void enterDataIdExpression(PydmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void enterIndexedExpression(PydmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void enterParameterizedExpression(PydmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitParameterizedExpression(PydmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallMultiAssignmentStatement(PydmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void enterIterablePredicateSeqExpression(PydmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void enterSimpleDataIdentifierExpression(PydmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void enterBooleanOrExpression(PydmlParser.BooleanOrExpressionContext ctx) {
    }
}

