/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.JSONHelper;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;

public class DataExpression
extends DataIdentifier {
    public static final String RAND_ROWS = "rows";
    public static final String RAND_COLS = "cols";
    public static final String RAND_MIN = "min";
    public static final String RAND_MAX = "max";
    public static final String RAND_SPARSITY = "sparsity";
    public static final String RAND_SEED = "seed";
    public static final String RAND_PDF = "pdf";
    public static final String RAND_LAMBDA = "lambda";
    public static final String RAND_PDF_UNIFORM = "uniform";
    public static final String RAND_BY_ROW = "byrow";
    public static final String RAND_DIMNAMES = "dimnames";
    public static final String RAND_DATA = "data";
    public static final String IO_FILENAME = "iofilename";
    public static final String READROWPARAM = "rows";
    public static final String READCOLPARAM = "cols";
    public static final String READNUMNONZEROPARAM = "nnz";
    public static final String FORMAT_TYPE = "format";
    public static final String FORMAT_TYPE_VALUE_TEXT = "text";
    public static final String FORMAT_TYPE_VALUE_BINARY = "binary";
    public static final String FORMAT_TYPE_VALUE_CSV = "csv";
    public static final String FORMAT_TYPE_VALUE_MATRIXMARKET = "mm";
    public static final String ROWBLOCKCOUNTPARAM = "rows_in_block";
    public static final String COLUMNBLOCKCOUNTPARAM = "cols_in_block";
    public static final String DATATYPEPARAM = "data_type";
    public static final String VALUETYPEPARAM = "value_type";
    public static final String DESCRIPTIONPARAM = "description";
    public static final String AUTHORPARAM = "author";
    public static final String SCHEMAPARAM = "schema";
    public static final String CREATEDPARAM = "created";
    public static final String DELIM_DELIMITER = "sep";
    public static final String DELIM_HAS_HEADER_ROW = "header";
    public static final String DELIM_FILL = "fill";
    public static final String DELIM_FILL_VALUE = "default";
    public static final String DELIM_NA_STRINGS = "na.strings";
    public static final String DELIM_NA_STRING_SEP = "\u00b7";
    public static final String DELIM_SPARSE = "sparse";
    public static final String[] RAND_VALID_PARAM_NAMES = new String[]{"rows", "cols", "min", "max", "sparsity", "seed", "pdf", "lambda"};
    public static final String[] MATRIX_VALID_PARAM_NAMES = new String[]{"byrow", "dimnames", "data", "rows", "cols"};
    public static final String[] READ_VALID_MTD_PARAM_NAMES = new String[]{"iofilename", "rows", "cols", "nnz", "format", "rows_in_block", "cols_in_block", "data_type", "value_type", "schema", "description", "author", "created", "default", "sep", "fill", "header", "na.strings"};
    public static final String[] READ_VALID_PARAM_NAMES = new String[]{"iofilename", "rows", "cols", "format", "data_type", "value_type", "schema", "rows_in_block", "cols_in_block", "nnz", "default", "sep", "fill", "header", "na.strings"};
    public static final String DEFAULT_DELIM_DELIMITER = ",";
    public static final boolean DEFAULT_DELIM_HAS_HEADER_ROW = false;
    public static final boolean DEFAULT_DELIM_FILL = true;
    public static final double DEFAULT_DELIM_FILL_VALUE = 0.0;
    public static final boolean DEFAULT_DELIM_SPARSE = false;
    private Expression.DataOp _opcode;
    private HashMap<String, Expression> _varParams;
    private boolean _strInit = false;
    private boolean _checkMetadata = true;

    public DataExpression() {
    }

    public void setCheckMetadata(boolean checkMetadata) {
        this._checkMetadata = checkMetadata;
    }

    public static DataExpression getDataExpression(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> passedParamExprs, String filename, CustomErrorListener errorListener) throws LanguageException {
        ParseInfo pi = ParseInfo.ctxAndFilenameToParseInfo(ctx, filename);
        return DataExpression.getDataExpression(functionName, passedParamExprs, pi, errorListener);
    }

    public static DataExpression getDataExpression(String functionName, ArrayList<ParameterExpression> passedParamExprs, ParseInfo parseInfo, CustomErrorListener errorListener) throws LanguageException {
        if (functionName == null || passedParamExprs == null) {
            return null;
        }
        Expression.DataOp dop = null;
        DataExpression dataExpr = null;
        if (functionName.equals("read") || functionName.equals("readMM") || functionName.equals("read.csv")) {
            ParameterExpression pexpr;
            dop = Expression.DataOp.READ;
            dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
            if (functionName.equals("readMM")) {
                dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_MATRIXMARKET, parseInfo));
            }
            if (functionName.equals("read.csv")) {
                dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_CSV, parseInfo));
            }
            if (passedParamExprs.size() < 1) {
                errorListener.validationError(parseInfo, "read method must have at least filename parameter");
                return null;
            }
            ParameterExpression parameterExpression = pexpr = passedParamExprs.size() == 0 ? null : passedParamExprs.get(0);
            if (pexpr != null && (pexpr.getName() != null || pexpr.getName() != null && pexpr.getName().equalsIgnoreCase(IO_FILENAME))) {
                errorListener.validationError(parseInfo, "first parameter to read statement must be filename");
                return null;
            }
            if (pexpr != null) {
                dataExpr.addVarParam(IO_FILENAME, pexpr.getExpr());
            }
            for (int i = 1; i < passedParamExprs.size(); ++i) {
                String currName = passedParamExprs.get(i).getName();
                Expression currExpr = passedParamExprs.get(i).getExpr();
                if (dataExpr.getVarParam(currName) != null) {
                    errorListener.validationError(parseInfo, "attempted to add IOStatement parameter " + currName + " more than once");
                    return null;
                }
                boolean isValidName = false;
                for (String paramName : READ_VALID_PARAM_NAMES) {
                    if (!paramName.equals(currName)) continue;
                    isValidName = true;
                }
                if (!isValidName) {
                    errorListener.validationError(parseInfo, "attempted to add invalid read statement parameter " + currName);
                    return null;
                }
                dataExpr.addVarParam(currName, currExpr);
            }
        } else if (functionName.equalsIgnoreCase("rand")) {
            dop = Expression.DataOp.RAND;
            dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
            for (ParameterExpression currExpr : passedParamExprs) {
                String pname = currExpr.getName();
                Expression pexpr = currExpr.getExpr();
                if (pname == null) {
                    errorListener.validationError(parseInfo, "for rand statement, all arguments must be named parameters");
                    return null;
                }
                dataExpr.addRandExprParam(pname, pexpr);
            }
            dataExpr.setRandDefault();
        } else if (functionName.equals("matrix")) {
            dop = Expression.DataOp.MATRIX;
            dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
            int namedParamCount = 0;
            int unnamedParamCount = 0;
            for (ParameterExpression currExpr : passedParamExprs) {
                if (currExpr.getName() == null) {
                    ++unnamedParamCount;
                    continue;
                }
                ++namedParamCount;
            }
            if (passedParamExprs.size() < 3) {
                errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
                return null;
            }
            if (unnamedParamCount > 1) {
                if (namedParamCount > 0) {
                    errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters");
                    return null;
                }
                if (unnamedParamCount < 3) {
                    errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
                    return null;
                }
                dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                dataExpr.addMatrixExprParam("rows", passedParamExprs.get(1).getExpr());
                dataExpr.addMatrixExprParam("cols", passedParamExprs.get(2).getExpr());
                if (unnamedParamCount >= 4) {
                    dataExpr.addMatrixExprParam(RAND_BY_ROW, passedParamExprs.get(3).getExpr());
                }
                if (unnamedParamCount == 5) {
                    dataExpr.addMatrixExprParam(RAND_DIMNAMES, passedParamExprs.get(4).getExpr());
                }
                if (unnamedParamCount > 5) {
                    errorListener.validationError(parseInfo, "for matrix statement, at most 5 arguments supported: data, rows, cols, byrow, dimname");
                    return null;
                }
            } else {
                ParameterExpression firstParam = passedParamExprs.get(0);
                if (firstParam.getName() != null && !firstParam.getName().equals(RAND_DATA)) {
                    errorListener.validationError(parseInfo, "matrix method must have data parameter as first parameter or unnamed parameter");
                    return null;
                }
                dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                for (int i = 1; i < passedParamExprs.size(); ++i) {
                    if (passedParamExprs.get(i).getName() == null) {
                        errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters, only data parameter can be unnammed");
                        return null;
                    }
                    dataExpr.addMatrixExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
                }
            }
            dataExpr.setMatrixDefault();
        }
        if (dataExpr != null) {
            dataExpr.setParseInfo(parseInfo);
        }
        return dataExpr;
    }

    public void addRandExprParam(String paramName, Expression paramValue) throws LanguageException {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && paramValue == null) {
            return;
        }
        boolean found = false;
        if (paramName != null) {
            for (String name : RAND_VALID_PARAM_NAMES) {
                if (!name.equals(paramName)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for Rand statement are (capitalization-sensitive): " + "rows" + ", " + "cols" + ", " + RAND_MIN + ", " + RAND_MAX + ", " + RAND_SPARSITY + ", " + RAND_SEED + ", " + RAND_PDF + ", " + RAND_LAMBDA);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add Rand statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addMatrixExprParam(String paramName, Expression paramValue) throws LanguageException {
        boolean found = false;
        if (paramName != null) {
            for (String name : MATRIX_VALID_PARAM_NAMES) {
                if (!name.equals(paramName)) continue;
                found = true;
            }
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for  matrix statement are (capitalization-sensitive): " + RAND_DATA + ", " + "rows" + ", " + "cols" + ", " + RAND_BY_ROW);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add matrix statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public DataExpression(Expression.DataOp op, HashMap<String, Expression> varParams, ParseInfo parseInfo) {
        this._opcode = op;
        this._varParams = varParams;
        this.setParseInfo(parseInfo);
    }

    public DataExpression(ParserRuleContext ctx, Expression.DataOp op, HashMap<String, Expression> varParams, String filename) {
        this._opcode = op;
        this._varParams = varParams;
        this.setCtxValuesAndFilename(ctx, filename);
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        HashMap<String, Expression> newVarParams = new HashMap<String, Expression>();
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression newExpr = e.getValue().rewriteExpression(prefix);
            newVarParams.put(key, newExpr);
        }
        DataExpression retVal = new DataExpression(this._opcode, newVarParams, this);
        retVal._strInit = this._strInit;
        return retVal;
    }

    public void setMatrixDefault() {
        if (this.getVarParam(RAND_BY_ROW) == null) {
            this.addVarParam(RAND_BY_ROW, new BooleanIdentifier(true, this));
        }
    }

    public void setRandDefault() {
        ConstIdentifier id;
        if (this.getVarParam("rows") == null) {
            id = new IntIdentifier(1L, (ParseInfo)this);
            this.addVarParam("rows", id);
        }
        if (this.getVarParam("cols") == null) {
            id = new IntIdentifier(1L, (ParseInfo)this);
            this.addVarParam("cols", id);
        }
        if (this.getVarParam(RAND_MIN) == null) {
            id = new DoubleIdentifier(0.0, (ParseInfo)this);
            this.addVarParam(RAND_MIN, id);
        }
        if (this.getVarParam(RAND_MAX) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_MAX, id);
        }
        if (this.getVarParam(RAND_SPARSITY) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_SPARSITY, id);
        }
        if (this.getVarParam(RAND_SEED) == null) {
            id = new IntIdentifier(-1L, (ParseInfo)this);
            this.addVarParam(RAND_SEED, id);
        }
        if (this.getVarParam(RAND_PDF) == null) {
            id = new StringIdentifier(RAND_PDF_UNIFORM, this);
            this.addVarParam(RAND_PDF, id);
        }
        if (this.getVarParam(RAND_LAMBDA) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_LAMBDA, id);
        }
    }

    public void setOpCode(Expression.DataOp op) {
        this._opcode = op;
    }

    public Expression.DataOp getOpCode() {
        return this._opcode;
    }

    public HashMap<String, Expression> getVarParams() {
        return this._varParams;
    }

    public void setVarParams(HashMap<String, Expression> varParams) {
        this._varParams = varParams;
    }

    public Expression getVarParam(String name) {
        return this._varParams.get(name);
    }

    public void addVarParam(String name, Expression value) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && value == null) {
            return;
        }
        this._varParams.put(name, value);
        this.setFilename(value.getFilename());
        if (this.getBeginLine() == 0) {
            this.setBeginLine(value.getBeginLine());
        }
        if (this.getBeginColumn() == 0) {
            this.setBeginColumn(value.getBeginColumn());
        }
        if (this.getEndLine() == 0) {
            this.setEndLine(value.getEndLine());
        }
        if (this.getEndColumn() == 0) {
            this.setEndColumn(value.getEndColumn());
        }
        if (this.getText() == null) {
            this.setText(value.getText());
        }
    }

    public void removeVarParam(String name) {
        this._varParams.remove(name);
    }

    private String getInputFileName(HashMap<String, ConstIdentifier> currConstVars, boolean conditional) throws LanguageException {
        String filename = null;
        Expression fileNameExpr = this.getVarParam(IO_FILENAME);
        if (fileNameExpr instanceof ConstIdentifier) {
            return fileNameExpr.toString();
        }
        if (fileNameExpr instanceof BinaryExpression) {
            BinaryExpression expr = (BinaryExpression)fileNameExpr;
            Expression.BinaryOp op = expr.getOpCode();
            switch (op) {
                case PLUS: {
                    filename = "";
                    filename = this.fileNameCat(expr, currConstVars, filename, conditional);
                    StringIdentifier fileString = new StringIdentifier(filename, this);
                    this.removeVarParam(IO_FILENAME);
                    this.addVarParam(IO_FILENAME, fileString);
                    break;
                }
                default: {
                    this.raiseValidateError("for read method, parameter iofilename can only be const string concatenations. ", conditional);
                    break;
                }
            }
        } else {
            this.raiseValidateError("for read method, parameter iofilename can only be a const string or const string concatenations. ", conditional);
        }
        return filename;
    }

    public static String getMTDFileName(String inputFileName) throws LanguageException {
        return inputFileName + ".mtd";
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) throws LanguageException {
        for (Map.Entry<String, Expression> e : this.getVarParams().entrySet()) {
            String s = e.getKey();
            Expression inputParamExpr = e.getValue();
            if (inputParamExpr instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false, "Invalid Parameters");
            }
            inputParamExpr.validateExpression(ids, currConstVars, conditional);
            if (this.getVarParam(s).getOutput().getDataType() == Expression.DataType.SCALAR || s.equals(RAND_DATA)) continue;
            this.raiseValidateError("Non-scalar data types are not supported for data expression.", conditional, "Invalid Parameters");
        }
        this.performConstantPropagationRand(currConstVars);
        this.performConstantPropagationReadWrite(currConstVars);
        Expression dataParam1 = this.getVarParam(RAND_DATA);
        if (dataParam1 == null && this.getOpCode().equals((Object)Expression.DataOp.MATRIX)) {
            this.raiseValidateError("for matrix, must defined data parameter", conditional, "Invalid Parameters");
        }
        if (dataParam1 != null && dataParam1.getOutput().getDataType() == Expression.DataType.SCALAR) {
            this.setOpCode(Expression.DataOp.RAND);
        }
        switch (this.getOpCode()) {
            case READ: {
                String valueTypeString;
                boolean isDelimitedFormat;
                boolean isMatrixMarketFormat;
                String formatTypeString;
                boolean shouldReadMTD;
                String dataTypeString;
                if (this.getVarParam(DATATYPEPARAM) != null && !(this.getVarParam(DATATYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read statement, parameter data_type can only be a string. Valid values are: matrix, scalar", conditional);
                }
                String string = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString != null && dataTypeString.equalsIgnoreCase("scalar") && (this.getVarParam("rows") != null || this.getVarParam("cols") != null || this.getVarParam(ROWBLOCKCOUNTPARAM) != null || this.getVarParam(COLUMNBLOCKCOUNTPARAM) != null || this.getVarParam(FORMAT_TYPE) != null || this.getVarParam(DELIM_DELIMITER) != null || this.getVarParam(DELIM_HAS_HEADER_ROW) != null || this.getVarParam(DELIM_FILL) != null || this.getVarParam(DELIM_FILL_VALUE) != null || this.getVarParam(DELIM_NA_STRINGS) != null)) {
                    this.raiseValidateError("Invalid parameters in read statement of a scalar: " + this.toString() + ". Only " + VALUETYPEPARAM + " is allowed.", conditional, "Invalid Parameters");
                }
                JSONObject configObject = null;
                String inputFileName = this.getInputFileName(currConstVars, conditional);
                String mtdFileName = DataExpression.getMTDFileName(inputFileName);
                boolean bl = shouldReadMTD = this._checkMetadata && (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA) || MapReduceTool.existsFileOnHDFS(mtdFileName));
                if (shouldReadMTD && !MapReduceTool.existsFileOnHDFS(inputFileName)) {
                    String fsext = InfrastructureAnalyzer.isLocalMode() ? "FS (local mode)" : "HDFS";
                    this.raiseValidateError("Read input file does not exist on " + fsext + ": " + inputFileName, conditional);
                }
                boolean inferredFormatType = false;
                String string2 = formatTypeString = this.getVarParam(FORMAT_TYPE) == null ? null : this.getVarParam(FORMAT_TYPE).toString();
                if (formatTypeString == null && shouldReadMTD && (isMatrixMarketFormat = this.checkHasMatrixMarketFormat(inputFileName, mtdFileName, conditional))) {
                    formatTypeString = FORMAT_TYPE_VALUE_MATRIXMARKET;
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_MATRIXMARKET, this));
                    inferredFormatType = true;
                    shouldReadMTD = false;
                }
                if (formatTypeString == null && shouldReadMTD && (isDelimitedFormat = this.checkHasDelimitedFormat(inputFileName, conditional))) {
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_CSV, this));
                    formatTypeString = FORMAT_TYPE_VALUE_CSV;
                    inferredFormatType = true;
                }
                if (formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET)) {
                    for (String key : this._varParams.keySet()) {
                        if (key.equals(IO_FILENAME) || key.equals(FORMAT_TYPE)) continue;
                        this.raiseValidateError("Invalid parameters in readMM statement: " + this.toString() + ". Only " + IO_FILENAME + " is allowed.", conditional, "Invalid Parameters");
                    }
                    shouldReadMTD = false;
                    String[] headerLines = this.readMatrixMarketFile(inputFileName, conditional);
                    String legalHeaderMM = "%%MatrixMarket matrix coordinate real general";
                    if (headerLines != null && headerLines.length >= 2) {
                        String secondLine;
                        String[] sizeInfo;
                        String firstLine = headerLines[0].trim();
                        if (!firstLine.equals(legalHeaderMM)) {
                            this.raiseValidateError("Unsupported format in MatrixMarket file: " + headerLines[0] + ". Only supported format in MatrixMarket file has header line " + (String)legalHeaderMM, conditional, "Invalid Parameters");
                        }
                        if ((sizeInfo = (secondLine = headerLines[1]).trim().split("\\s+")).length != 3) {
                            this.raiseValidateError("Unsupported size line in MatrixMarket file: " + headerLines[1] + ". Only supported format in MatrixMarket file has size line: <NUM ROWS> <NUM COLS> <NUM NON-ZEROS>, where each value is an integer.", conditional);
                        }
                        long rowsCount = -1L;
                        long colsCount = -1L;
                        long nnzCount = -1L;
                        try {
                            rowsCount = Long.parseLong(sizeInfo[0]);
                            if (rowsCount < 1L) {
                                throw new Exception("invalid rows count");
                            }
                            this.addVarParam("rows", new IntIdentifier(rowsCount, (ParseInfo)this));
                        }
                        catch (Exception e) {
                            this.raiseValidateError("In MatrixMarket file " + this.getVarParam(IO_FILENAME) + " invalid row count " + sizeInfo[0] + " (must be long value >= 1). Sizing info line from file: " + headerLines[1], conditional, "Invalid Parameters");
                        }
                        try {
                            colsCount = Long.parseLong(sizeInfo[1]);
                            if (colsCount < 1L) {
                                throw new Exception("invalid cols count");
                            }
                            this.addVarParam("cols", new IntIdentifier(colsCount, (ParseInfo)this));
                        }
                        catch (Exception e) {
                            this.raiseValidateError("In MatrixMarket file " + this.getVarParam(IO_FILENAME) + " invalid column count " + sizeInfo[1] + " (must be long value >= 1). Sizing info line from file: " + headerLines[1], conditional, "Invalid Parameters");
                        }
                        try {
                            nnzCount = Long.parseLong(sizeInfo[2]);
                            if (nnzCount < 1L) {
                                throw new Exception("invalid nnz count");
                            }
                            this.addVarParam(READNUMNONZEROPARAM, new IntIdentifier(nnzCount, (ParseInfo)this));
                        }
                        catch (Exception e) {
                            this.raiseValidateError("In MatrixMarket file " + this.getVarParam(IO_FILENAME) + " invalid number non-zeros " + sizeInfo[2] + " (must be long value >= 1). Sizing info line from file: " + headerLines[1], conditional, "Invalid Parameters");
                        }
                    }
                }
                configObject = null;
                if (shouldReadMTD) {
                    configObject = this.readMetadataFile(mtdFileName, conditional);
                    if (configObject != null) {
                        this.parseMetaDataFileParameters(mtdFileName, configObject, conditional);
                        inferredFormatType = true;
                    } else {
                        LOG.warn((Object)("Metadata file: " + new Path(mtdFileName) + " not provided"));
                    }
                }
                boolean isCSV = false;
                boolean bl2 = isCSV = formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV);
                if (isCSV) {
                    shouldReadMTD = true;
                    if (!inferredFormatType) {
                        for (String key : this._varParams.keySet()) {
                            if (key.equals(IO_FILENAME) || key.equals(FORMAT_TYPE) || key.equals(DELIM_HAS_HEADER_ROW) || key.equals(DELIM_DELIMITER) || key.equals(DELIM_FILL) || key.equals(DELIM_FILL_VALUE) || key.equals("rows") || key.equals("cols") || key.equals(READNUMNONZEROPARAM) || key.equals(DATATYPEPARAM) || key.equals(VALUETYPEPARAM) || key.equals(SCHEMAPARAM)) continue;
                            String msg = "Only parameters allowed are: iofilename,schema,header,sep,fill,default,rows,cols";
                            this.raiseValidateError("Invalid parameter " + key + " in read statement: " + this.toString() + ". " + msg, conditional, "Invalid Parameters");
                        }
                    }
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    } else if (this.getVarParam(DELIM_DELIMITER) instanceof ConstIdentifier && !(this.getVarParam(DELIM_DELIMITER) instanceof StringIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_DELIMITER) + "' must be a string value ", conditional);
                    }
                    if (this.getVarParam(DELIM_FILL_VALUE) == null) {
                        this.addVarParam(DELIM_FILL_VALUE, new DoubleIdentifier(0.0, (ParseInfo)this));
                    } else if (this.getVarParam(DELIM_FILL_VALUE) instanceof ConstIdentifier && !(this.getVarParam(DELIM_FILL_VALUE) instanceof IntIdentifier) && !(this.getVarParam(DELIM_FILL_VALUE) instanceof DoubleIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_FILL_VALUE) + "' must be a numeric value ", conditional);
                    }
                    if (this.getVarParam(DELIM_HAS_HEADER_ROW) == null) {
                        this.addVarParam(DELIM_HAS_HEADER_ROW, new BooleanIdentifier(false, this));
                    } else if (this.getVarParam(DELIM_HAS_HEADER_ROW) instanceof ConstIdentifier && !(this.getVarParam(DELIM_HAS_HEADER_ROW) instanceof BooleanIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_HAS_HEADER_ROW) + "' must be a boolean value ", conditional);
                    }
                    if (this.getVarParam(DELIM_FILL) == null) {
                        this.addVarParam(DELIM_FILL, new BooleanIdentifier(true, this));
                    } else if (this.getVarParam(DELIM_FILL) instanceof ConstIdentifier && !(this.getVarParam(DELIM_FILL) instanceof BooleanIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_FILL) + "' must be a boolean value ", conditional);
                    }
                }
                String string3 = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix") || dataTypeString.equalsIgnoreCase("frame")) {
                    String fmt;
                    boolean isMatrix = false;
                    if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix")) {
                        isMatrix = true;
                    }
                    this.getOutput().setDataType(isMatrix ? Expression.DataType.MATRIX : Expression.DataType.FRAME);
                    Expression ennz = this.getVarParam(READNUMNONZEROPARAM);
                    long nnz = -1L;
                    if (ennz != null) {
                        nnz = Long.valueOf(ennz.toString());
                        this.getOutput().setNnz(nnz);
                    }
                    this.getOutput().setDimensions(-1L, -1L);
                    if (!isCSV && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS) && (this.getVarParam("rows") == null || this.getVarParam("cols") == null)) {
                        this.raiseValidateError("Missing or incomplete dimension information in read statement: " + mtdFileName, conditional, "Invalid Parameters");
                    }
                    if (this.getVarParam("rows") instanceof ConstIdentifier && this.getVarParam("cols") instanceof ConstIdentifier) {
                        Long dim2;
                        Long dim1 = this.getVarParam("rows") == null ? null : Long.valueOf(this.getVarParam("rows").toString());
                        Long l = dim2 = this.getVarParam("cols") == null ? null : Long.valueOf(this.getVarParam("cols").toString());
                        if (!isCSV && (dim1 <= 0L || dim2 <= 0L) && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS)) {
                            this.raiseValidateError("Invalid dimension information in read statement", conditional, "Invalid Parameters");
                        }
                        if (dim1 != null && dim2 != null) {
                            this.getOutput().setDimensions(dim1, dim2);
                        } else if (!(isCSV || dim1 == null && dim2 == null)) {
                            this.raiseValidateError("Partial dimension information in read statement", conditional, "Invalid Parameters");
                        }
                    }
                    this.getOutput().setBlockDimensions(-1L, -1L);
                    int format = 1;
                    String string4 = fmt = this.getVarParam(FORMAT_TYPE) == null ? null : this.getVarParam(FORMAT_TYPE).toString();
                    if (fmt == null || fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_TEXT)) {
                        this.getOutput().setFormatType(Expression.FormatType.TEXT);
                        format = 1;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_BINARY)) {
                        this.getOutput().setFormatType(Expression.FormatType.BINARY);
                        format = 2;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
                        this.getOutput().setFormatType(Expression.FormatType.CSV);
                        format = 1;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET)) {
                        this.getOutput().setFormatType(Expression.FormatType.MM);
                        format = 1;
                    } else {
                        this.raiseValidateError("Invalid format '" + fmt + "' in statement: " + this.toString(), conditional);
                    }
                    if (this.getVarParam(ROWBLOCKCOUNTPARAM) instanceof ConstIdentifier && this.getVarParam(COLUMNBLOCKCOUNTPARAM) instanceof ConstIdentifier) {
                        Long columnBlockCount;
                        Long rowBlockCount = this.getVarParam(ROWBLOCKCOUNTPARAM) == null ? null : Long.valueOf(this.getVarParam(ROWBLOCKCOUNTPARAM).toString());
                        Long l = columnBlockCount = this.getVarParam(COLUMNBLOCKCOUNTPARAM) == null ? null : Long.valueOf(this.getVarParam(COLUMNBLOCKCOUNTPARAM).toString());
                        if (rowBlockCount != null && columnBlockCount != null) {
                            this.getOutput().setBlockDimensions(rowBlockCount, columnBlockCount);
                        } else if (rowBlockCount != null || columnBlockCount != null) {
                            this.raiseValidateError("Partial block dimension information in read statement", conditional, "Invalid Parameters");
                        } else {
                            this.getOutput().setBlockDimensions(-1L, -1L);
                        }
                    }
                    if (!(format != 1 && isMatrix || this.getOutput().getRowsInBlock() == -1L && this.getOutput().getColumnsInBlock() == -1L)) {
                        this.raiseValidateError("Invalid block dimensions (" + this.getOutput().getRowsInBlock() + DEFAULT_DELIM_DELIMITER + this.getOutput().getColumnsInBlock() + ") when format=" + this.getVarParam(FORMAT_TYPE) + " in \"" + this.toString() + "\".", conditional);
                    }
                } else if (dataTypeString.equalsIgnoreCase("scalar")) {
                    this.getOutput().setDataType(Expression.DataType.SCALAR);
                    this.getOutput().setNnz(-1L);
                } else {
                    this.raiseValidateError("Unknown Data Type " + dataTypeString + ". Valid  values: " + "scalar" + ", " + "matrix", conditional, "Invalid Parameters");
                }
                if (this.getVarParam(VALUETYPEPARAM) != null && !(this.getVarParam(VALUETYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read method, parameter value_type can only be a string. Valid values are: double, int, boolean, string", conditional);
                }
                String string5 = valueTypeString = this.getVarParam(VALUETYPEPARAM) == null ? null : this.getVarParam(VALUETYPEPARAM).toString();
                if (valueTypeString != null) {
                    if (valueTypeString.equalsIgnoreCase("double")) {
                        this.getOutput().setValueType(Expression.ValueType.DOUBLE);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("string")) {
                        this.getOutput().setValueType(Expression.ValueType.STRING);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("int")) {
                        this.getOutput().setValueType(Expression.ValueType.INT);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("boolean")) {
                        this.getOutput().setValueType(Expression.ValueType.BOOLEAN);
                        break;
                    }
                    this.raiseValidateError("Unknown Value Type " + valueTypeString + ". Valid values are: " + "double" + ", " + "int" + ", " + "boolean" + ", " + "string", conditional);
                    break;
                }
                this.getOutput().setValueType(Expression.ValueType.DOUBLE);
                break;
            }
            case WRITE: {
                if (this.getVarParam(FORMAT_TYPE) == null || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    }
                    if (this.getVarParam(DELIM_HAS_HEADER_ROW) == null) {
                        this.addVarParam(DELIM_HAS_HEADER_ROW, new BooleanIdentifier(false, this));
                    }
                    if (this.getVarParam(DELIM_SPARSE) == null) {
                        this.addVarParam(DELIM_SPARSE, new BooleanIdentifier(false, this));
                    }
                }
                if (this.getVarParam(FORMAT_TYPE) == null || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_TEXT)) {
                    this.getOutput().setBlockDimensions(-1L, -1L);
                    break;
                }
                if (this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_BINARY)) {
                    this.getOutput().setBlockDimensions(ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                    break;
                }
                if (this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET) || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
                    this.getOutput().setBlockDimensions(-1L, -1L);
                    break;
                }
                this.raiseValidateError("Invalid format " + this.getVarParam(FORMAT_TYPE) + " in statement: " + this.toString(), conditional);
                break;
            }
            case RAND: {
                Expression lambda;
                Expression dataParam = this.getVarParam(RAND_DATA);
                if (dataParam != null) {
                    DoubleIdentifier minExpr;
                    if (dataParam instanceof DataIdentifier) {
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    } else if (dataParam instanceof IntIdentifier) {
                        long roundedValue = ((IntIdentifier)dataParam).getValue();
                        minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                        this.addVarParam(RAND_MIN, minExpr);
                        this.addVarParam(RAND_MAX, minExpr);
                    } else if (dataParam instanceof DoubleIdentifier) {
                        double roundedValue = ((DoubleIdentifier)dataParam).getValue();
                        minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                        this.addVarParam(RAND_MIN, minExpr);
                        this.addVarParam(RAND_MAX, minExpr);
                    } else if (dataParam instanceof StringIdentifier) {
                        String data = ((StringIdentifier)dataParam).getValue();
                        StringIdentifier minExpr2 = new StringIdentifier(data, this);
                        this.addVarParam(RAND_MIN, minExpr2);
                        this.addVarParam(RAND_MAX, minExpr2);
                        this._strInit = true;
                    } else {
                        dataParam.validateExpression(ids, currConstVars, conditional);
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    }
                    this.removeVarParam(RAND_DATA);
                    this.removeVarParam(RAND_BY_ROW);
                    this.setRandDefault();
                }
                for (String key : this._varParams.keySet()) {
                    boolean found = false;
                    for (String name : RAND_VALID_PARAM_NAMES) {
                        found |= name.equals(key);
                    }
                    if (found) continue;
                    this.raiseValidateError("unexpected parameter \"" + key + "\". Legal parameters for Rand statement are (capitalization-sensitive): " + "rows" + ", " + "cols" + ", " + RAND_MIN + ", " + RAND_MAX + ", " + RAND_SPARSITY + ", " + RAND_SEED + ", " + RAND_PDF + ", " + RAND_LAMBDA, conditional);
                }
                if (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement cols has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_SEED) instanceof StringIdentifier || this.getVarParam(RAND_SEED) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement seed has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_MAX) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MAX) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement max has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_MIN) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MIN) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement min has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_PDF) instanceof StringIdentifier)) {
                    this.raiseValidateError("for Rand statement pdf has incorrect value type", conditional);
                }
                if (!((lambda = this.getVarParam(RAND_LAMBDA)) instanceof DataIdentifier) && !(lambda instanceof ConstIdentifier) || lambda.getOutput().getValueType() != Expression.ValueType.DOUBLE && lambda.getOutput().getValueType() != Expression.ValueType.INT) {
                    this.raiseValidateError("for Rand statement lambda has incorrect data type", conditional);
                }
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                if (rowsExpr instanceof IntIdentifier) {
                    if (((IntIdentifier)rowsExpr).getValue() >= 1L) {
                        rowsLong = ((IntIdentifier)rowsExpr).getValue();
                    } else {
                        this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                    }
                } else if (rowsExpr instanceof DoubleIdentifier) {
                    if (((DoubleIdentifier)rowsExpr).getValue() >= 1.0) {
                        rowsLong = UtilFunctions.toLong(Math.floor(((DoubleIdentifier)rowsExpr).getValue()));
                    } else {
                        this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                    }
                } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)rowsExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        long roundedValue;
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            if (((IntIdentifier)constValue).getValue() < 1L) {
                                this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                            roundedValue = ((IntIdentifier)constValue).getValue();
                            rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam("rows", rowsExpr);
                            rowsLong = roundedValue;
                        } else if (constValue instanceof DoubleIdentifier) {
                            if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                            roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                            rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam("rows", rowsExpr);
                            rowsLong = roundedValue;
                        } else {
                            this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    rowsExpr.validateExpression(ids, currConstVars, conditional);
                }
                Expression colsExpr = this.getVarParam("cols");
                if (colsExpr instanceof IntIdentifier) {
                    if (((IntIdentifier)colsExpr).getValue() >= 1L) {
                        colsLong = ((IntIdentifier)colsExpr).getValue();
                    } else {
                        this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                    }
                } else if (colsExpr instanceof DoubleIdentifier) {
                    if (((DoubleIdentifier)colsExpr).getValue() >= 1.0) {
                        colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                    } else {
                        this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                    }
                } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)colsExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        long roundedValue;
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            if (((IntIdentifier)constValue).getValue() < 1L) {
                                this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                            roundedValue = ((IntIdentifier)constValue).getValue();
                            colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam("cols", colsExpr);
                            colsLong = roundedValue;
                        } else if (constValue instanceof DoubleIdentifier) {
                            if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                            roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                            colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam("cols", colsExpr);
                            colsLong = roundedValue;
                        } else {
                            this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    colsExpr.validateExpression(ids, currConstVars, conditional);
                }
                Expression minExpr = this.getVarParam(RAND_MIN);
                if (minExpr instanceof DataIdentifier && !(minExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)minExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign min a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        minExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    minExpr.validateExpression(ids, currConstVars, conditional);
                }
                Expression maxExpr = this.getVarParam(RAND_MAX);
                if (maxExpr instanceof DataIdentifier && !(maxExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)maxExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign max a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        maxExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    maxExpr.validateExpression(ids, currConstVars, conditional);
                }
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Expression.DataType.MATRIX);
                this.getOutput().setValueType(Expression.ValueType.DOUBLE);
                this.getOutput().setDimensions(rowsLong, colsLong);
                if (this.getOutput() instanceof IndexedIdentifier) {
                    DataIdentifier targetAsSeen = ids.get(((DataIdentifier)this.getOutput()).getName());
                    if (targetAsSeen == null) {
                        this.raiseValidateError("cannot assign value to indexed identifier " + ((DataIdentifier)this.getOutput()).getName() + " without first initializing " + ((DataIdentifier)this.getOutput()).getName(), conditional);
                    }
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(targetAsSeen.getDim1(), targetAsSeen.getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for Rand Statement may have incorrect size information"));
                break;
            }
            case MATRIX: {
                Expression colsExpr;
                ConstIdentifier constValue;
                String identifierName;
                this.setMatrixDefault();
                for (String key : this._varParams.keySet()) {
                    boolean found = false;
                    for (String name : MATRIX_VALID_PARAM_NAMES) {
                        found |= name.equals(key);
                    }
                    if (found) continue;
                    this.raiseValidateError("unexpected parameter \"" + key + "\". Legal parameters for matrix statement are (case-sensitive): " + RAND_DATA + ", " + "rows" + ", " + "cols" + ", " + RAND_BY_ROW, conditional);
                }
                if (this.getVarParam(RAND_DATA) != null && this.getVarParam(RAND_DATA) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for matrix statement data has incorrect value type", conditional);
                }
                if (this.getVarParam("rows") != null && (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") != null && (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement cols has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_BY_ROW) instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement byrow has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                if (rowsExpr != null) {
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() >= 1L) {
                            rowsLong = ((IntIdentifier)rowsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() >= 1.0) {
                            rowsLong = Double.valueOf(Math.floor(((DoubleIdentifier)rowsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                long roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                long roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((colsExpr = this.getVarParam("cols")) != null) {
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() >= 1L) {
                            colsLong = ((IntIdentifier)colsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() >= 1.0) {
                            colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                long roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                long roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Expression.DataType.MATRIX);
                this.getOutput().setValueType(Expression.ValueType.DOUBLE);
                this.getOutput().setDimensions(rowsLong, colsLong);
                if (this.getOutput() instanceof IndexedIdentifier) {
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for matrix Statement may have incorrect size information"));
                break;
            }
            default: {
                this.raiseValidateError("Unsupported Data expression" + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
            }
        }
    }

    private void performConstantPropagationRand(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{RAND_DATA, RAND_SPARSITY, RAND_MIN, RAND_MAX};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagationReadWrite(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{FORMAT_TYPE, IO_FILENAME, "rows", "cols", READNUMNONZEROPARAM};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagation(HashMap<String, ConstIdentifier> currConstVars, String[] paramNames) {
        for (String paramName : paramNames) {
            Expression paramExp = this.getVarParam(paramName);
            if (paramExp == null || !(paramExp instanceof DataIdentifier) || paramExp instanceof IndexedIdentifier || !currConstVars.containsKey(((DataIdentifier)paramExp).getName())) continue;
            this.addVarParam(paramName, currConstVars.get(((DataIdentifier)paramExp).getName()));
        }
    }

    private String fileNameCat(BinaryExpression expr, HashMap<String, ConstIdentifier> currConstVars, String filename, boolean conditional) throws LanguageException {
        String name;
        if (expr.getLeft() instanceof BinaryExpression && ((BinaryExpression)expr.getLeft()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = this.fileNameCat((BinaryExpression)expr.getLeft(), currConstVars, filename, conditional) + filename;
        } else if (expr.getLeft() instanceof ConstIdentifier) {
            filename = ((ConstIdentifier)expr.getLeft()).toString() + filename;
        } else if (expr.getLeft() instanceof DataIdentifier && ((DataIdentifier)expr.getLeft()).getDataType() == Expression.DataType.SCALAR) {
            name = ((DataIdentifier)expr.getLeft()).getName();
            filename = ((StringIdentifier)currConstVars.get(name)).getValue() + filename;
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        if (expr.getRight() instanceof BinaryExpression && ((BinaryExpression)expr.getRight()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = filename + this.fileNameCat((BinaryExpression)expr.getRight(), currConstVars, filename, conditional);
        } else if (expr.getRight() instanceof ConstIdentifier) {
            filename = filename + ((ConstIdentifier)expr.getRight()).toString();
        } else if (expr.getRight() instanceof DataIdentifier && ((DataIdentifier)expr.getRight()).getDataType() == Expression.DataType.SCALAR && ((DataIdentifier)expr.getRight()).getValueType() == Expression.ValueType.STRING) {
            name = ((DataIdentifier)expr.getRight()).getName();
            filename = filename + ((StringIdentifier)currConstVars.get(name)).getValue();
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        return filename;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._opcode.toString());
        sb.append("(");
        boolean first = true;
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression expr = e.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key);
            sb.append("=");
            if (expr instanceof StringIdentifier) {
                sb.append("\"");
                sb.append(expr);
                sb.append("\"");
                continue;
            }
            sb.append(expr);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesUpdated());
        }
        result.addVariable(((DataIdentifier)this.getOutput()).getName(), (DataIdentifier)this.getOutput());
        return result;
    }

    private void parseMetaDataFileParameters(String mtdFileName, JSONObject configObject, boolean conditional) throws LanguageException {
        Iterator iterator = configObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry e = obj = iterator.next();
            Object key = e.getKey();
            Object val = e.getValue();
            boolean isValidName = false;
            for (String paramName : READ_VALID_MTD_PARAM_NAMES) {
                if (!paramName.equals(key)) continue;
                isValidName = true;
            }
            if (!isValidName) {
                this.raiseValidateError("MTD file " + mtdFileName + " contains invalid parameter name: " + key, false);
            }
            if (this.getVarParam(key.toString()) != null && this.getVarParam(key.toString()) instanceof ConstIdentifier && !this.getVarParam(key.toString()).toString().equalsIgnoreCase(val.toString())) {
                this.raiseValidateError("Parameter '" + key.toString() + "' has conflicting values in metadata and read statement. MTD file value: '" + val.toString() + "'. Read statement value: '" + this.getVarParam(key.toString()) + "'.", conditional);
                continue;
            }
            if (this.getVarParam(key.toString()) != null || key.toString().equalsIgnoreCase(DESCRIPTIONPARAM) || key.toString().equalsIgnoreCase(AUTHORPARAM) || key.toString().equalsIgnoreCase(CREATEDPARAM)) continue;
            StringIdentifier strId = new StringIdentifier(val.toString(), this);
            if (key.toString().equalsIgnoreCase(DELIM_HAS_HEADER_ROW) || key.toString().equalsIgnoreCase(DELIM_FILL) || key.toString().equalsIgnoreCase(DELIM_SPARSE)) {
                BooleanIdentifier boolId = null;
                if (strId.toString().equalsIgnoreCase("true")) {
                    boolId = new BooleanIdentifier(true, this);
                } else if (strId.toString().equalsIgnoreCase("false")) {
                    boolId = new BooleanIdentifier(false, this);
                } else {
                    this.raiseValidateError("Invalid value provided for 'header' in metadata file '" + mtdFileName + "'. Must be either TRUE or FALSE.", conditional);
                }
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), boolId);
                continue;
            }
            if (key.toString().equalsIgnoreCase(DELIM_FILL_VALUE)) {
                DoubleIdentifier doubleId = new DoubleIdentifier(Double.parseDouble(strId.toString()), (ParseInfo)this);
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), doubleId);
                continue;
            }
            if (key.toString().equalsIgnoreCase(DELIM_NA_STRINGS)) {
                String naStrings = null;
                if (val instanceof String) {
                    naStrings = val.toString();
                } else {
                    StringBuilder sb = new StringBuilder();
                    JSONArray valarr = (JSONArray)val;
                    for (int naid = 0; naid < valarr.size(); ++naid) {
                        sb.append((String)valarr.get(naid));
                        if (naid >= valarr.size() - 1) continue;
                        sb.append(DELIM_NA_STRING_SEP);
                    }
                    naStrings = sb.toString();
                }
                StringIdentifier sid = new StringIdentifier(naStrings, this);
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), sid);
                continue;
            }
            this.addVarParam(key.toString(), strId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject readMetadataFile(String filename, boolean conditional) throws LanguageException {
        JSONObject retVal = null;
        boolean exists = MapReduceTool.existsFileOnHDFS(filename);
        boolean isDir = MapReduceTool.isDirectory(filename);
        if (exists && isDir) {
            retVal = new JSONObject();
            for (FileStatus stat : MapReduceTool.getDirectoryListing(filename)) {
                Path childPath = stat.getPath();
                if (!childPath.getName().startsWith("part")) continue;
                BufferedReader br = null;
                try {
                    FileSystem fs = IOUtilFunctions.getFileSystem(childPath);
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(childPath)));
                    JSONObject childObj = JSONHelper.parse(br);
                    Iterator iterator = childObj.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry e = obj = iterator.next();
                        Object key = e.getKey();
                        Object val = e.getValue();
                        retVal.put(key, val);
                    }
                }
                catch (Exception e) {
                    try {
                        this.raiseValidateError("for MTD file in directory, error parting part of MTD file with path " + childPath.toString() + ": " + e.getMessage(), conditional);
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(br);
                        throw throwable;
                    }
                    IOUtilFunctions.closeSilently(br);
                    continue;
                }
                IOUtilFunctions.closeSilently(br);
            }
        } else if (exists) {
            BufferedReader br = null;
            try {
                Path path = new Path(filename);
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
                retVal = new JSONObject(br);
            }
            catch (Exception e) {
                try {
                    this.raiseValidateError("error parsing MTD file with path " + filename + ": " + e.getMessage(), conditional);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(br);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(br);
            }
            IOUtilFunctions.closeSilently(br);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readMatrixMarketFile(String filename, boolean conditional) throws LanguageException {
        String[] retVal;
        block9: {
            retVal = new String[]{new String(""), new String("")};
            boolean exists = false;
            try {
                Path path = new Path(filename);
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                exists = fs.exists(path);
                boolean getFileStatusIsDir = fs.getFileStatus(path).isDirectory();
                if (exists && getFileStatusIsDir) {
                    this.raiseValidateError("MatrixMarket files as directories not supported", conditional);
                    break block9;
                }
                if (exists) {
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
                    try {
                        retVal[0] = in.readLine();
                        do {
                            retVal[1] = in.readLine();
                        } while (retVal[1].charAt(0) == '%');
                        if (!retVal[0].startsWith("%%")) {
                            this.raiseValidateError("MatrixMarket files must begin with a header line.", conditional);
                        }
                        break block9;
                    }
                    finally {
                        IOUtilFunctions.closeSilently(in);
                    }
                }
                this.raiseValidateError("Could not find the file: " + filename, conditional);
            }
            catch (IOException e) {
                throw new LanguageException(e);
            }
        }
        return retVal;
    }

    public boolean checkHasMatrixMarketFormat(String inputFileName, String mtdFileName, boolean conditional) throws LanguageException {
        JSONObject mtdObject = this.readMetadataFile(mtdFileName, conditional);
        if (mtdObject != null) {
            return false;
        }
        if (MapReduceTool.existsFileOnHDFS(inputFileName) && !MapReduceTool.isDirectory(inputFileName)) {
            boolean bl;
            BufferedReader in = null;
            try {
                Path path = new Path(inputFileName);
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                in = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
                String headerLine = new String("");
                if (in.ready()) {
                    headerLine = in.readLine();
                }
                bl = headerLine != null && headerLine.startsWith("%%");
            }
            catch (Exception ex) {
                try {
                    throw new LanguageException("Failed to read mtd file.", ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(in);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(in);
            return bl;
        }
        return false;
    }

    public boolean checkHasDelimitedFormat(String filename, boolean conditional) throws LanguageException {
        JSONObject mtdObject = this.readMetadataFile(filename + ".mtd", conditional);
        if (mtdObject != null) {
            String formatTypeString = (String)JSONHelper.get(mtdObject, FORMAT_TYPE);
            return formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV);
        }
        return false;
    }

    public boolean isCSVReadWithUnknownSize() {
        Expression format = this.getVarParam(FORMAT_TYPE);
        if (this._opcode == Expression.DataOp.READ && format != null && format.toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
            Expression rows = this.getVarParam("rows");
            Expression cols = this.getVarParam("cols");
            return rows == null || Long.parseLong(rows.toString()) < 0L || cols == null || Long.parseLong(cols.toString()) < 0L;
        }
        return false;
    }

    public boolean isRead() {
        return this._opcode == Expression.DataOp.READ;
    }
}

