/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseRow;
import org.apache.sysml.runtime.matrix.data.SparseRowVector;
import org.apache.sysml.runtime.util.SortUtils;

public class SparseBlockCOO
extends SparseBlock {
    private static final long serialVersionUID = 7223478015917668745L;
    private int _rlen = -1;
    private int[] _rindexes = null;
    private int[] _cindexes = null;
    private double[] _values = null;
    private int _size = 0;

    public SparseBlockCOO(int rlen) {
        this(rlen, 4);
    }

    public SparseBlockCOO(int rlen, int capacity) {
        this._rlen = rlen;
        this._rindexes = new int[capacity];
        this._cindexes = new int[capacity];
        this._values = new double[capacity];
        this._size = 0;
    }

    public SparseBlockCOO(SparseBlock sblock) {
        long size = sblock.size();
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("SparseBlockCOO supports nnz<=Integer.MAX_VALUE but got " + size);
        }
        if (sblock instanceof SparseBlockCOO) {
            SparseBlockCOO ocoo = (SparseBlockCOO)sblock;
            this._rlen = ocoo._rlen;
            this._rindexes = Arrays.copyOf(ocoo._rindexes, ocoo._size);
            this._cindexes = Arrays.copyOf(ocoo._cindexes, ocoo._size);
            this._values = Arrays.copyOf(ocoo._values, ocoo._size);
            this._size = ocoo._size;
        } else {
            this._rlen = sblock.numRows();
            this._rindexes = new int[(int)size];
            this._cindexes = new int[(int)size];
            this._values = new double[(int)size];
            this._size = (int)size;
            int pos = 0;
            for (int i = 0; i < this._rlen; ++i) {
                if (sblock.isEmpty(i)) continue;
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int j = apos; j < apos + alen; ++j) {
                    this._rindexes[pos] = i;
                    this._cindexes[pos] = aix[j];
                    this._values[pos] = avals[j];
                    ++pos;
                }
            }
        }
    }

    public SparseBlockCOO(SparseRow[] rows, int nnz) {
        this._rlen = rows.length;
        this._rindexes = new int[nnz];
        this._cindexes = new int[nnz];
        this._values = new double[nnz];
        this._size = nnz;
        int pos = 0;
        for (int i = 0; i < this._rlen; ++i) {
            int alen = rows[i].size();
            int[] aix = rows[i].indexes();
            double[] avals = rows[i].values();
            for (int j = 0; j < alen; ++j) {
                this._rindexes[pos] = i;
                this._cindexes[pos] = aix[j];
                this._values[pos] = avals[j];
                ++pos;
            }
        }
    }

    public static long estimateMemory(long nrows, long ncols, double sparsity) {
        double lnnz = Math.max(4.0, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 24.0;
        size += 32.0 + lnnz * 4.0;
        size += 32.0 + lnnz * 4.0;
        return (long)Math.min(size += 32.0 + lnnz * 8.0, 9.223372036854776E18);
    }

    @Override
    public void allocate(int r) {
    }

    @Override
    public void allocate(int r, int nnz) {
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
    }

    @Override
    public int numRows() {
        return this._rlen;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public void reset() {
        this._size = 0;
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        this._size = 0;
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        int pos = this.pos(r);
        int len = this.size(r);
        if (len > 0) {
            System.arraycopy(this._rindexes, pos + len, this._rindexes, pos, this._size - (pos + len));
            System.arraycopy(this._cindexes, pos + len, this._cindexes, pos, this._size - (pos + len));
            System.arraycopy(this._values, pos + len, this._values, pos, this._size - (pos + len));
            this._size -= len;
        }
    }

    @Override
    public long size() {
        return this._size;
    }

    @Override
    public int size(int r) {
        int pos = this.pos(r);
        if (pos >= this._size || this._rindexes[pos] != r) {
            return 0;
        }
        double rix0 = this._rindexes[pos];
        int cnt = 0;
        while (pos < this._size && rix0 == (double)this._rindexes[pos++]) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public long size(int rl, int ru) {
        return this.pos(ru) - this.pos(rl);
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = rl; i < ru; ++i) {
            if (this.isEmpty(i)) continue;
            int start = this.posFIndexGTE(i, cl);
            int end = this.posFIndexGTE(i, cu);
            nnz += start != -1 ? (long)(end - start) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        int pos = this.pos(r);
        return pos >= this._size || this._rindexes[pos] != r;
    }

    @Override
    public int[] indexes(int r) {
        return this._cindexes;
    }

    @Override
    public double[] values(int r) {
        return this._values;
    }

    @Override
    public int pos(int r) {
        int index = Arrays.binarySearch(this._rindexes, 0, this._size, r);
        if (index < 0) {
            return Math.abs(index + 1);
        }
        while (index > 0 && this._rindexes[index - 1] == r) {
            --index;
        }
        return index;
    }

    @Override
    public boolean set(int r, int c, double v) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._cindexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            if (v == 0.0) {
                this.shiftLeftAndDelete(index);
                return true;
            }
            this._values[index] = v;
            return false;
        }
        if (v == 0.0) {
            return false;
        }
        index = Math.abs(index + 1);
        if (this._size == this._values.length) {
            this.resizeAndInsert(index, r, c, v);
        } else {
            this.shiftRightAndInsert(index, r, c, v);
        }
        return true;
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        int pos = this.pos(r);
        int alen = row.size();
        int[] aix = row.indexes();
        double[] avals = row.values();
        this.deleteIndexRange(r, aix[0], aix[alen - 1] + 1);
        this.shiftRightByN(pos, alen);
        Arrays.fill(this._rindexes, pos, pos + alen, r);
        System.arraycopy(aix, 0, this._cindexes, pos, alen);
        System.arraycopy(avals, 0, this._values, pos, alen);
        this._size += alen;
    }

    @Override
    public void append(int r, int c, double v) {
        if (v == 0.0) {
            return;
        }
        if (this._size == this._values.length) {
            this.resize();
        }
        this.insert(this._size, r, c, v);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        int index;
        this.deleteIndexRange(r, cl, cu);
        int lnnz = 0;
        for (int i = vix; i < vix + vlen; ++i) {
            lnnz += v[i] != 0.0 ? 1 : 0;
        }
        int lsize = this._size + lnnz;
        if (this._values.length < lsize) {
            this.resize(lsize);
        }
        this.shiftRightByN((index = this.posFIndexGT(r, cl)) > 0 ? index : this.pos(r + 1), lnnz);
        for (int i = vix; i < vix + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this._rindexes[index] = r;
            this._cindexes[index] = cl + i - vix;
            this._values[index] = v[i];
            ++index;
        }
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        int start = this.posFIndexGTE(r, cl);
        if (start < 0) {
            return;
        }
        int len = this.size(r);
        int end = this.posFIndexGTE(r, cu);
        if (end < 0) {
            end = start + len;
        }
        System.arraycopy(this._rindexes, end, this._rindexes, start, this._size - end);
        System.arraycopy(this._cindexes, end, this._cindexes, start, this._size - end);
        System.arraycopy(this._values, end, this._values, start, this._size - end);
        this._size -= end - start;
    }

    @Override
    public void sort() {
        SortUtils.sortByIndex(0, this._size, this._rindexes, this._cindexes, this._values);
        int index = 0;
        while (index < this._size) {
            int r = this._rindexes[index];
            int len = 0;
            while (r == this._rindexes[index]) {
                ++len;
                ++index;
            }
            SortUtils.sortByIndex(index - len, index, this._cindexes, this._values);
        }
    }

    @Override
    public void sort(int r) {
        int pos = this.pos(r);
        int len = this.size(r);
        if (len <= 100 || !SortUtils.isSorted(pos, pos + len, this._cindexes)) {
            SortUtils.sortByIndex(pos, pos + len, this._cindexes, this._values);
        }
    }

    @Override
    public double get(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._cindexes, pos, pos + (len = this.size(r)), c);
        return index >= 0 ? this._values[index] : 0.0;
    }

    @Override
    public SparseRow get(int r) {
        int pos = this.pos(r);
        int len = this.size(r);
        SparseRowVector row = new SparseRowVector(len);
        System.arraycopy(this._cindexes, pos, row.indexes(), 0, len);
        System.arraycopy(this._values, pos, row.values(), 0, len);
        row.setSize(len);
        return row;
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._cindexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) - 1 >= pos ? index - 1 : -1;
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._cindexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    @Override
    public int posFIndexGT(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._cindexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index + 1 < pos + len ? index + 1 : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    @Override
    public Iterator<IJV> getIterator() {
        return new SparseBlockCOOIterator(0, this._size);
    }

    @Override
    public Iterator<IJV> getIterator(int ru) {
        return new SparseBlockCOOIterator(0, this.pos(ru));
    }

    @Override
    public Iterator<IJV> getIterator(int rl, int ru) {
        return new SparseBlockCOOIterator(this.pos(rl), this.pos(ru));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockCOO: rlen=");
        sb.append(this._rlen);
        sb.append(", nnz=");
        sb.append(this._size);
        sb.append("\n");
        for (int i = 0; i < this._size; ++i) {
            sb.append(this._rindexes[i]);
            sb.append(",");
            sb.append(this._cindexes[i]);
            sb.append(":");
            sb.append(this._values[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void resize() {
        double tmpCap = (double)this._values.length * 2.0;
        int newCap = (int)Math.min(tmpCap, 2.147483647E9);
        this.resize(newCap);
    }

    private void resize(int capacity) {
        this._rindexes = Arrays.copyOf(this._rindexes, capacity);
        this._cindexes = Arrays.copyOf(this._cindexes, capacity);
        this._values = Arrays.copyOf(this._values, capacity);
    }

    private void resizeAndInsert(int ix, int r, int c, double v) {
        double tmpCap = (double)this._values.length * 2.0;
        int newCap = (int)Math.min(tmpCap, 2.147483647E9);
        int[] oldrindexes = this._rindexes;
        int[] oldcindexes = this._cindexes;
        double[] oldvalues = this._values;
        this._rindexes = new int[newCap];
        this._cindexes = new int[newCap];
        this._values = new double[newCap];
        System.arraycopy(oldrindexes, 0, this._rindexes, 0, ix);
        System.arraycopy(oldcindexes, 0, this._cindexes, 0, ix);
        System.arraycopy(oldvalues, 0, this._values, 0, ix);
        System.arraycopy(oldrindexes, ix, this._rindexes, ix + 1, this._size - ix);
        System.arraycopy(oldcindexes, ix, this._cindexes, ix + 1, this._size - ix);
        System.arraycopy(oldvalues, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, r, c, v);
    }

    private void shiftRightAndInsert(int ix, int r, int c, double v) {
        System.arraycopy(this._rindexes, ix, this._rindexes, ix + 1, this._size - ix);
        System.arraycopy(this._cindexes, ix, this._cindexes, ix + 1, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, r, c, v);
    }

    private void shiftLeftAndDelete(int ix) {
        System.arraycopy(this._rindexes, ix + 1, this._rindexes, ix, this._size - ix - 1);
        System.arraycopy(this._cindexes, ix + 1, this._cindexes, ix, this._size - ix - 1);
        System.arraycopy(this._values, ix + 1, this._values, ix, this._size - ix - 1);
        --this._size;
    }

    private void shiftRightByN(int ix, int n) {
        System.arraycopy(this._rindexes, ix, this._rindexes, ix + n, this._size - ix);
        System.arraycopy(this._cindexes, ix, this._cindexes, ix + n, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + n, this._size - ix);
        this._size += n;
    }

    private void insert(int ix, int r, int c, double v) {
        this._rindexes[ix] = r;
        this._cindexes[ix] = c;
        this._values[ix] = v;
        ++this._size;
    }

    public int[] rowIndexes() {
        return this._rindexes;
    }

    public int[] indexes() {
        return this._cindexes;
    }

    public double[] values() {
        return this._values;
    }

    private class SparseBlockCOOIterator
    implements Iterator<IJV> {
        private int _pos = 0;
        private int _len = 0;
        private IJV retijv = new IJV();

        protected SparseBlockCOOIterator(int posrl, int posru) {
            this._pos = posrl;
            this._len = posru;
        }

        @Override
        public boolean hasNext() {
            return this._pos < this._len;
        }

        @Override
        public IJV next() {
            this.retijv.set(SparseBlockCOO.this._rindexes[this._pos], SparseBlockCOO.this._cindexes[this._pos], SparseBlockCOO.this._values[this._pos++]);
            return this.retijv;
        }

        @Override
        public void remove() {
            throw new RuntimeException("SparseBlockCOOIterator is unsupported!");
        }
    }
}

