/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Iterator;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.LongLongDoubleHashMap;

public class CTableMap {
    private LongLongDoubleHashMap _map = new LongLongDoubleHashMap();
    private long _maxRow = -1L;
    private long _maxCol = -1L;

    public int size() {
        return this._map.size();
    }

    public Iterator<LongLongDoubleHashMap.LLDoubleEntry> getIterator() {
        return this._map.getIterator();
    }

    public long getMaxRow() {
        return this._maxRow;
    }

    public long getMaxColumn() {
        return this._maxCol;
    }

    public void aggregate(long row, long col, double w) {
        this._map.addValue(row, col, w);
        this._maxRow = Math.max(this._maxRow, row);
        this._maxCol = Math.max(this._maxCol, col);
    }

    public MatrixBlock toMatrixBlock(int rlen, int clen) {
        int nnz = this._map.size();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz);
        MatrixBlock mb = new MatrixBlock(rlen, clen, sparse, nnz);
        if (sparse) {
            Iterator<LongLongDoubleHashMap.LLDoubleEntry> iter2 = this._map.getIterator();
            while (iter2.hasNext()) {
                LongLongDoubleHashMap.LLDoubleEntry e = iter2.next();
                double value = e.value;
                int rix = (int)e.key1;
                int cix = (int)e.key2;
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.appendValue(rix - 1, cix - 1, value);
            }
            mb.sortSparseRows();
        } else {
            Iterator<LongLongDoubleHashMap.LLDoubleEntry> iter = this._map.getIterator();
            while (iter.hasNext()) {
                LongLongDoubleHashMap.LLDoubleEntry e = iter.next();
                double value = e.value;
                int rix = (int)e.key1;
                int cix = (int)e.key2;
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.quickSetValue(rix - 1, cix - 1, value);
            }
        }
        return mb;
    }
}

