/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.utils.Statistics;

public class FunctionProgramBlock
extends ProgramBlock {
    public String _functionName;
    public String _namespace;
    protected ArrayList<ProgramBlock> _childBlocks = new ArrayList();
    protected ArrayList<DataIdentifier> _inputParams = new ArrayList();
    protected ArrayList<DataIdentifier> _outputParams;
    private boolean _recompileOnce = false;

    public FunctionProgramBlock(Program prog, ArrayList<DataIdentifier> inputParams, ArrayList<DataIdentifier> outputParams) {
        super(prog);
        for (DataIdentifier id : inputParams) {
            this._inputParams.add(new DataIdentifier(id));
        }
        this._outputParams = new ArrayList();
        for (DataIdentifier id : outputParams) {
            this._outputParams.add(new DataIdentifier(id));
        }
    }

    public ArrayList<DataIdentifier> getInputParams() {
        return this._inputParams;
    }

    public ArrayList<DataIdentifier> getOutputParams() {
        return this._outputParams;
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public void setChildBlocks(ArrayList<ProgramBlock> pbs) {
        this._childBlocks = pbs;
    }

    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        try {
            if (ConfigurationManager.isDynamicRecompilation() && this.isRecompileOnce()) {
                long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
                LocalVariableMap tmp = (LocalVariableMap)ec.getVariables().clone();
                Recompiler.recompileProgramBlockHierarchy(this._childBlocks, tmp, this._tid, true);
                if (DMLScript.STATISTICS) {
                    long t1 = System.nanoTime();
                    Statistics.incrementFunRecompileTime(t1 - t0);
                    Statistics.incrementFunRecompiles();
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Error recompiling function body.", ex);
        }
        try {
            for (int i = 0; i < this._childBlocks.size(); ++i) {
                ec.updateDebugState(i);
                this._childBlocks.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating function program block", e);
        }
        this.checkOutputParameters(ec.getVariables());
    }

    protected void checkOutputParameters(LocalVariableMap vars) {
        for (DataIdentifier diOut : this._outputParams) {
            String varName = diOut.getName();
            Data dat = vars.get(varName);
            if (dat == null) {
                LOG.error((Object)("Function output " + varName + " is missing."));
                continue;
            }
            if (dat.getDataType() != diOut.getDataType()) {
                LOG.warn((Object)("Function output " + varName + " has wrong data type: " + (Object)((Object)dat.getDataType()) + "."));
                continue;
            }
            if (dat.getValueType() == diOut.getValueType()) continue;
            LOG.warn((Object)("Function output " + varName + " has wrong value type: " + (Object)((Object)dat.getValueType()) + "."));
        }
    }

    public void setRecompileOnce(boolean flag) {
        this._recompileOnce = flag;
    }

    public boolean isRecompileOnce() {
        return this._recompileOnce;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in function program block generated from function statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

