/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.data.TripleIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;

public class MMRJMRMapper
extends MapperBase
implements Mapper<Writable, Writable, Writable, Writable> {
    private TripleIndexes triplebuffer = new TripleIndexes();
    private TaggedMatrixValue taggedValue = null;
    private HashMap<Byte, Long> numRepeats = new HashMap();
    private HashSet<Byte> aggBinInput1s = new HashSet();
    private HashSet<Byte> aggBinInput2s = new HashSet();

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.processMapperInstructionsForMatrix(index);
        Iterator iterator = ((ArrayList)this.outputIndexes.get(index)).iterator();
        while (iterator.hasNext()) {
            byte output = (Byte)iterator.next();
            ArrayList<IndexedMatrixValue> blkList = this.cachedValues.get(output);
            if (blkList == null) continue;
            for (IndexedMatrixValue result : blkList) {
                if (result == null) continue;
                if (this.aggBinInput1s.contains(output)) {
                    for (long j = 0L; j < this.numRepeats.get(output); ++j) {
                        this.triplebuffer.setIndexes(result.getIndexes().getRowIndex(), j + 1L, result.getIndexes().getColumnIndex());
                        this.taggedValue.setBaseObject(result.getValue());
                        this.taggedValue.setTag(output);
                        out.collect((Object)this.triplebuffer, (Object)this.taggedValue);
                    }
                    continue;
                }
                if (this.aggBinInput2s.contains(output)) {
                    for (long i = 0L; i < this.numRepeats.get(output); ++i) {
                        this.triplebuffer.setIndexes(i + 1L, result.getIndexes().getColumnIndex(), result.getIndexes().getRowIndex());
                        this.taggedValue.setBaseObject(result.getValue());
                        this.taggedValue.setTag(output);
                        out.collect((Object)this.triplebuffer, (Object)this.taggedValue);
                    }
                    continue;
                }
                this.triplebuffer.setIndexes(result.getIndexes().getRowIndex(), result.getIndexes().getColumnIndex(), -1L);
                this.taggedValue.setBaseObject(result.getValue());
                this.taggedValue.setTag(output);
                out.collect((Object)this.triplebuffer, (Object)this.taggedValue);
            }
        }
    }

    public void map(Writable rawKey, Writable rawValue, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.commonMap(rawKey, rawValue, out, reporter);
    }

    @Override
    public void configure(JobConf job) {
        AggregateBinaryInstruction[] aggBinInstructions;
        super.configure(job);
        this.taggedValue = TaggedMatrixValue.createObject(this.valueClass);
        try {
            aggBinInstructions = MRJobConfiguration.getAggregateBinaryInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        for (AggregateBinaryInstruction aggBinInstruction : aggBinInstructions) {
            MatrixCharacteristics mc = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, aggBinInstruction.input2);
            long matrixNumColumn = mc.getCols();
            int blockNumColumn = mc.getColsPerBlock();
            this.numRepeats.put(aggBinInstruction.input1, (long)Math.ceil((double)matrixNumColumn / (double)blockNumColumn));
            mc = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, aggBinInstruction.input1);
            long matrixNumRow = mc.getRows();
            int blockNumRow = mc.getRowsPerBlock();
            this.numRepeats.put(aggBinInstruction.input2, (long)Math.ceil((double)matrixNumRow / (double)blockNumRow));
            this.aggBinInput1s.add(aggBinInstruction.input1);
            this.aggBinInput2s.add(aggBinInstruction.input2);
        }
    }
}

