/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.io.WritableComparable;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CTable;
import org.apache.sysml.runtime.functionobjects.ReduceDiag;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;
import org.apache.sysml.runtime.util.IndexRange;

public class MatrixCell
extends MatrixValue
implements WritableComparable,
Serializable {
    private static final long serialVersionUID = -7755996717411912578L;
    protected double value;

    public MatrixCell() {
        this.value = 0.0;
    }

    public MatrixCell(MatrixCell that) {
        this.value = that.value;
    }

    public MatrixCell(MatrixValue that) {
        if (that instanceof MatrixCell) {
            this.value = ((MatrixCell)that).value;
        }
    }

    public MatrixCell(double v) {
        this.value = v;
    }

    private static MatrixCell checkType(MatrixValue cell) throws DMLRuntimeException {
        if (cell != null && !(cell instanceof MatrixCell)) {
            throw new DMLRuntimeException("the Matrix Value is not MatrixCell!");
        }
        return (MatrixCell)cell;
    }

    public void setValue(double v) {
        this.value = v;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void copy(MatrixValue that, boolean sp) {
        this.copy(that);
    }

    @Override
    public void copy(MatrixValue that) {
        if (that == null || !(that instanceof MatrixCell)) {
            throw new RuntimeException("the Matrix Value is not MatrixCell!");
        }
        MatrixCell c2 = (MatrixCell)that;
        this.value = c2.getValue();
    }

    @Override
    public long getNonZeros() {
        return 1L;
    }

    @Override
    public int getNumColumns() {
        return 1;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public double getValue(int r, int c) {
        return this.value;
    }

    @Override
    public boolean isInSparseFormat() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0.0;
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void reset() {
        this.value = 0.0;
    }

    @Override
    public void reset(int rl, int cl) {
        this.value = 0.0;
    }

    @Override
    public void reset(int rl, int cl, boolean sp) {
        this.value = 0.0;
    }

    @Override
    public void reset(int rl, int cl, boolean sp, long nnzs) {
        this.value = 0.0;
    }

    @Override
    public void reset(int rl, int cl, double v) {
        this.value = v;
    }

    @Override
    public void setValue(int r, int c, double v) {
        this.value = v;
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public MatrixValue aggregateBinaryOperations(MatrixValue value1, MatrixValue value2, MatrixValue result, AggregateBinaryOperator op) throws DMLRuntimeException {
        MatrixCell c1 = MatrixCell.checkType(value1);
        MatrixCell c2 = MatrixCell.checkType(value2);
        MatrixCell c3 = MatrixCell.checkType(result);
        if (c3 == null) {
            c3 = new MatrixCell();
        }
        c3.setValue(op.binaryFn.execute(c1.getValue(), c2.getValue()));
        return c3;
    }

    @Override
    public MatrixValue aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int brlen, int bclen, MatrixIndexes indexesIn) throws DMLRuntimeException {
        MatrixCell c3 = MatrixCell.checkType(result);
        if (c3 == null) {
            c3 = new MatrixCell();
        }
        if (op.indexFn instanceof ReduceDiag) {
            if (indexesIn.getRowIndex() == indexesIn.getColumnIndex()) {
                c3.setValue(this.getValue());
            } else {
                c3.setValue(0.0);
            }
        } else {
            c3.setValue(this.getValue());
        }
        return c3;
    }

    @Override
    public MatrixValue binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) throws DMLRuntimeException {
        MatrixCell c2 = MatrixCell.checkType(thatValue);
        MatrixCell c3 = MatrixCell.checkType(result);
        if (c3 == null) {
            c3 = new MatrixCell();
        }
        c3.setValue(op.fn.execute(this.getValue(), c2.getValue()));
        return c3;
    }

    @Override
    public void binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) throws DMLRuntimeException {
        MatrixCell c2 = MatrixCell.checkType(thatValue);
        this.setValue(op.fn.execute(this.getValue(), c2.getValue()));
    }

    public void denseScalarOperationsInPlace(ScalarOperator op) throws DMLRuntimeException {
        this.value = op.executeScalar(this.value);
    }

    @Override
    public MatrixValue reorgOperations(ReorgOperator op, MatrixValue result, int startRow, int startColumn, int length) throws DMLRuntimeException {
        MatrixCell c3 = MatrixCell.checkType(result);
        if (c3 == null) {
            c3 = new MatrixCell();
        }
        c3.setValue(this.getValue());
        return c3;
    }

    @Override
    public MatrixValue scalarOperations(ScalarOperator op, MatrixValue result) throws DMLRuntimeException {
        MatrixCell c3 = MatrixCell.checkType(result);
        c3.setValue(op.fn.execute(this.value, op.getConstant()));
        return c3;
    }

    public void sparseScalarOperationsInPlace(ScalarOperator op) throws DMLRuntimeException {
        this.value = op.executeScalar(this.value);
    }

    public void sparseUnaryOperationsInPlace(UnaryOperator op) throws DMLRuntimeException {
        this.value = op.fn.execute(this.value);
    }

    @Override
    public MatrixValue unaryOperations(UnaryOperator op, MatrixValue result) throws DMLRuntimeException {
        MatrixCell c3 = MatrixCell.checkType(result);
        c3.setValue(op.fn.execute(this.value));
        return c3;
    }

    @Override
    public void unaryOperationsInPlace(UnaryOperator op) throws DMLRuntimeException {
        this.value = op.fn.execute(this.value);
    }

    public int compareTo(MatrixCell o) {
        return Double.compare(this.value, o.value);
    }

    public int compareTo(Object o) {
        if (!(o instanceof MatrixCell)) {
            return -1;
        }
        return Double.compare(this.value, ((MatrixCell)o).value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MatrixCell)) {
            return false;
        }
        return this.value == ((MatrixCell)o).value;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection) throws DMLRuntimeException {
        throw new DMLRuntimeException("MatrixCell.incrementalAggregate should never be called");
    }

    @Override
    public MatrixValue zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) throws DMLRuntimeException {
        if (range.rowStart != 0L || range.rowEnd != 0L || range.colStart != 0L || range.colEnd != 0L) {
            throw new DMLRuntimeException("wrong range: " + range + " for matrixCell");
        }
        MatrixCell c3 = MatrixCell.checkType(result);
        c3.setValue(this.value);
        return c3;
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) throws DMLRuntimeException {
        throw new DMLRuntimeException("MatrixCell.incrementalAggregate should never be called");
    }

    @Override
    public void ternaryOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixCell c2 = MatrixCell.checkType(that);
        MatrixCell c3 = MatrixCell.checkType(that2);
        CTable ctable = CTable.getCTableFnObject();
        if (resultMap != null) {
            ctable.execute(this.value, c2.value, c3.value, false, resultMap);
        } else {
            ctable.execute(this.value, c2.value, c3.value, false, resultBlock);
        }
    }

    @Override
    public void ternaryOperations(Operator op, MatrixValue that, double scalarThat2, boolean ignoreZeros, CTableMap ctableResult, MatrixBlock ctableResultBlock) throws DMLRuntimeException {
        MatrixCell c2 = MatrixCell.checkType(that);
        CTable ctable = CTable.getCTableFnObject();
        if (ctableResult != null) {
            ctable.execute(this.value, c2.value, scalarThat2, ignoreZeros, ctableResult);
        } else {
            ctable.execute(this.value, c2.value, scalarThat2, ignoreZeros, ctableResultBlock);
        }
    }

    @Override
    public void ternaryOperations(Operator op, double scalarThat, double scalarThat2, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        CTable ctable = CTable.getCTableFnObject();
        if (resultMap != null) {
            ctable.execute(this.value, scalarThat, scalarThat2, false, resultMap);
        } else {
            ctable.execute(this.value, scalarThat, scalarThat2, false, resultBlock);
        }
    }

    @Override
    public void ternaryOperations(Operator op, MatrixIndexes ix1, double scalarThat, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        CTable ctable = CTable.getCTableFnObject();
        if (resultMap != null) {
            if (left) {
                ctable.execute((double)ix1.getRowIndex(), this.value, scalarThat, false, resultMap);
            } else {
                ctable.execute(this.value, (double)ix1.getRowIndex(), scalarThat, false, resultMap);
            }
        } else if (left) {
            ctable.execute((double)ix1.getRowIndex(), this.value, scalarThat, false, resultBlock);
        } else {
            ctable.execute(this.value, (double)ix1.getRowIndex(), scalarThat, false, resultBlock);
        }
    }

    @Override
    public void ternaryOperations(Operator op, double scalarThat, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixCell c3 = MatrixCell.checkType(that2);
        CTable ctable = CTable.getCTableFnObject();
        if (resultMap != null) {
            ctable.execute(this.value, scalarThat, c3.value, false, resultMap);
        } else {
            ctable.execute(this.value, scalarThat, c3.value, false, resultBlock);
        }
    }

    @Override
    public MatrixValue quaternaryOperations(QuaternaryOperator qop, MatrixValue um, MatrixValue vm, MatrixValue wm, MatrixValue out) throws DMLRuntimeException {
        throw new DMLRuntimeException("operation not supported fro MatrixCell");
    }

    @Override
    public void sliceOperations(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blockRowFactor, int blockColFactor, int boundaryRlen, int boundaryClen) throws DMLRuntimeException {
        ((MatrixCell)outlist.get(0).getValue()).setValue(this.value);
    }

    @Override
    public MatrixValue replaceOperations(MatrixValue result, double pattern, double replacement) throws DMLRuntimeException {
        MatrixCell out = MatrixCell.checkType(result);
        out.value = this.value == pattern || Double.isNaN(pattern) && Double.isNaN(this.value) ? replacement : this.value;
        return out;
    }

    @Override
    public MatrixValue aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blockingFactorRow, int blockingFactorCol, MatrixIndexes indexesIn, boolean inCP) throws DMLRuntimeException {
        return this.aggregateUnaryOperations(op, result, blockingFactorRow, blockingFactorCol, indexesIn);
    }

    @Override
    public MatrixValue aggregateBinaryOperations(MatrixIndexes m1Index, MatrixValue m1Value, MatrixIndexes m2Index, MatrixValue m2Value, MatrixValue result, AggregateBinaryOperator op) throws DMLRuntimeException {
        throw new DMLRuntimeException("MatrixCell.aggregateBinaryOperations should never be called");
    }

    @Override
    public void appendOperations(MatrixValue valueIn2, ArrayList<IndexedMatrixValue> outlist, int blockRowFactor, int blockColFactor, boolean cbind, boolean m2IsLast, int nextNCol) throws DMLRuntimeException {
        ((MatrixCell)outlist.get(0).getValue()).setValue(this.value);
        MatrixCell c2 = MatrixCell.checkType(valueIn2);
        ((MatrixCell)outlist.get(1).getValue()).setValue(c2.getValue());
    }
}

