/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNN;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNNHelper;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNNRotate180Helper;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.utils.NativeHelper;

public class LibMatrixDNNConv2dBackwardDataHelper {

    public static class Conv2dBackwardData
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;

        public Conv2dBackwardData(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
        }

        @Override
        public Long call() throws Exception {
            int PQ = this._params.P * this._params.Q;
            int K = this._params.K;
            int CRS = this._params.C * this._params.R * this._params.S;
            MatrixBlock filter = this._params.input1;
            MatrixBlock dout = this._params.input2;
            MatrixBlock dout_reshaped = new MatrixBlock(PQ, K, false);
            dout_reshaped.allocateDenseBlock();
            LibMatrixDNNRotate180Helper.Rotate180Worker rotate180Worker = LibMatrixDNNRotate180Helper.Rotate180Worker.getWorker(dout, dout_reshaped.getDenseBlock(), this._params, true);
            long time1 = 0L;
            long time2 = 0L;
            for (int n = this._rl; n < this._ru; ++n) {
                long t3;
                rotate180Worker.execute(n, 0);
                MatrixBlock temp = new MatrixBlock(PQ, CRS, false);
                long t1 = DMLScript.STATISTICS && LibMatrixDNN.DISPLAY_STATISTICS ? System.nanoTime() : 0L;
                LibMatrixDNNHelper.singleThreadedMatMult(dout_reshaped, filter, temp, true, false, this._params);
                long t2 = DMLScript.STATISTICS && LibMatrixDNN.DISPLAY_STATISTICS ? System.nanoTime() : 0L;
                LibMatrixDNNHelper.doCol2imOverSingleImage(n, temp, this._params);
                long l = t3 = DMLScript.STATISTICS && LibMatrixDNN.DISPLAY_STATISTICS ? System.nanoTime() : 0L;
                if (!DMLScript.STATISTICS || !LibMatrixDNN.DISPLAY_STATISTICS) continue;
                time1 += t2 - t1;
                time2 += t3 - t2;
            }
            if (DMLScript.STATISTICS && LibMatrixDNN.DISPLAY_STATISTICS) {
                LibMatrixDNN.loopedConvBwdDataMatMultTime.addAndGet(time1);
                LibMatrixDNN.loopedConvBwdDataCol2ImTime.addAndGet(time2);
            }
            return 0L;
        }
    }

    public static class SparseNativeConv2dBackwardDataDense
    implements Callable<Long> {
        public int _rl;
        public int _ru;
        private final ConvolutionParameters _params;

        public SparseNativeConv2dBackwardDataDense(int rl, int ru, ConvolutionParameters params) {
            this._rl = rl;
            this._ru = ru;
            this._params = params;
        }

        @Override
        public Long call() throws Exception {
            int CHW = this._params.C * this._params.H * this._params.W;
            double[] ret = new double[CHW];
            double[] filterArr = this._params.input1.getDenseBlock();
            double[] dout_n = new double[this._params.P * this._params.Q * this._params.K];
            for (int n = this._rl; n < this._ru; ++n) {
                LibMatrixDNNHelper.getRowInDenseFormat(this._params.input2, n, dout_n);
                if (n > this._rl) {
                    Arrays.fill(ret, 0.0);
                }
                NativeHelper.conv2dBackwardDataDense(filterArr, dout_n, ret, 1, this._params.C, this._params.H, this._params.W, this._params.K, this._params.R, this._params.S, this._params.stride_h, this._params.stride_w, this._params.pad_h, this._params.pad_w, this._params.P, this._params.Q, 1);
                System.arraycopy(ret, 0, this._params.output.getDenseBlock(), n * CHW, CHW);
            }
            return 0L;
        }
    }
}

