/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedAdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReblockMapper;
import org.apache.sysml.runtime.matrix.mapred.ReblockReducer;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class ReblockMR {
    private static final Log LOG = LogFactory.getLog((String)ReblockMR.class.getName());

    private ReblockMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, long[] nnz, String instructionsInMapper, String reblockInstructions, String otherInstructionsInReducer, int numReducers, int replication, boolean jvmReuse, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        JobConf job = new JobConf(ReblockMR.class);
        job.setJobName("Reblock-MR");
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputsReblock(job, realIndexes, inputs, inputInfos, brlens, bclens);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, rlens, clens, nnz);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
        MRJobConfiguration.setInstructionsInMapper(job, instructionsInMapper);
        MRJobConfiguration.setReblockInstructions(job, reblockInstructions);
        MRJobConfiguration.setInstructionsInReducer(job, otherInstructionsInReducer);
        job.setInt("dfs.replication", replication);
        job.setInt(MRConfigurationNames.MR_TASK_TIMEOUT, 0);
        job.setMapSpeculativeExecution(false);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        if (jvmReuse) {
            job.setNumTasksToExecutePerJvm(-1);
        }
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, instructionsInMapper, reblockInstructions, null, otherInstructionsInReducer, resultIndexes);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, instructionsInMapper, reblockInstructions, null, null, otherInstructionsInReducer, resultIndexes, mapoutputIndexes, false);
        MatrixCharacteristics[] stats = ret.stats;
        int numRed = ReblockMR.determineNumReducers(rlens, clens, nnz, config.getIntValue("numreducers"), ret.numReducerGroups);
        job.setNumReduceTasks(numRed);
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(stats);
        }
        byte[] resultDimsUnknown = new byte[resultIndexes.length];
        for (int i = 0; i < resultIndexes.length; ++i) {
            resultDimsUnknown[i] = stats[i].getRows() == -1L || stats[i].getCols() == -1L ? (byte)1 : 0;
        }
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, resultDimsUnknown, outputs, outputInfos, true, true);
        job.setMapperClass(ReblockMapper.class);
        job.setMapOutputKeyClass(MatrixIndexes.class);
        job.setMapOutputValueClass(TaggedAdaptivePartialBlock.class);
        job.setReducerClass(ReblockReducer.class);
        MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        Counters.Group group = runjob.getCounters().getGroup("nonzeros");
        for (int i = 0; i < resultIndexes.length; ++i) {
            stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
        }
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }

    private static int determineNumReducers(long[] rlen, long[] clen, long[] nnz, int defaultNumRed, long numRedGroups) {
        int ret = defaultNumRed;
        long maxNumRed = InfrastructureAnalyzer.getRemoteParallelReduceTasks();
        long blockSize = InfrastructureAnalyzer.getHDFSBlockSize() / 0x100000L;
        long maxSize = -1L;
        for (int i = 0; i < rlen.length; ++i) {
            long lnnz = nnz[i] > 0L ? nnz[i] : rlen[i] * clen[i];
            long tmp = MatrixBlock.estimateSizeOnDisk(rlen[i], clen[i], lnnz) / 0x100000L;
            maxSize = Math.max(maxSize, tmp);
        }
        if (InfrastructureAnalyzer.isYarnEnabled()) {
            maxNumRed = Math.max(maxNumRed, YarnClusterAnalyzer.getNumCores() / 2L);
        }
        ret = (int)Math.max((long)ret, Math.min(maxSize / blockSize, maxNumRed));
        ret = (int)Math.min((long)ret, numRedGroups);
        ret = Math.max(ret, 1);
        return ret;
    }
}

