/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import scala.Tuple2;

public class AppendGAlignedSPInstruction
extends BinarySPInstruction {
    private boolean _cbind = true;

    private AppendGAlignedSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, boolean cbind, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.GAppend;
        this._cbind = cbind;
    }

    public static AppendGAlignedSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        boolean cbind = Boolean.parseBoolean(parts[5]);
        if (!opcode.equalsIgnoreCase("galignedappend")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendGSPInstruction: " + str);
        }
        return new AppendGAlignedSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, in3, out, cbind, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        this.checkBinaryAppendInputCharacteristics(sec, this._cbind, false, true);
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryBlockRDDHandleForVariable(this.input2.getName());
        JavaPairRDD out = null;
        long shiftBy = this._cbind ? mc1.getNumColBlocks() : mc1.getNumRowBlocks();
        out = in2.mapToPair((PairFunction)new ShiftColumnIndex(shiftBy, this._cbind));
        out = in1.union(out);
        this.updateBinaryAppendOutputMatrixCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
    }

    public static class ShiftColumnIndex
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -5185023611319654242L;
        private long _shiftBy;
        private boolean _cbind;

        public ShiftColumnIndex(long shiftBy, boolean cbind) {
            this._shiftBy = shiftBy;
            this._cbind = cbind;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            long rix = this._cbind ? ((MatrixIndexes)kv._1).getRowIndex() : ((MatrixIndexes)kv._1).getRowIndex() + this._shiftBy;
            long cix = this._cbind ? ((MatrixIndexes)kv._1).getColumnIndex() + this._shiftBy : ((MatrixIndexes)kv._1).getColumnIndex();
            return new Tuple2((Object)new MatrixIndexes(rix, cix), kv._2);
        }
    }
}

