/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.WeightedCrossEntropy;
import org.apache.sysml.lops.WeightedDivMM;
import org.apache.sysml.lops.WeightedSigmoid;
import org.apache.sysml.lops.WeightedSquaredLoss;
import org.apache.sysml.lops.WeightedUnaryMM;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryCPInstruction
extends ComputationCPInstruction {
    private CPOperand input4 = null;
    private int _numThreads = -1;

    private QuaternaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, int k, String opcode, String istr) {
        super(op, in1, in2, in3, out, opcode, istr);
        this.input4 = in4;
        this._numThreads = k;
    }

    public static QuaternaryCPInstruction parseInstruction(String inst) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("wsloss") || opcode.equalsIgnoreCase("wdivmm") || opcode.equalsIgnoreCase("wcemm")) {
            InstructionUtils.checkNumFields(parts, 7);
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand in3 = new CPOperand(parts[3]);
            CPOperand in4 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            int k = Integer.parseInt(parts[7]);
            if (opcode.equalsIgnoreCase("wsloss")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedSquaredLoss.WeightsType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
            if (opcode.equalsIgnoreCase("wdivmm")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedDivMM.WDivMMType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
            if (opcode.equalsIgnoreCase("wcemm")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedCrossEntropy.WCeMMType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
        } else if (opcode.equalsIgnoreCase("wsigmoid")) {
            InstructionUtils.checkNumFields(parts, 6);
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand in3 = new CPOperand(parts[3]);
            CPOperand out = new CPOperand(parts[4]);
            int k = Integer.parseInt(parts[6]);
            if (opcode.equalsIgnoreCase("wsigmoid")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedSigmoid.WSigmoidType.valueOf(parts[5])), in1, in2, in3, null, out, k, opcode, inst);
            }
        } else if (opcode.equalsIgnoreCase("wumm")) {
            InstructionUtils.checkNumFields(parts, 7);
            String uopcode = parts[1];
            CPOperand in1 = new CPOperand(parts[2]);
            CPOperand in2 = new CPOperand(parts[3]);
            CPOperand in3 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            int k = Integer.parseInt(parts[7]);
            return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedUnaryMM.WUMMType.valueOf(parts[6]), uopcode), in1, in2, in3, null, out, k, opcode, inst);
        }
        throw new DMLRuntimeException("Unexpected opcode in QuaternaryCPInstruction: " + inst);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock3 = ec.getMatrixInput(this.input3.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock4 = null;
        if (qop.hasFourInputs()) {
            if (this.input4.getDataType() == Expression.DataType.SCALAR) {
                matBlock4 = new MatrixBlock(1, 1, false);
                double eps = ec.getScalarInput(this.input4.getName(), this.input4.getValueType(), this.input4.isLiteral()).getDoubleValue();
                matBlock4.quickSetValue(0, 0, eps);
            } else {
                matBlock4 = ec.getMatrixInput(this.input4.getName(), this.getExtendedOpcode());
            }
        }
        MatrixValue out = matBlock1.quaternaryOperations(qop, matBlock2, matBlock3, matBlock4, new MatrixBlock(), this._numThreads);
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input3.getName(), this.getExtendedOpcode());
        if (qop.wtype1 != null || qop.wtype4 != null) {
            if ((qop.wtype1 != null && qop.wtype1.hasFourInputs() || qop.wtype4 != null && qop.wtype4.hasFourInputs()) && this.input4.getDataType() == Expression.DataType.MATRIX) {
                ec.releaseMatrixInput(this.input4.getName(), this.getExtendedOpcode());
            }
            ec.setVariable(this.output.getName(), new DoubleObject(out.getValue(0, 0)));
        } else {
            if (qop.wtype3 != null && qop.wtype3.hasFourInputs() && this.input4.getDataType() == Expression.DataType.MATRIX) {
                ec.releaseMatrixInput(this.input4.getName(), this.getExtendedOpcode());
            }
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)out, this.getExtendedOpcode());
        }
    }
}

