/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.MatrixMatrixBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MatrixScalarBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarScalarBuiltinCPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.RightScalarOperator;

public abstract class BuiltinBinaryCPInstruction
extends BinaryCPInstruction {
    private int _arity;

    protected BuiltinBinaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, int arity, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.BuiltinBinary;
        this._arity = arity;
    }

    public int getArity() {
        return this._arity;
    }

    public static BuiltinBinaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = BuiltinBinaryCPInstruction.parseBinaryInstruction(str, in1, in2, out);
        BuiltinBinaryCPInstruction.checkOutputDataType(in1, in2, out);
        Builtin func = Builtin.getBuiltinFnObject(opcode);
        if (in1.getDataType() == Expression.DataType.SCALAR && in2.getDataType() == Expression.DataType.SCALAR) {
            return new ScalarScalarBuiltinCPInstruction(new BinaryOperator(func), in1, in2, out, opcode, str);
        }
        if (in1.getDataType() == Expression.DataType.MATRIX && in2.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixMatrixBuiltinCPInstruction(new BinaryOperator(func), in1, in2, out, opcode, str);
        }
        return new MatrixScalarBuiltinCPInstruction(new RightScalarOperator(func, 0.0), in1, in2, out, opcode, str);
    }
}

