/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class RangeBasedReIndex
extends Lop {
    private boolean forLeftIndexing = false;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public RangeBasedReIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Lop rowDim, Lop colDim, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean forleft) throws LopsException {
        super(Lop.Type.RangeReIndex, dt, vt);
        this.init(input, rowL, rowU, colL, colU, rowDim, colDim, dt, vt, et, forleft);
    }

    public RangeBasedReIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Lop rowDim, Lop colDim, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.RangeReIndex, dt, vt);
        this.init(input, rowL, rowU, colL, colU, rowDim, colDim, dt, vt, et, false);
    }

    public RangeBasedReIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Lop rowDim, Lop colDim, Expression.DataType dt, Expression.ValueType vt, AggBinaryOp.SparkAggType aggtype, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.RangeReIndex, dt, vt);
        this._aggtype = aggtype;
        this.init(input, rowL, rowU, colL, colU, rowDim, colDim, dt, vt, et, false);
    }

    private void init(Lop inputMatrix, Lop rowL, Lop rowU, Lop colL, Lop colU, Lop leftMatrixRowDim, Lop leftMatrixColDim, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean forleft) {
        this.addInput(inputMatrix);
        this.addInput(rowL);
        this.addInput(rowU);
        this.addInput(colL);
        this.addInput(colU);
        this.addInput(leftMatrixRowDim);
        this.addInput(leftMatrixColDim);
        inputMatrix.addOutput(this);
        rowL.addOutput(this);
        rowU.addOutput(this);
        colL.addOutput(this);
        colU.addOutput(this);
        leftMatrixRowDim.addOutput(this);
        leftMatrixColDim.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
        this.forLeftIndexing = forleft;
    }

    private String getOpcode() {
        if (this.forLeftIndexing) {
            return "rangeReIndexForLeft";
        }
        return "rangeReIndex";
    }

    @Override
    public String getInstructions(String input, String rowl, String rowu, String coll, String colu, String leftRowDim, String leftColDim, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(rowl));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(rowu));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(coll));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(4).prepScalarInputOperand(colu));
        sb.append("\u00b0");
        sb.append(output);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(5).prepScalarInputOperand(leftRowDim));
            sb.append("\u00b0");
            sb.append(this.getInputs().get(6).prepScalarInputOperand(leftColDim));
        }
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append((Object)this._aggtype);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int input_index5, int input_index6, int input_index7, int output_index) throws LopsException {
        String rowl = this.getInputs().get(1).prepScalarLabel();
        String rowu = this.getInputs().get(2).prepScalarLabel();
        String coll = this.getInputs().get(3).prepScalarLabel();
        String colu = this.getInputs().get(4).prepScalarLabel();
        String left_nrow = this.getInputs().get(5).prepScalarLabel();
        String left_ncol = this.getInputs().get(6).prepScalarLabel();
        return this.getInstructions(Integer.toString(input_index1), rowl, rowu, coll, colu, left_nrow, left_ncol, Integer.toString(output_index));
    }

    @Override
    public String toString() {
        if (this.forLeftIndexing) {
            return "rangeReIndexForLeft";
        }
        return "rangeReIndex";
    }
}

