/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.Block;
import org.apache.sysds.runtime.data.DenseBlockLString;
import org.apache.sysds.runtime.data.DenseBlockString;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public abstract class DenseBlock
implements Serializable,
Block {
    private static final long serialVersionUID = 7517220490270237832L;
    protected int _rlen;
    protected int[] _odims;
    private double[] _reuse;

    protected DenseBlock(int[] dims) {
        this.setDims(dims);
    }

    protected abstract void allocateBlock(int var1, int var2);

    public final int getDim(int i) {
        return i == 0 ? this._rlen : (i == this._odims.length ? this._odims[i - 1] : this._odims[i - 1] / this._odims[i]);
    }

    public final int getCumODims(int i) {
        return this._odims[i];
    }

    public final void reset() {
        this.reset(this._rlen, this._odims, 0.0);
    }

    public final void reset(int[] dims) {
        this.reset(dims[0], DenseBlock.createDimOffsets(dims), 0.0);
    }

    public final void reset(int[] dims, double v) {
        this.reset(dims[0], DenseBlock.createDimOffsets(dims), v);
    }

    public final void reset(int rlen, int clen) {
        this.reset(rlen, new int[]{clen}, 0.0);
    }

    public final void reset(int rlen, int[] odims) {
        this.reset(rlen, odims, 0.0);
    }

    public final void reset(int rlen, int clen, double v) {
        this.reset(rlen, new int[]{clen}, v);
    }

    public abstract void reset(int var1, int[] var2, double var3);

    public final void resetNoFill(int rlen, int clen) {
        this.resetNoFill(rlen, new int[]{clen});
    }

    public abstract void resetNoFill(int var1, int[] var2);

    public static double estimateMemory(long nrows, long ncols) {
        long size = 16L;
        size += 4L;
        size += 4L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(1L));
        return size += 8L;
    }

    public void setDims(int[] dims) {
        long odims = UtilFunctions.prod(dims, 1);
        if (odims > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Invalid dims: " + Arrays.toString(dims));
        }
        this._rlen = dims[0];
        this._odims = DenseBlock.createDimOffsets(dims);
    }

    public final int numRows() {
        return this._rlen;
    }

    public final int numCols() {
        return this._odims[0];
    }

    public final int numDims() {
        return 1 + this._odims.length;
    }

    public abstract int numBlocks();

    public abstract int blockSize();

    public abstract int blockSize(int var1);

    public abstract boolean isNumeric();

    public abstract boolean isNumeric(Types.ValueType var1);

    public abstract boolean isContiguous();

    public abstract boolean isContiguous(int var1, int var2);

    public final long size() {
        return (long)this._rlen * (long)this._odims[0];
    }

    public abstract int size(int var1);

    public abstract long capacity();

    protected abstract long computeNnz(int var1, int var2, int var3);

    public abstract long countNonZeros();

    public abstract int countNonZeros(int var1);

    public abstract long countNonZeros(int var1, int var2, int var3, int var4);

    public abstract double[] values(int var1);

    public abstract double[] valuesAt(int var1);

    public abstract int index(int var1);

    public abstract int pos(int var1);

    public abstract int pos(int var1, int var2);

    public abstract int pos(int[] var1);

    public abstract void incr(int var1, int var2);

    public abstract void incr(int var1, int var2, double var3);

    protected abstract void fillBlock(int var1, int var2, int var3, double var4);

    protected abstract void setInternal(int var1, int var2, double var3);

    public abstract DenseBlock set(double var1);

    public DenseBlock set(String s) {
        this.set(Double.parseDouble(s));
        return this;
    }

    public abstract DenseBlock set(int var1, int var2, int var3, int var4, double var5);

    public abstract DenseBlock set(int var1, int var2, double var3);

    public abstract DenseBlock set(int var1, double[] var2);

    public abstract DenseBlock set(DenseBlock var1);

    public DenseBlock set(int rl, int ru, int cl, int cu, DenseBlock db) {
        boolean FP64;
        boolean allColumns = cl == 0 && cu == this._odims[0];
        boolean bl = FP64 = this.isNumeric(Types.ValueType.FP64) && db.isNumeric(Types.ValueType.FP64);
        if (db.isNumeric()) {
            int rowOther = 0;
            for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
                int brl = Math.max(rl - bi * this.blockSize(), 0);
                int bru = Math.min(ru - bi * this.blockSize(), this.blockSize());
                int offset = brl * this._odims[0] + cl;
                int clen = cu - cl;
                int r = brl;
                while (r < bru) {
                    if (!FP64) {
                        for (int c = 0; c < clen; ++c) {
                            this.setInternal(bi, offset + c, db.get(rowOther, c));
                        }
                    } else {
                        System.arraycopy(db.values(rowOther), db.pos(rowOther), this.valuesAt(bi), offset, clen);
                    }
                    ++r;
                    offset += this._odims[0];
                    ++rowOther;
                }
            }
        } else {
            int[] otherIx = new int[db.numDims()];
            for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
                int i;
                String[] data = this instanceof DenseBlockString ? ((DenseBlockString)this)._data : ((DenseBlockLString)this)._blocks[bi];
                if (allColumns) {
                    int offset = rl * this._odims[0] + cl;
                    for (i = 0; i < (ru - rl) * this._odims[0]; ++i) {
                        data[offset + i] = db.getString(otherIx);
                        this.getNextIndexes(otherIx);
                    }
                } else {
                    int len = cu - cl;
                    i = rl;
                    int ix1 = rl * this._odims[0] + cl;
                    while (i < ru) {
                        for (int ix = 0; ix < len; ++ix) {
                            data[ix1 + ix] = db.getString(otherIx);
                            this.getNextIndexes(otherIx);
                        }
                        otherIx[0] = i - rl + 1;
                        otherIx[1] = 0;
                        Arrays.fill(otherIx, 2, otherIx.length, 0);
                        ++i;
                        ix1 += this._odims[0];
                    }
                }
                rl = 0;
            }
        }
        return this;
    }

    public void getNextIndexes(int[] ix) {
        int i;
        int n = i = ix.length - 1;
        ix[n] = ix[n] + 1;
        if (ix[i] == this.getDim(i)) {
            while (ix[i] == this.getDim(i) && i - 1 >= 0) {
                ix[i] = 0;
                int n2 = --i;
                ix[n2] = ix[n2] + 1;
            }
        }
    }

    public DenseBlock set(KahanObject kbuff) {
        this.set(0, 0, kbuff._sum);
        this.set(0, 1, kbuff._correction);
        return this;
    }

    public abstract DenseBlock set(int[] var1, double var2);

    public abstract DenseBlock set(int[] var1, long var2);

    public abstract DenseBlock set(int[] var1, String var2);

    public DenseBlock set(int r, KahanObject kbuff) {
        this.set(r, 0, kbuff._sum);
        this.set(r, 1, kbuff._correction);
        return this;
    }

    @Override
    public abstract double get(int var1, int var2);

    public abstract double get(int[] var1);

    public abstract String getString(int[] var1);

    public abstract long getLong(int[] var1);

    public boolean contains(double pattern) {
        boolean NaNpattern = Double.isNaN(pattern);
        for (int i = 0; i < this.numBlocks(); ++i) {
            double[] vals = this.valuesAt(i);
            int len = this.size(i);
            for (int j = 0; j < len; ++j) {
                if (vals[j] != pattern && (!NaNpattern || !Double.isNaN(vals[j]))) continue;
                return true;
            }
        }
        return false;
    }

    public List<Integer> contains(double[] pattern, boolean earlyAbort) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int clen = this._odims[0];
        for (int i = 0; i < this._rlen; ++i) {
            if (Arrays.equals(this.values(i), this.pos(i), this.pos(i) + clen, pattern, 0, clen)) {
                ret.add(i);
            }
            if (!earlyAbort || ret.size() <= 0) continue;
            return ret;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o instanceof DenseBlock) {
            return this.equals((DenseBlock)o, 2.2784756311113742E-305);
        }
        return false;
    }

    public boolean equals(DenseBlock o, double eps) {
        if (this.isContiguous() && o.isContiguous()) {
            return this.contiguousEquals(o, eps);
        }
        return this.genericEquals(o, eps);
    }

    private boolean contiguousEquals(DenseBlock o, double eps) {
        double[] va = this.values(0);
        double[] vb = o.values(0);
        int len = Math.min(va.length, vb.length);
        for (int i = 0; i < len; ++i) {
            if (!(Math.abs(va[i] - vb[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    private boolean genericEquals(DenseBlock o, double eps) {
        int nRows = this.getDim(0);
        int nCols = this.getDim(1);
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                if (!(Math.abs(this.get(i, j) - o.get(i, j)) > eps)) continue;
                return false;
            }
        }
        return true;
    }

    public void fill(double value) {
        this.reset(this._odims, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._odims[0] == 1) {
            sb.append("Printing column vector transposed:\n");
            for (int b = 0; b < this.numBlocks(); ++b) {
                for (double v : this.valuesAt(b)) {
                    sb.append(this.getNiceFormat(v));
                    sb.append(" ");
                }
            }
            sb.append("\n");
        } else {
            for (int i = 0; i < this._rlen; ++i) {
                double[] data = this.values(i);
                int ix = this.pos(i);
                for (int j = 0; j < this._odims[0]; ++j) {
                    double v = data[ix + j];
                    sb.append(this.getNiceFormat(v));
                    sb.append("  ");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String getNiceFormat(double v) {
        if (v == (double)((long)v)) {
            return Long.toString((long)v);
        }
        return Double.toString(v);
    }

    protected double[] getReuseRow(boolean reset) {
        if (this._reuse != null && reset) {
            Arrays.fill(this._reuse, 0.0);
        }
        if (this._reuse == null) {
            this._reuse = new double[this._odims[0]];
        }
        return this._reuse;
    }

    private static int[] createDimOffsets(int[] dims) {
        int[] ret = new int[dims.length - 1];
        int prod = 1;
        for (int i = dims.length - 1; i >= 1; --i) {
            ret[i - 1] = prod *= dims[i];
        }
        return ret;
    }

    public static enum Type {
        DRB,
        LDRB;

    }
}

