/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import scala.Tuple2;

public class CentralMomentSPInstruction
extends UnarySPInstruction {
    private CentralMomentSPInstruction(CMOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super(SPInstruction.SPType.CentralMoment, op, in1, in2, in3, out, opcode, str);
    }

    public static CentralMomentSPInstruction parseInstruction(String str) {
        int cmOrder;
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cm")) {
            throw new DMLRuntimeException("Unsupported opcode " + opcode);
        }
        if (parts.length == 4) {
            in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CentralMomentSPInstruction.parseUnaryInstruction(str, in1, in2, out);
        } else if (parts.length == 5) {
            in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            in3 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CentralMomentSPInstruction.parseUnaryInstruction(str, in1, in2, in3, out);
        }
        try {
            cmOrder = in3 == null ? Integer.parseInt(in2.getName()) : Integer.parseInt(in3.getName());
        }
        catch (NumberFormatException e) {
            cmOrder = -1;
        }
        CMOperator.AggregateOperationTypes opType = CMOperator.getCMAggOpType(cmOrder);
        CMOperator cm = new CMOperator(CM.getCMFnObject(opType), opType);
        return new CentralMomentSPInstruction(cm, in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CPOperand scalarInput = this.input3 == null ? this.input2 : this.input3;
        ScalarObject order = ec.getScalarInput(scalarInput);
        CMOperator cop = (CMOperator)this._optr;
        if (cop.getAggOpType() == CMOperator.AggregateOperationTypes.INVALID) {
            cop.setCMAggOp((int)order.getLongValue());
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        CM_COV_Object cmobj = null;
        if (this.input3 == null) {
            cmobj = (CM_COV_Object)in1.values().map((Function)new RDDCMFunction(cop)).fold((Object)new CM_COV_Object(), (Function2)new RDDCMReduceFunction(cop));
        } else {
            JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName());
            cmobj = (CM_COV_Object)in1.join(in2).values().map((Function)new RDDCMWeightsFunction(cop)).fold((Object)new CM_COV_Object(), (Function2)new RDDCMReduceFunction(cop));
        }
        double val = cmobj.getRequiredResult(this._optr);
        ec.setScalarOutput(this.output.getName(), new DoubleObject(val));
    }

    private static class RDDCMReduceFunction
    implements Function2<CM_COV_Object, CM_COV_Object, CM_COV_Object> {
        private static final long serialVersionUID = 3272260751983866544L;
        private CMOperator _op = null;

        public RDDCMReduceFunction(CMOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(CM_COV_Object arg0, CM_COV_Object arg1) throws Exception {
            this._op.fn.execute((Data)arg0, arg1);
            return arg0;
        }
    }

    private static class RDDCMWeightsFunction
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, CM_COV_Object> {
        private static final long serialVersionUID = -8949715516574052497L;
        private CMOperator _op = null;

        public RDDCMWeightsFunction(CMOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            MatrixBlock input = (MatrixBlock)arg0._1();
            MatrixBlock weights = (MatrixBlock)arg0._2();
            return input.cmOperations(this._op, weights);
        }
    }

    private static class RDDCMFunction
    implements Function<MatrixBlock, CM_COV_Object> {
        private static final long serialVersionUID = 2293839116041610644L;
        private CMOperator _op = null;

        public RDDCMFunction(CMOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(MatrixBlock arg0) throws Exception {
            return arg0.cmOperations(this._op);
        }
    }
}

