/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.io.CompressWrap;
import org.apache.sysds.runtime.compress.io.CompressedWriteBlock;
import org.apache.sysds.runtime.compress.io.ReaderCompressed;
import org.apache.sysds.runtime.compress.lib.CLALibSlice;
import org.apache.sysds.runtime.instructions.spark.CompressionSPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.HDFSTool;

public final class WriterCompressed
extends MatrixWriter {
    protected static final Log LOG = LogFactory.getLog((String)ReaderCompressed.class.getName());

    public static WriterCompressed create(FileFormatProperties props) {
        return new WriterCompressed();
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname) throws IOException {
        WriterCompressed.writeCompressedMatrixToHDFS(src, fname, src.getNumRows(), src.getNumColumns(), 1000, src.getNonZeros(), false);
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname, int blen) throws IOException {
        WriterCompressed.writeCompressedMatrixToHDFS(src, fname, src.getNumRows(), src.getNumColumns(), blen, src.getNonZeros(), false);
    }

    public static void writeCompressedMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException {
        WriterCompressed.create(null).writeMatrixToHDFS(src, fname, rlen, clen, blen, nnz, diag);
    }

    public static void writeRDDToHDFS(JavaPairRDD<MatrixIndexes, MatrixBlock> src, String path, int blen, DataCharacteristics mc) {
        DataCharacteristics outC = new MatrixCharacteristics(mc).setBlocksize(blen);
        WriterCompressed.writeRDDToHDFS(RDDConverterUtils.binaryBlockToBinaryBlock(src, mc, outC), path);
    }

    public static void writeRDDToHDFS(JavaPairRDD<MatrixIndexes, MatrixBlock> src, String path) {
        src.mapValues((Function)new CompressionSPInstruction.CompressionFunction()).mapValues((Function)new CompressWrap()).saveAsHadoopFile(path, MatrixIndexes.class, CompressedWriteBlock.class, SequenceFileOutputFormat.class);
    }

    @Override
    public void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException {
        if (blen <= 0) {
            throw new DMLRuntimeException("Invalid block size for writing to disk");
        }
        if (diag) {
            throw new DMLRuntimeException("Not supported diag for compressed writing.");
        }
        if (fname == null) {
            throw new DMLRuntimeException("Invalid missing path.");
        }
        if (src == null) {
            throw new DMLRuntimeException("Null matrix block invalid");
        }
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new DMLRuntimeException("Invalid number of rows or columns specified not matching");
        }
        this.write(src, fname, blen);
    }

    @Override
    public void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException {
        if (rlen <= 0L) {
            throw new RuntimeException("Invalid empty write with rlen : " + rlen);
        }
        if (clen <= 0L) {
            throw new RuntimeException("Invalid empty write with clen : " + clen);
        }
        if (blen <= 0) {
            throw new RuntimeException("Invalid empty write with blen " + blen);
        }
        if (rlen > Integer.MAX_VALUE || clen > Integer.MAX_VALUE) {
            throw new RuntimeException("Unable to create compressed matrix block larger than IntMax");
        }
        if (fname == null) {
            throw new RuntimeException("Invalid null file name to write to");
        }
        CompressedMatrixBlock m = CompressedMatrixBlockFactory.createConstant((int)rlen, (int)clen, 0.0);
        this.write(m, fname, blen);
    }

    private void write(MatrixBlock src, String fname, int blen) throws IOException {
        int k = OptimizerUtils.getParallelTextWriteParallelism();
        Path path = new Path(fname);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        HDFSTool.deleteFileIfExistOnHDFS(path, job);
        SequenceFile.Writer w = SequenceFile.createWriter((Configuration)job, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.bufferSize((int)4096), SequenceFile.Writer.blockSize((long)4096L), SequenceFile.Writer.keyClass(MatrixIndexes.class), SequenceFile.Writer.valueClass(CompressedWriteBlock.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE), SequenceFile.Writer.replication((short)1)});
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        if (!(src instanceof CompressedMatrixBlock)) {
            src = (MatrixBlock)CompressedMatrixBlockFactory.compress(src, k).getLeft();
        }
        if (rlen <= blen && clen <= blen) {
            this.writeSingleBlock(w, src, k);
        } else {
            this.writeMultiBlock(w, src, rlen, clen, blen, k);
        }
        IOUtilFunctions.closeSilently((Closeable)w);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    private void writeSingleBlock(SequenceFile.Writer w, MatrixBlock b, int k) throws IOException {
        MatrixIndexes idx = new MatrixIndexes(1L, 1L);
        MatrixBlock mc = (MatrixBlock)CompressedMatrixBlockFactory.compress(b, k).getLeft();
        w.append((Writable)idx, (Writable)new CompressedWriteBlock(mc));
    }

    private void writeMultiBlock(SequenceFile.Writer w, MatrixBlock b, int rlen, int clen, int blen, int k) throws IOException {
        MatrixIndexes indexes = new MatrixIndexes();
        if (!(b instanceof CompressedMatrixBlock)) {
            LOG.warn((Object)"Writing compressed format with non identical compression scheme");
        }
        int bc = 0;
        while (bc * blen < clen) {
            int sC = bc * blen;
            int mC = Math.min(sC + blen, clen) - 1;
            if (b instanceof CompressedMatrixBlock) {
                CompressedMatrixBlock mc = CLALibSlice.sliceColumns((CompressedMatrixBlock)b, sC, mC);
                List<MatrixBlock> blocks = CLALibSlice.sliceBlocks(mc, blen);
                int br = 0;
                while (br * blen < rlen) {
                    indexes.setIndexes(br + 1, bc + 1);
                    w.append((Writable)indexes, (Writable)new CompressedWriteBlock(blocks.get(br)));
                    ++br;
                }
            } else {
                int br = 0;
                while (br * blen < rlen) {
                    int sR = br * blen;
                    int mR = Math.min(sR + blen, rlen) - 1;
                    MatrixBlock mb = b.slice(sR, mR, sC, mC);
                    MatrixBlock mc = (MatrixBlock)CompressedMatrixBlockFactory.compress(mb, k).getLeft();
                    indexes.setIndexes(br + 1, bc + 1);
                    w.append((Writable)indexes, (Writable)new CompressedWriteBlock(mc));
                    ++br;
                }
            }
            ++bc;
        }
    }
}

