/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHedgingProxyProvider<T>
extends ConfiguredFailoverProxyProvider<T> {
    public static final Logger LOG = LoggerFactory.getLogger(RequestHedgingProxyProvider.class);
    private FailoverProxyProvider.ProxyInfo<T> currentUsedHandler = null;
    private volatile String toIgnore = null;

    public RequestHedgingProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> proxyFactory) {
        super(conf, uri, xface, proxyFactory);
    }

    @Override
    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.currentUsedHandler != null) {
            return this.currentUsedHandler;
        }
        HashMap targetProxyInfos = new HashMap();
        StringBuilder combinedInfo = new StringBuilder("[");
        for (int i = 0; i < this.proxies.size(); ++i) {
            FailoverProxyProvider.ProxyInfo pInfo = super.getProxy();
            this.incrementProxyIndex();
            targetProxyInfos.put(pInfo.proxyInfo, pInfo);
            combinedInfo.append(pInfo.proxyInfo).append(',');
        }
        combinedInfo.append(']');
        Object wrappedProxy = Proxy.newProxyInstance(RequestHedgingInvocationHandler.class.getClassLoader(), new Class[]{this.xface}, (InvocationHandler)new RequestHedgingInvocationHandler(targetProxyInfos));
        this.currentUsedHandler = new FailoverProxyProvider.ProxyInfo(wrappedProxy, combinedInfo.toString());
        return this.currentUsedHandler;
    }

    @Override
    public synchronized void performFailover(T currentProxy) {
        this.toIgnore = ((RequestHedgingInvocationHandler)((RequestHedgingInvocationHandler)Proxy.getInvocationHandler((Object)this.currentUsedHandler.proxy))).currentUsedProxy.proxyInfo;
        this.currentUsedHandler = null;
    }

    private void logProxyException(Exception ex, String proxyInfo) {
        if (this.isStandbyException(ex)) {
            LOG.debug("Invocation returned standby exception on [{}]", (Object)proxyInfo, (Object)ex);
        } else {
            LOG.warn("Invocation returned exception on [{}]", (Object)proxyInfo, (Object)ex);
        }
    }

    private boolean isStandbyException(Exception exception) {
        if (exception instanceof RemoteException) {
            return ((RemoteException)((Object)exception)).unwrapRemoteException() instanceof StandbyException;
        }
        return false;
    }

    private Exception unwrapExecutionException(ExecutionException ex) {
        Throwable cause;
        if (ex != null && (cause = ex.getCause()) instanceof InvocationTargetException) {
            return this.unwrapInvocationTargetException((InvocationTargetException)cause);
        }
        return ex;
    }

    private Exception unwrapInvocationTargetException(InvocationTargetException ex) {
        Throwable cause;
        if (ex != null && (cause = ex.getCause()) instanceof Exception) {
            return (Exception)cause;
        }
        return ex;
    }

    class RequestHedgingInvocationHandler
    implements InvocationHandler {
        final Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies;
        private volatile FailoverProxyProvider.ProxyInfo<T> currentUsedProxy = null;

        public RequestHedgingInvocationHandler(Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies) {
            this.targetProxies = new HashMap(targetProxies);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (this.currentUsedProxy == null) {
                RequestHedgingInvocationHandler requestHedgingInvocationHandler = this;
                synchronized (requestHedgingInvocationHandler) {
                    if (this.currentUsedProxy == null) {
                        HashMap proxyMap = new HashMap();
                        int numAttempts = 0;
                        ExecutorService executor = null;
                        this.targetProxies.remove(RequestHedgingProxyProvider.this.toIgnore);
                        if (this.targetProxies.size() == 0) {
                            LOG.trace("No valid proxies left");
                            throw new RemoteException(IOException.class.getName(), "No valid proxies left. All NameNode proxies have failed over.");
                        }
                        if (this.targetProxies.size() == 1) {
                            Object object;
                            FailoverProxyProvider.ProxyInfo proxyInfo = this.targetProxies.values().iterator().next();
                            try {
                                this.currentUsedProxy = proxyInfo;
                                Object retVal = method.invoke(proxyInfo.proxy, args);
                                LOG.debug("Invocation successful on [{}]", (Object)this.currentUsedProxy.proxyInfo);
                                object = retVal;
                            }
                            catch (InvocationTargetException ex) {
                                Exception unwrappedException = RequestHedgingProxyProvider.this.unwrapInvocationTargetException(ex);
                                RequestHedgingProxyProvider.this.logProxyException(unwrappedException, this.currentUsedProxy.proxyInfo);
                                LOG.trace("Unsuccessful invocation on [{}]", (Object)this.currentUsedProxy.proxyInfo);
                                throw unwrappedException;
                            }
                            return object;
                        }
                        executor = Executors.newFixedThreadPool(RequestHedgingProxyProvider.this.proxies.size());
                        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executor);
                        for (final Map.Entry pEntry : this.targetProxies.entrySet()) {
                            Callable<Object> c = new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    LOG.trace("Invoking method {} on proxy {}", (Object)method, (Object)((FailoverProxyProvider.ProxyInfo)pEntry.getValue()).proxyInfo);
                                    return method.invoke(((FailoverProxyProvider.ProxyInfo)pEntry.getValue()).proxy, args);
                                }
                            };
                            proxyMap.put(completionService.submit(c), pEntry.getValue());
                            ++numAttempts;
                        }
                        HashMap<String, Exception> badResults = new HashMap<String, Exception>();
                        while (numAttempts > 0) {
                            Future callResultFuture = completionService.take();
                            try {
                                this.currentUsedProxy = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                                Object retVal = callResultFuture.get();
                                LOG.debug("Invocation successful on [{}]", (Object)this.currentUsedProxy.proxyInfo);
                                return retVal;
                            }
                            catch (ExecutionException ex) {
                                Exception unwrappedException = RequestHedgingProxyProvider.this.unwrapExecutionException(ex);
                                FailoverProxyProvider.ProxyInfo tProxyInfo = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                                RequestHedgingProxyProvider.this.logProxyException(unwrappedException, tProxyInfo.proxyInfo);
                                badResults.put(tProxyInfo.proxyInfo, unwrappedException);
                                LOG.trace("Unsuccessful invocation on [{}]", (Object)tProxyInfo.proxyInfo);
                                --numAttempts;
                            }
                        }
                        if (badResults.size() != 1) throw new MultiException(badResults);
                        throw (Exception)badResults.values().iterator().next();
                        finally {
                            if (executor != null) {
                                LOG.trace("Shutting down threadpool executor");
                                executor.shutdownNow();
                            }
                        }
                    }
                }
            }
            try {
                Object retVal = method.invoke(this.currentUsedProxy.proxy, args);
                LOG.debug("Invocation successful on [{}]", (Object)this.currentUsedProxy.proxyInfo);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                Exception unwrappedException = RequestHedgingProxyProvider.this.unwrapInvocationTargetException(ex);
                RequestHedgingProxyProvider.this.logProxyException(unwrappedException, this.currentUsedProxy.proxyInfo);
                LOG.trace("Unsuccessful invocation on [{}]", (Object)this.currentUsedProxy.proxyInfo);
                throw unwrappedException;
            }
        }
    }
}

